/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.ui.editor.jad;

import eclipseme.model.DescriptorPropertyDescription;
import eclipseme.ui.editor.jad.AbstractJADEditorPage;
import eclipseme.ui.editor.jad.JADEditor;
import eclipseme.utils.ManifestPreferenceStore;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;

public class JADPropertiesEditorPage
extends AbstractJADEditorPage {
    private DescriptorPropertyDescription[] descriptors;
    private FieldEditor[] fieldEditors;

    public JADPropertiesEditorPage(JADEditor editor, String title, DescriptorPropertyDescription[] descriptors) {
        super(editor, title);
        this.descriptors = descriptors;
    }

    public void doSave(IProgressMonitor monitor) {
        monitor.setTaskName(this.getTitle());
        int i = 0;
        while (i < this.fieldEditors.length) {
            this.fieldEditors[i].store();
            ++i;
        }
        this.setDirty(false);
    }

    public void setFocus() {
        if (this.fieldEditors.length > 0) {
            this.fieldEditors[0].setFocus();
        }
    }

    protected void addPageControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setBackground(parent.getBackground());
        this.fieldEditors = new FieldEditor[this.descriptors.length];
        int i = 0;
        while (i < this.descriptors.length) {
            switch (this.descriptors[i].getDataType()) {
                case 3: {
                    this.fieldEditors[i] = new IntegerFieldEditor(this.descriptors[i].getPropertyName(), this.descriptors[i].getDisplayName(), composite);
                    break;
                }
                default: {
                    this.fieldEditors[i] = new StringFieldEditor(this.descriptors[i].getPropertyName(), this.descriptors[i].getDisplayName(), composite);
                }
            }
            Label label = this.fieldEditors[i].getLabelControl(composite);
            label.setBackground(parent.getBackground());
            this.fieldEditors[i].setPropertyChangeListener((IPropertyChangeListener)this);
            ++i;
        }
        this.updateEditComponents();
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.updateEditComponents();
    }

    private void updateEditComponents() {
        if (this.fieldEditors != null) {
            ManifestPreferenceStore store = this.getPreferenceStore();
            int i = 0;
            while (i < this.fieldEditors.length) {
                FieldEditor fieldEditor = this.fieldEditors[i];
                fieldEditor.setPreferenceStore((IPreferenceStore)store);
                fieldEditor.load();
                ++i;
            }
        }
    }
}

