/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.ui.editor.jad;

import eclipseme.EclipseMEPlugin;
import eclipseme.ui.editor.jad.AbstractJADEditorPage;
import eclipseme.ui.editor.jad.JADEditor;
import eclipseme.utils.ManifestPreferenceStore;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;

public class JADUserDefinedPropertiesEditorPage
extends AbstractJADEditorPage {
    private List userDefinedProperties = new ArrayList();
    private TableViewer tableViewer;
    private Button removeButton;
    private Button addButton;

    public JADUserDefinedPropertiesEditorPage(JADEditor editor, String title) {
        super(editor, title);
    }

    public void doSave(IProgressMonitor monitor) {
        ManifestPreferenceStore store = this.getPreferenceStore();
        Iterator entries = this.userDefinedProperties.iterator();
        while (entries.hasNext()) {
            KeyValuePair entry = (KeyValuePair)entries.next();
            store.setValue(entry.key, entry.value);
        }
        this.setDirty(false);
    }

    public void setFocus() {
        this.tableViewer.getTable().setFocus();
    }

    protected void addPageControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setBackground(parent.getBackground());
        this.createTableViewer(composite);
        this.createButtons(composite);
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        if (this.tableViewer != null) {
            this.tableViewer.setInput((Object)input);
        }
        this.setDirty(false);
        this.updateMidletProperties();
    }

    private void addItem() {
        NewEntryDialog dialog = new NewEntryDialog(this.getSite().getShell());
        if (dialog.open() == 0) {
            this.tableViewer.refresh();
            this.setDirty(true);
        }
    }

    private void createButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        FillLayout layout = new FillLayout();
        layout.type = 512;
        composite.setLayout((Layout)layout);
        this.addButton = new Button(composite, 0);
        this.addButton.setText(AbstractJADEditorPage.getResourceString("editor.button.add"));
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                JADUserDefinedPropertiesEditorPage.this.addItem();
            }
        });
        Label l = new Label(composite, 0);
        l.setBackground(parent.getBackground());
        this.removeButton = new Button(composite, 0);
        this.removeButton.setText(AbstractJADEditorPage.getResourceString("editor.button.remove"));
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                JADUserDefinedPropertiesEditorPage.this.removeSelectedItems();
            }
        });
    }

    private void createTableViewer(Composite parent) {
        String[] columns = new String[]{AbstractJADEditorPage.getResourceString("property.jad.userdef.key"), AbstractJADEditorPage.getResourceString("property.jad.userdef.value")};
        this.tableViewer = new TableViewer(parent, 68356);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem selected = (TableItem)e.item;
                JADUserDefinedPropertiesEditorPage.this.removeButton.setEnabled(selected.getParent().getSelectionCount() > 0);
            }
        });
        TableLayout layout = new TableLayout();
        int width = 100 / columns.length;
        int i = 0;
        while (i < columns.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(columns[i]);
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(width));
            ++i;
        }
        table.setLayout((Layout)layout);
        this.tableViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.tableViewer.setInput((Object)this.getEditorInput());
        this.tableViewer.refresh();
    }

    private void removeSelectedItems() {
        int[] indices = this.tableViewer.getTable().getSelectionIndices();
        int i = indices.length;
        while (i > 0) {
            int index = indices[i - 1];
            this.userDefinedProperties.remove(index);
            --i;
        }
        this.setDirty(true);
        this.tableViewer.refresh();
    }

    private void updateMidletProperties() {
        this.userDefinedProperties.clear();
        ManifestPreferenceStore store = this.getPreferenceStore();
        String[] names = store.preferenceNames();
        int i = 0;
        while (i < names.length) {
            String propName = names[i];
            if (!propName.startsWith("MIDlet-") && !propName.startsWith("MicroEdition")) {
                this.userDefinedProperties.add(new KeyValuePair(propName, store.getString(propName)));
            }
            ++i;
        }
        if (this.tableViewer != null) {
            this.tableViewer.refresh();
        }
    }

    private class KeyValuePair {
        String key;
        String value;

        KeyValuePair(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }

    private class NewEntryDialog
    extends Dialog {
        private Text keyText;
        private Text valueText;

        protected NewEntryDialog(Shell parentShell) {
            super(parentShell);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(EclipseMEPlugin.getResourceString("dialog.newproperty.title"));
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            Label keyLabel = new Label(composite, 0);
            keyLabel.setText(EclipseMEPlugin.getResourceString("dialog.newproperty.key"));
            this.keyText = new Text(composite, 2048);
            Label valueLabel = new Label(composite, 0);
            valueLabel.setText(EclipseMEPlugin.getResourceString("dialog.newproperty.value"));
            this.valueText = new Text(composite, 2048);
            return composite;
        }

        protected void okPressed() {
            JADUserDefinedPropertiesEditorPage.this.userDefinedProperties.add(new KeyValuePair(this.keyText.getText(), this.valueText.getText()));
            super.okPressed();
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return JADUserDefinedPropertiesEditorPage.this.userDefinedProperties.toArray(new Object[JADUserDefinedPropertiesEditorPage.this.userDefinedProperties.size()]);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            KeyValuePair pair = (KeyValuePair)element;
            return columnIndex == 0 ? pair.key : pair.value;
        }
    }
}

