/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.ui.launching;

import eclipseme.EclipseMEPlugin;
import eclipseme.model.IMidletSuiteProject;
import eclipseme.model.IPlatformDefinition;
import eclipseme.model.impl.generic.MidletSuiteProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DeviceTab
extends AbstractLaunchConfigurationTab {
    public static final String DEFAULT_DEVICE = "DefaultColorPhone";
    public static final String[] DEFAULT_DEVICE_LIST = new String[]{"DefaultColorPhone"};
    private Label deviceLabel;
    private Combo deviceCombo;
    private IJavaProject javaProject;

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        comp.setLayout((Layout)topLayout);
        this.deviceLabel = new Label(comp, 0);
        this.deviceLabel.setText(EclipseMEPlugin.getResourceString("launchtab.device.device_label"));
        this.deviceLabel.setFont(font);
        this.deviceCombo = new Combo(comp, 12);
        this.deviceCombo.setItems(new String[0]);
        this.deviceCombo.setFont(font);
        this.deviceCombo.setLayoutData((Object)new GridData(768));
        this.deviceCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeviceTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    public Image getImage() {
        ImageDescriptor descriptor = EclipseMEPlugin.getIconImage("launch_device.gif");
        return descriptor.createImage();
    }

    public String getName() {
        return EclipseMEPlugin.getResourceString("launchtab.device.title");
    }

    public void initializeFrom(ILaunchConfiguration launchConfig) {
        String deviceName = this.getStringOrDefault(launchConfig, "eclipseme.emulated_device", DEFAULT_DEVICE);
        int index = this.deviceCombo.indexOf(deviceName);
        if (index < 0 || index >= this.deviceCombo.getItemCount()) {
            index = 0;
        }
        this.deviceCombo.select(index);
    }

    public void performApply(ILaunchConfigurationWorkingCopy launchConfig) {
        if (this.deviceCombo.getItemCount() > 0) {
            String deviceName = this.deviceCombo.getItem(this.deviceCombo.getSelectionIndex());
            launchConfig.setAttribute("eclipseme.emulated_device", deviceName);
        } else {
            launchConfig.setAttribute("eclipseme.emulated_device", DEFAULT_DEVICE);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy launchConfig) {
        launchConfig.setAttribute("eclipseme.emulated_device", DEFAULT_DEVICE);
    }

    public void setJavaProject(IJavaProject project) {
        if ((this.javaProject != null || project != null) && (this.javaProject == null && project != null || this.javaProject != null && project == null || !this.javaProject.equals(project))) {
            this.javaProject = project;
            this.updateDeviceList();
        }
    }

    private String getStringOrDefault(ILaunchConfiguration launchConfig, String attributeName, String defaultValue) {
        String value = null;
        try {
            value = launchConfig.getAttribute(attributeName, defaultValue);
        }
        catch (CoreException e) {
            EclipseMEPlugin.log(2, e);
            value = defaultValue;
        }
        return value;
    }

    private void updateDeviceList() {
        int selectionIndex = this.deviceCombo.getSelectionIndex();
        String deviceName = selectionIndex == -1 ? "" : this.deviceCombo.getItem(selectionIndex);
        String[] devices = DEFAULT_DEVICE_LIST;
        if (this.javaProject != null) {
            try {
                if (this.javaProject.getProject().isOpen()) {
                    IMidletSuiteProject midletProject = MidletSuiteProject.getMidletSuiteProject(this.javaProject);
                    IPlatformDefinition platformDefinition = midletProject.getPlatformDefinition();
                    devices = platformDefinition.getEmulator().getDeviceNames();
                }
            }
            catch (CoreException e) {
                EclipseMEPlugin.log(2, "updateDeviceList", e);
            }
        }
        selectionIndex = 0;
        int i = 0;
        while (i < devices.length) {
            if (devices[i].equals(deviceName)) {
                selectionIndex = i;
                break;
            }
            ++i;
        }
        this.deviceCombo.setItems(devices);
        this.deviceCombo.setText(devices[selectionIndex]);
    }
}

