/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.ui.launching;

import eclipseme.EclipseMEPlugin;
import eclipseme.ui.launching.DeviceTab;
import eclipseme.utils.SubclassSearchScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.debug.ui.launchConfigurations.JavaMainTab;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;

public class MidletTab
extends JavaMainTab {
    private DeviceTab deviceTab;
    private Label projectLabel;
    private Label midletLabel;
    private Text midletText;
    private Button midletRadio;
    private Button otaRadio;

    private static String getResourceString(String key) {
        return EclipseMEPlugin.getResourceString(key);
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        comp.setLayout((Layout)topLayout);
        this.createVerticalSpacer(comp, 1);
        this.createProjectComponents(comp);
        this.createVerticalSpacer(comp, 1);
        this.createExecutableComponents(comp);
        this.updateEnablement();
    }

    public DeviceTab getDeviceTab() {
        return this.deviceTab;
    }

    public String getName() {
        return MidletTab.getResourceString("launchtab.midlet.title");
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.updateProjectFromConfig(config);
        String midletName = this.getStringOrDefault(config, "eclipseme.emulated_class", "");
        this.midletText.setText(midletName);
        boolean doOTA = true;
        try {
            doOTA = config.getAttribute("eclipseme.do_ota", true);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.midletRadio.setSelection(!doOTA);
        this.otaRadio.setSelection(doOTA);
        this.updateEnablement();
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String name = this.fProjText.getText().trim();
        if (name.length() > 0 && !EclipseMEPlugin.getWorkspace().getRoot().getProject(name).exists()) {
            this.setErrorMessage(MidletTab.getResourceString("launchtab.midlet.error_project_does_not_exist"));
            return false;
        }
        if (this.midletRadio.getSelection() && (name = this.midletText.getText().trim()).length() == 0) {
            this.setErrorMessage(MidletTab.getResourceString("launchtab.midlet.error_Midlet_not_specified"));
            return false;
        }
        return true;
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.fProjText.getText());
        config.setAttribute("eclipseme.do_ota", this.otaRadio.getSelection());
        config.setAttribute("eclipseme.emulated_class", this.midletText.getText());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        IJavaElement javaElement = this.getContext();
        if (javaElement != null) {
            this.initializeJavaProject(javaElement, config);
        } else {
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        }
        config.setAttribute("eclipseme.emulated_class", "");
    }

    public void setDeviceTab(DeviceTab tab) {
        this.deviceTab = tab;
    }

    protected void handleSearchButtonSelected() {
        IJavaSearchScope searchScope = null;
        try {
            IType type;
            Object[] results;
            IJavaProject javaProject = this.getJavaProject();
            if (javaProject == null || !javaProject.exists()) {
                searchScope = SearchEngine.createWorkspaceScope();
            } else {
                IType type2 = javaProject.findType("javax.microedition.midlet.MIDlet");
                searchScope = new SubclassSearchScope(javaProject, type2);
            }
            Shell shell = this.getShell();
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)this.getLaunchConfigurationDialog(), (IJavaSearchScope)searchScope, (int)6, (boolean)false, (String)"*");
            dialog.setTitle(MidletTab.getResourceString("launchtab.midlet.search.title"));
            dialog.setMessage(MidletTab.getResourceString("launchtab.midlet.search.desc"));
            if (dialog.open() == 0 && (results = dialog.getResult()) != null && results.length > 0 && (type = (IType)results[0]) != null) {
                this.midletText.setText(type.getFullyQualifiedName());
                javaProject = type.getJavaProject();
                this.fProjText.setText(javaProject.getElementName());
            }
        }
        catch (JavaModelException e) {
            EclipseMEPlugin.log(4, "Choose Midlet", e);
        }
    }

    private void createExecutableComponents(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        group.setText(" Executable ");
        GridLayout mainLayout = new GridLayout();
        mainLayout.numColumns = 2;
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        group.setLayout((Layout)mainLayout);
        GridData gd = new GridData(768);
        group.setLayoutData((Object)gd);
        group.setFont(font);
        this.midletRadio = new Button((Composite)group, 16);
        this.midletRadio.setSelection(true);
        this.midletRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MidletTab.this.updateEnablement();
                MidletTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.createMidletComponents(group);
        this.otaRadio = new Button((Composite)group, 16);
        this.otaRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MidletTab.this.updateEnablement();
                MidletTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.createOTAComponents(group);
    }

    private void createMidletComponents(Group parent) {
        Font font = parent.getFont();
        Composite composite = new Composite((Composite)parent, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.numColumns = 3;
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        composite.setLayout((Layout)mainLayout);
        GridData gd = new GridData(768);
        composite.setLayoutData((Object)gd);
        composite.setFont(font);
        this.midletLabel = new Label(composite, 0);
        this.midletLabel.setText(MidletTab.getResourceString("launchtab.midlet.midlet"));
        gd = new GridData();
        this.midletLabel.setLayoutData((Object)gd);
        this.midletLabel.setFont(font);
        this.midletText = new Text(composite, 2052);
        gd = new GridData(768);
        this.midletText.setLayoutData((Object)gd);
        this.midletText.setFont(font);
        this.midletText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                MidletTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fSearchButton = this.createPushButton(composite, MidletTab.getResourceString("launchtab.midlet.search"), null);
        this.fSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                MidletTab.this.handleSearchButtonSelected();
            }
        });
    }

    private void createOTAComponents(Group parent) {
        Font font = parent.getFont();
        Composite composite = new Composite((Composite)parent, 0);
        GridLayout mainLayout = new GridLayout();
        mainLayout.numColumns = 1;
        mainLayout.marginHeight = 0;
        mainLayout.marginWidth = 0;
        composite.setLayout((Layout)mainLayout);
        GridData gd = new GridData(768);
        composite.setLayoutData((Object)gd);
        composite.setFont(font);
        Label overTheAirLabel = new Label(composite, 0);
        overTheAirLabel.setText("Over the Air");
        gd = new GridData();
        this.midletLabel.setLayoutData((Object)gd);
        this.midletLabel.setFont(font);
    }

    private void createProjectComponents(Composite parent) {
        Font font = parent.getFont();
        Composite projComp = new Composite(parent, 0);
        GridLayout projLayout = new GridLayout();
        projLayout.numColumns = 2;
        projLayout.marginHeight = 0;
        projLayout.marginWidth = 0;
        projComp.setLayout((Layout)projLayout);
        GridData gd = new GridData(768);
        projComp.setLayoutData((Object)gd);
        projComp.setFont(font);
        this.projectLabel = new Label(projComp, 0);
        this.projectLabel.setText(MidletTab.getResourceString("launchtab.midlet.project"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.projectLabel.setLayoutData((Object)gd);
        this.projectLabel.setFont(font);
        this.fProjText = new Text(projComp, 2052);
        gd = new GridData(768);
        this.fProjText.setLayoutData((Object)gd);
        this.fProjText.setFont(font);
        this.fProjText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                MidletTab.this.updateLaunchConfigurationDialog();
                MidletTab.this.deviceTab.setJavaProject(MidletTab.this.getJavaProject());
            }
        });
        this.fProjButton = this.createPushButton(projComp, MidletTab.getResourceString("launchtab.midlet.browse"), null);
        this.fProjButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                MidletTab.this.handleProjectButtonSelected();
            }
        });
    }

    private String getStringOrDefault(ILaunchConfiguration launchConfig, String attributeName, String defaultValue) {
        String value = null;
        try {
            value = launchConfig.getAttribute(attributeName, defaultValue);
        }
        catch (CoreException e) {
            EclipseMEPlugin.log(2, e);
            value = defaultValue;
        }
        return value;
    }

    private void updateEnablement() {
        boolean doMidlet = this.midletRadio.getSelection();
        this.midletText.setEnabled(doMidlet);
        this.fSearchButton.setEnabled(doMidlet);
    }
}

