/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.ui.preferences;

import eclipseme.EclipseMEPlugin;
import eclipseme.IEclipseMEConstants;
import eclipseme.ObfuscationPreferencesWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ObfuscationPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
IEclipseMEConstants {
    private static final String PROP_EXPR = "expression";
    private static final String PROP_IGNORE = "ignore";
    private Button specifiedArgumentsButton;
    private Text specifiedArgumentsText;
    private TableViewer keepExpressionsViewer;
    private ObfuscationPreferencesWrapper prefsWrapper;
    private KeepExpressionHolder[] keepExpressions;

    public ObfuscationPreferencePage() {
        super(1);
        this.setPreferenceStore(EclipseMEPlugin.getDefault().getPreferenceStore());
        this.setDescription(this.getResourceString("pref.description"));
    }

    public void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        this.addField((FieldEditor)new DirectoryFieldEditor("proguard_dir", "Proguard Root Directory", parent));
        Font font = parent.getFont();
        this.specifiedArgumentsButton = new Button(parent, 32);
        this.specifiedArgumentsButton.setText("Use specified arguments:");
        this.specifiedArgumentsButton.setFont(font);
        this.specifiedArgumentsText = new Text(parent, 2052);
        this.specifiedArgumentsText.setFont(font);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.specifiedArgumentsText.setLayoutData((Object)gd);
        this.specifiedArgumentsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ObfuscationPreferencePage.this.specifiedArgumentsText.setEnabled(ObfuscationPreferencePage.this.specifiedArgumentsButton.getSelection());
            }
        });
        this.createKeepExpressionsControls(parent);
        this.addProguardNotes(parent, font);
    }

    public void init(IWorkbench workbench) {
    }

    protected void initialize() {
        super.initialize();
        IPreferenceStore store = this.getPreferenceStore();
        this.setState(store.getBoolean("proguard_use_specified"), store.getString("proguard_options"));
        this.prefsWrapper = EclipseMEPlugin.getObfuscationPreferencesWrapper();
        this.setKeepExpressions(this.prefsWrapper.getProguardKeepExpressions());
    }

    protected void performDefaults() {
        super.performDefaults();
        this.setState(false, "-dontnote -defaultpackage ''");
        this.setKeepExpressions(this.prefsWrapper.getDefaultProguardKeepExpressions());
    }

    public boolean performOk() {
        IPreferenceStore store = this.getPreferenceStore();
        boolean useSpecified = this.specifiedArgumentsButton.getSelection();
        store.setValue("proguard_use_specified", useSpecified);
        if (useSpecified) {
            String specified = this.specifiedArgumentsText.getText();
            store.setValue("proguard_options", specified);
        }
        String[] expressions = new String[this.keepExpressions.length];
        int i = 0;
        while (i < this.keepExpressions.length) {
            expressions[i] = this.keepExpressions[i].keepExpression;
            ++i;
        }
        this.prefsWrapper.setProguardKeepExpressions(expressions);
        return super.performOk();
    }

    private void addNewKeepExpression() {
        KeepExpressionHolder[] newExpressionArray = new KeepExpressionHolder[this.keepExpressions.length + 1];
        System.arraycopy(this.keepExpressions, 0, newExpressionArray, 0, this.keepExpressions.length);
        newExpressionArray[this.keepExpressions.length] = new KeepExpressionHolder("public class * extends javax.microedition.midlet.MIDlet");
        this.setKeepExpressions(newExpressionArray);
    }

    private void addProguardNotes(Composite parent, Font font) {
        Label notes = new Label(parent, 0);
        notes.setFont(font);
        notes.setText("NOTE: See Proguard documentation for more information");
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        notes.setLayoutData((Object)gd);
    }

    private void createKeepExpressionsControls(Composite parent) {
        String[] columns = new String[]{"Expression"};
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout(2, false));
        group.setLayoutData((Object)gridData);
        group.setText("Proguard Keep Expressions");
        this.keepExpressionsViewer = new TableViewer((Composite)group, 68356);
        this.keepExpressionsViewer.setColumnProperties(new String[]{PROP_EXPR, PROP_IGNORE});
        this.keepExpressionsViewer.setCellModifier((ICellModifier)new CellModifier());
        Table table = this.keepExpressionsViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        Composite buttonHolder = new Composite((Composite)group, 0);
        buttonHolder.setLayout((Layout)new GridLayout(1, true));
        Button addButton = new Button(buttonHolder, 8);
        addButton.setText("Add");
        addButton.setLayoutData((Object)new GridData(768));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ObfuscationPreferencePage.this.addNewKeepExpression();
            }
        });
        new Label(buttonHolder, 0);
        final Button removeButton = new Button(buttonHolder, 8);
        removeButton.setText("Remove");
        removeButton.setLayoutData((Object)new GridData(768));
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ObfuscationPreferencePage.this.removeSelectedKeepExpressions();
            }
        });
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem selected = (TableItem)e.item;
                removeButton.setEnabled(selected.getParent().getSelectionCount() > 0);
            }
        });
        CellEditor[] cellEditorArray = new CellEditor[2];
        cellEditorArray[0] = new TextCellEditor((Composite)table);
        this.keepExpressionsViewer.setCellEditors(cellEditorArray);
        TableLayout layout = new TableLayout();
        int width = 100 / columns.length;
        int i = 0;
        while (i < columns.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(columns[i]);
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(width));
            ++i;
        }
        table.setLayout((Layout)layout);
        this.keepExpressionsViewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.keepExpressionsViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
    }

    private String getResourceString(String key) {
        return EclipseMEPlugin.getResourceString(key);
    }

    private void removeSelectedKeepExpressions() {
        int[] indices = this.keepExpressionsViewer.getTable().getSelectionIndices();
        ArrayList<KeepExpressionHolder> temp = new ArrayList<KeepExpressionHolder>(Arrays.asList(this.keepExpressions));
        int i = indices.length;
        while (i > 0) {
            int index = indices[i - 1];
            temp.remove(index);
            --i;
        }
        this.setKeepExpressions(temp.toArray(new KeepExpressionHolder[temp.size()]));
    }

    private void setKeepExpressions(String[] expressions) {
        KeepExpressionHolder[] newExpressions = new KeepExpressionHolder[expressions.length];
        int i = 0;
        while (i < expressions.length) {
            newExpressions[i] = new KeepExpressionHolder(expressions[i]);
            ++i;
        }
        this.setKeepExpressions(newExpressions);
    }

    private void setKeepExpressions(KeepExpressionHolder[] expressions) {
        this.keepExpressions = expressions;
        this.keepExpressionsViewer.setInput((Object)this.keepExpressions);
        this.keepExpressionsViewer.refresh();
    }

    private void setState(boolean useSpecified, String specified) {
        this.specifiedArgumentsButton.setSelection(useSpecified);
        this.specifiedArgumentsText.setText(specified);
        this.specifiedArgumentsText.setEnabled(useSpecified);
    }

    private class KeepExpressionHolder {
        public String keepExpression;

        public KeepExpressionHolder(String keepExpression) {
            this.keepExpression = keepExpression;
        }

        public String toString() {
            return this.keepExpression;
        }
    }

    private class CellModifier
    implements ICellModifier {
        CellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return property != null && property.equals(ObfuscationPreferencePage.PROP_EXPR);
        }

        public Object getValue(Object element, String property) {
            String value = null;
            if (this.canModify(element, property)) {
                value = element.toString();
            }
            return value;
        }

        public void modify(Object element, String property, Object value) {
            if (element instanceof TableItem) {
                Object data = ((TableItem)element).getData();
                String newValue = (String)value;
                if (data instanceof KeepExpressionHolder) {
                    ((KeepExpressionHolder)data).keepExpression = newValue;
                    ObfuscationPreferencePage.this.keepExpressionsViewer.update(data, new String[]{property});
                }
            }
        }
    }

    private class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ObfuscationPreferencePage.this.keepExpressions;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            return columnIndex == 0 ? element.toString() : "";
        }
    }
}

