/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.ui.view.platformcomponents;

import eclipseme.model.IConfiguration;
import eclipseme.model.IPlatformDefinition;
import eclipseme.model.IProfile;
import eclipseme.model.IWirelessToolkit;
import eclipseme.model.impl.generic.PlatformDefinition;
import eclipseme.model.registry.PlatformComponentRegistry;
import eclipseme.ui.utils.PlatformComponentAction;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

class AddPlatformDefinitionAction
extends PlatformComponentAction {
    private static final String BASICS_PAGE = "page.platform.basics";
    private static final String CONTENTS_PAGE = "page.platform.contents";

    public AddPlatformDefinitionAction() {
        super("Add Platform Definition");
    }

    public void run() {
        WizardDialog wd = new WizardDialog(null, (IWizard)new AddPlatformDefinitionWizard());
        wd.create();
        wd.getShell().setText("Create Platform Definition");
        wd.setTitle("Create New Platform Definition");
        wd.open();
    }

    private class PlatformDefinitionBasicsWizardPage
    extends WizardPage {
        private Text nameText;
        private Combo toolkitCombo;
        private Combo platformDefinitionCombo;

        protected PlatformDefinitionBasicsWizardPage() {
            super(AddPlatformDefinitionAction.BASICS_PAGE, "Platform Definition", null);
            this.setDescription("Specify the Platform Definition basic information");
        }

        public void createControl(Composite parent) {
            Composite grid = new Composite(parent, 0);
            grid.setLayout((Layout)new GridLayout(2, false));
            this.setControl((Control)grid);
            new Label(grid, 0).setText("Platform Definition Name");
            this.nameText = new Text(grid, 2048);
            this.nameText.setLayoutData((Object)new GridData(768));
            this.nameText.addKeyListener((KeyListener)new KeyAdapter(this){
                final /* synthetic */ PlatformDefinitionBasicsWizardPage this$1;
                {
                    this.this$1 = platformDefinitionBasicsWizardPage;
                }

                public void keyReleased(KeyEvent event) {
                    PlatformDefinitionBasicsWizardPage.access$0(this.this$1);
                }
            });
            new Label(grid, 0).setText("Wireless Toolkit");
            this.toolkitCombo = this.buildToolkitCombo(grid);
            new Label(grid, 0).setText("Base Platform Definition");
            this.platformDefinitionCombo = new Combo(grid, 8);
            this.platformDefinitionCombo.setLayoutData((Object)new GridData(768));
            this.updateState();
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
        }

        String getPlatformDefinitionName() {
            return this.nameText.getText();
        }

        IPlatformDefinition getSelectedPlatformDefinition() {
            String defName = this.platformDefinitionCombo.getText();
            return AddPlatformDefinitionAction.this.getRegistry().getPlatformDefinition(defName);
        }

        IWirelessToolkit getSelectedToolkit() {
            String toolkitName = this.toolkitCombo.getText();
            return AddPlatformDefinitionAction.this.getRegistry().getWirelessToolkit(toolkitName);
        }

        private Combo buildToolkitCombo(Composite parent) {
            Combo combo = new Combo(parent, 8);
            combo.setLayoutData((Object)new GridData(768));
            combo.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ PlatformDefinitionBasicsWizardPage this$1;
                {
                    this.this$1 = platformDefinitionBasicsWizardPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    PlatformDefinitionBasicsWizardPage.access$1(this.this$1);
                }
            });
            Iterator iterator = AddPlatformDefinitionAction.this.getRegistry().getRegisteredWirelessToolkits();
            while (iterator.hasNext()) {
                IWirelessToolkit toolkit = (IWirelessToolkit)iterator.next();
                String name = toolkit.getName();
                combo.add(name);
            }
            combo.setText(combo.getItem(0));
            return combo;
        }

        private void updateState() {
            this.updatePlatformDefinitions();
            this.updateCompleteStatus();
        }

        private void updateCompleteStatus() {
            String message = null;
            String name = this.nameText.getText();
            if (name.length() == 0) {
                message = "Name must be specified";
            } else if (AddPlatformDefinitionAction.this.getRegistry().isPlatformDefinitionRegistered(name)) {
                message = "Platform Definition name already exists";
            }
            this.setErrorMessage(message);
            this.setPageComplete(message == null);
        }

        private void updatePlatformDefinitions() {
            IWirelessToolkit toolkit = this.getSelectedToolkit();
            IPlatformDefinition[] platformDefinitions = toolkit.getPlatformDefinitions();
            this.platformDefinitionCombo.removeAll();
            int i = 0;
            while (i < platformDefinitions.length) {
                this.platformDefinitionCombo.add(platformDefinitions[i].getName());
                ++i;
            }
            if (platformDefinitions.length > 0) {
                this.platformDefinitionCombo.setText(platformDefinitions[0].getName());
            }
        }

        static /* synthetic */ void access$0(PlatformDefinitionBasicsWizardPage platformDefinitionBasicsWizardPage) {
            platformDefinitionBasicsWizardPage.updateState();
        }

        static /* synthetic */ void access$1(PlatformDefinitionBasicsWizardPage platformDefinitionBasicsWizardPage) {
            platformDefinitionBasicsWizardPage.updatePlatformDefinitions();
        }
    }

    private class PlatformDefinitionContentsWizardPage
    extends WizardPage {
        private Combo configurationsCombo;
        private Button addButton;
        private Button removeButton;
        private List selectedProfilesList;
        private List availableProfilesList;
        private boolean availableProfilesInitialized;

        protected PlatformDefinitionContentsWizardPage() {
            super(AddPlatformDefinitionAction.BASICS_PAGE, "Platform Definition", null);
            this.setDescription("Specify the Platform Definition contents");
        }

        public void createControl(Composite parent) {
            Composite grid = new Composite(parent, 0);
            grid.setLayout((Layout)new GridLayout(2, false));
            this.setControl((Control)grid);
            new Label(grid, 0).setText("Configuration");
            this.configurationsCombo = this.buildConfigurationsCombo(grid);
            this.createProfileGroup(grid);
            this.updateStatus();
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (!this.availableProfilesInitialized) {
                this.fillInAvailableProfiles();
                this.availableProfilesInitialized = true;
            }
        }

        private void createProfileGroup(Composite parent) {
            GridData gd = new GridData(1808);
            gd.horizontalSpan = 2;
            Group profileGroup = new Group(parent, 0);
            profileGroup.setText("Profile Selection");
            profileGroup.setLayoutData((Object)gd);
            profileGroup.setLayout((Layout)new GridLayout(3, false));
            this.addAvailableProfilesGroup(profileGroup);
            this.addMovementButtons(profileGroup);
            this.addSelectedProfilesGroup(profileGroup);
        }

        private void addAvailableProfilesGroup(Group profileGroup) {
            Composite composite = new Composite((Composite)profileGroup, 0);
            composite.setLayout((Layout)new RowLayout(512));
            composite.setLayoutData((Object)new GridData(1040));
            new Label(composite, 0).setText("Available Profiles:");
            this.availableProfilesList = new List(composite, 2818);
            this.availableProfilesList.setLayoutData((Object)new RowData(200, 100));
            this.availableProfilesList.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ PlatformDefinitionContentsWizardPage this$1;
                {
                    this.this$1 = platformDefinitionContentsWizardPage;
                }

                public void widgetSelected(SelectionEvent evt) {
                    PlatformDefinitionContentsWizardPage.access$0(this.this$1);
                }
            });
        }

        private void addMovementButtons(Group profileGroup) {
            Composite composite = new Composite((Composite)profileGroup, 0);
            composite.setLayout((Layout)new GridLayout(1, true));
            composite.setLayoutData((Object)new GridData(1040));
            new Label(composite, 0);
            new Label(composite, 0);
            this.addButton = new Button(composite, 0);
            this.addButton.setText("Add >>");
            this.addButton.setLayoutData((Object)new GridData(768));
            this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ PlatformDefinitionContentsWizardPage this$1;
                {
                    this.this$1 = platformDefinitionContentsWizardPage;
                }

                public void widgetSelected(SelectionEvent evt) {
                    PlatformDefinitionContentsWizardPage.access$1(this.this$1);
                }
            });
            this.removeButton = new Button(composite, 0);
            this.removeButton.setText("<< Remove");
            this.removeButton.setLayoutData((Object)new GridData(768));
            this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ PlatformDefinitionContentsWizardPage this$1;
                {
                    this.this$1 = platformDefinitionContentsWizardPage;
                }

                public void widgetSelected(SelectionEvent evt) {
                    PlatformDefinitionContentsWizardPage.access$2(this.this$1);
                }
            });
        }

        private void addSelectedProfiles() {
            this.moveProfiles(this.availableProfilesList, this.selectedProfilesList);
        }

        private void addSelectedProfilesGroup(Group profileGroup) {
            Composite composite = new Composite((Composite)profileGroup, 0);
            composite.setLayout((Layout)new RowLayout(512));
            composite.setLayoutData((Object)new GridData(1040));
            new Label(composite, 0).setText("Selected Profiles:");
            this.selectedProfilesList = new List(composite, 2818);
            this.selectedProfilesList.setLayoutData((Object)new RowData(200, 100));
            this.selectedProfilesList.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ PlatformDefinitionContentsWizardPage this$1;
                {
                    this.this$1 = platformDefinitionContentsWizardPage;
                }

                public void widgetSelected(SelectionEvent evt) {
                    PlatformDefinitionContentsWizardPage.access$0(this.this$1);
                }
            });
        }

        private Combo buildConfigurationsCombo(Composite parent) {
            Combo combo = new Combo(parent, 8);
            combo.setLayoutData((Object)new GridData(768));
            Iterator iterator = AddPlatformDefinitionAction.this.getRegistry().getRegisteredConfigurations();
            while (iterator.hasNext()) {
                IConfiguration configuration = (IConfiguration)iterator.next();
                String name = configuration.getName();
                combo.add(name);
            }
            combo.setText(combo.getItem(0));
            return combo;
        }

        private void fillInAvailableProfiles() {
            Iterator profiles = AddPlatformDefinitionAction.this.getRegistry().getRegisteredProfiles();
            while (profiles.hasNext()) {
                IProfile profile = (IProfile)profiles.next();
                this.availableProfilesList.add(profile.getName());
            }
        }

        IConfiguration getSelectedConfiguration() {
            String name = this.configurationsCombo.getText();
            return AddPlatformDefinitionAction.this.getRegistry().getConfiguration(name);
        }

        IProfile[] getSelectedProfiles() {
            ArrayList<IProfile> list = new ArrayList<IProfile>();
            PlatformComponentRegistry registry = AddPlatformDefinitionAction.this.getRegistry();
            String[] selectedIndices = this.selectedProfilesList.getItems();
            int i = 0;
            while (i < selectedIndices.length) {
                IProfile profile = registry.getProfile(selectedIndices[i]);
                list.add(profile);
                ++i;
            }
            return list.toArray(new IProfile[list.size()]);
        }

        private void moveProfiles(List source, List target) {
            int[] selected = source.getSelectionIndices();
            int i = 0;
            while (i < selected.length) {
                String profileName = source.getItem(selected[i]);
                target.add(profileName);
                ++i;
            }
            source.remove(selected);
            this.updateStatus();
        }

        private void removeSelectedProfiles() {
            this.moveProfiles(this.selectedProfilesList, this.availableProfilesList);
        }

        private void updateButtonEnablement() {
            this.addButton.setEnabled(this.availableProfilesList.getSelectionCount() > 0);
            this.removeButton.setEnabled(this.selectedProfilesList.getSelectionCount() > 0);
        }

        private void updateStatus() {
            this.updateButtonEnablement();
            this.updateCompleteStatus();
        }

        private void updateCompleteStatus() {
            String message = null;
            if (this.selectedProfilesList.getItemCount() == 0) {
                message = "Profile must be selected";
            }
            this.setErrorMessage(message);
            this.setPageComplete(message == null);
        }

        static /* synthetic */ void access$0(PlatformDefinitionContentsWizardPage platformDefinitionContentsWizardPage) {
            platformDefinitionContentsWizardPage.updateButtonEnablement();
        }

        static /* synthetic */ void access$1(PlatformDefinitionContentsWizardPage platformDefinitionContentsWizardPage) {
            platformDefinitionContentsWizardPage.addSelectedProfiles();
        }

        static /* synthetic */ void access$2(PlatformDefinitionContentsWizardPage platformDefinitionContentsWizardPage) {
            platformDefinitionContentsWizardPage.removeSelectedProfiles();
        }
    }

    private class AddPlatformDefinitionWizard
    extends Wizard {
        private PlatformDefinitionBasicsWizardPage basicsPage;
        private PlatformDefinitionContentsWizardPage contentsPage;

        public AddPlatformDefinitionWizard() {
            this.basicsPage = new PlatformDefinitionBasicsWizardPage();
            this.addPage((IWizardPage)this.basicsPage);
            this.contentsPage = new PlatformDefinitionContentsWizardPage();
            this.addPage((IWizardPage)this.contentsPage);
        }

        public boolean performFinish() {
            IWirelessToolkit toolkit = this.basicsPage.getSelectedToolkit();
            IConfiguration config = this.contentsPage.getSelectedConfiguration();
            IPlatformDefinition basePlatformDefinition = this.basicsPage.getSelectedPlatformDefinition();
            PlatformDefinition platform = new PlatformDefinition(this.basicsPage.getPlatformDefinitionName(), this.basicsPage.getSelectedToolkit(), basePlatformDefinition.getRoot(), basePlatformDefinition.getEmulator(), basePlatformDefinition.getPreverifier(), config);
            IProfile[] profiles = this.contentsPage.getSelectedProfiles();
            int i = 0;
            while (i < profiles.length) {
                platform.addProfile(profiles[i]);
                profiles[i].addDependentComponent(platform);
                ++i;
            }
            AddPlatformDefinitionAction.this.getRegistry().add(platform);
            return AddPlatformDefinitionAction.this.updateComponentsStore((IProgressMonitor)new NullProgressMonitor());
        }
    }
}

