/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.ui.view.platformcomponents;

import eclipseme.model.IWirelessToolkit;
import eclipseme.model.Version;
import eclipseme.model.impl.generic.Profile;
import eclipseme.ui.utils.PlatformComponentAction;
import eclipseme.ui.view.platformcomponents.ProfileLibrariesWizardPage;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

class AddProfileAction
extends PlatformComponentAction {
    private static final String ADD_PROFILE_PAGE = "page.profile.add";
    private static final String ADD_PROFILE_LIBS_PAGE = "page.profile.libs";

    public AddProfileAction() {
        super("Add MIDP Profile");
    }

    public void run() {
        WizardDialog wd = new WizardDialog(null, (IWizard)new AddProfileWizard());
        wd.create();
        wd.getShell().setText("Create New MIDP Profile");
        wd.setTitle("Create New MIDP Profile");
        wd.open();
    }

    private class ProfileBasicsWizardPage
    extends WizardPage {
        private Combo toolkitCombo;
        private Text profileName;

        protected ProfileBasicsWizardPage() {
            super(AddProfileAction.ADD_PROFILE_PAGE, "MIDP Profile", null);
            this.setDescription("Specify the MIDP Profile information");
        }

        public void createControl(Composite parent) {
            Composite grid = new Composite(parent, 0);
            grid.setLayout((Layout)new GridLayout(2, false));
            this.setControl((Control)grid);
            Label nameText = new Label(grid, 0);
            nameText.setText("Profile Name");
            this.profileName = new Text(grid, 2048);
            this.profileName.setLayoutData((Object)new GridData(768));
            this.profileName.addKeyListener((KeyListener)new KeyAdapter(this){
                final /* synthetic */ ProfileBasicsWizardPage this$1;
                {
                    this.this$1 = profileBasicsWizardPage;
                }

                public void keyReleased(KeyEvent event) {
                    ProfileBasicsWizardPage.access$0(this.this$1);
                }
            });
            Label comboText = new Label(grid, 0);
            comboText.setText("Wireless Toolkit");
            this.toolkitCombo = this.buildToolkitCombo(grid);
            this.updateStatus();
        }

        String getProfileName() {
            return this.profileName.getText();
        }

        IWirelessToolkit getSelectedToolkit() {
            String toolkitName = this.toolkitCombo.getText();
            return AddProfileAction.this.getRegistry().getWirelessToolkit(toolkitName);
        }

        private Combo buildToolkitCombo(Composite parent) {
            Combo combo = new Combo(parent, 8);
            combo.setLayoutData((Object)new GridData(768));
            Iterator iterator = AddProfileAction.this.getRegistry().getRegisteredWirelessToolkits();
            while (iterator.hasNext()) {
                IWirelessToolkit toolkit = (IWirelessToolkit)iterator.next();
                combo.add(toolkit.getName());
            }
            combo.setText(combo.getItem(0));
            return combo;
        }

        private void updateStatus() {
            String message = null;
            String name = this.profileName.getText();
            if (name.length() == 0) {
                message = "Name must be specified";
            } else if (AddProfileAction.this.getRegistry().isProfileRegistered(name)) {
                message = "Profile name already exists";
            }
            this.setErrorMessage(message);
            this.setPageComplete(message == null);
        }

        static /* synthetic */ void access$0(ProfileBasicsWizardPage profileBasicsWizardPage) {
            profileBasicsWizardPage.updateStatus();
        }
    }

    private class AddProfileWizard
    extends Wizard {
        private ProfileBasicsWizardPage addPage;
        private ProfileLibrariesWizardPage libsPage;

        public AddProfileWizard() {
            this.addPage = new ProfileBasicsWizardPage();
            this.addPage((IWizardPage)this.addPage);
            this.libsPage = new ProfileLibrariesWizardPage(AddProfileAction.ADD_PROFILE_LIBS_PAGE);
            this.addPage((IWizardPage)this.libsPage);
        }

        public void createPageControls(Composite pageContainer) {
            super.createPageControls(pageContainer);
        }

        public boolean performFinish() {
            IWirelessToolkit toolkit = this.addPage.getSelectedToolkit();
            String name = this.addPage.getProfileName();
            IClasspathEntry[] libs = this.libsPage.getProfileLibraries();
            Profile profile = new Profile(toolkit, name, new Version("1.0"));
            profile.addLibraries(libs);
            AddProfileAction.this.getRegistry().add(profile);
            return AddProfileAction.this.updateComponentsStore((IProgressMonitor)new NullProgressMonitor());
        }
    }
}

