/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.ui.view.platformcomponents;

import eclipseme.EclipseMEPlugin;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.NewVariableEntryDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class ProfileLibrariesWizardPage
extends WizardPage {
    private TableViewer librariesViewer;
    private Button addJarButton;
    private Button addExternalJarButton;
    private Button addVariableButton;
    private Button removeButton;
    private ArrayList libraries = new ArrayList();

    public ProfileLibrariesWizardPage(String pageName) {
        super(pageName, "MIDP Profile Libraries", null);
    }

    public void createControl(Composite parent) {
        Composite outerGrid = new Composite(parent, 0);
        outerGrid.setLayoutData((Object)new GridData(1808));
        outerGrid.setLayout((Layout)new GridLayout(2, false));
        this.createLibrariesViewer(outerGrid);
        this.createActionButtons(outerGrid);
        this.updateStatus();
        this.setControl((Control)outerGrid);
    }

    IClasspathEntry[] getProfileLibraries() {
        return this.libraries.toArray(new IClasspathEntry[this.libraries.size()]);
    }

    private void addJarFile() {
        String title = "JAR Selection";
        String message = "Choose JAR/ZIP files to be added to profile";
        IWorkspaceRoot workspaceRoot = EclipseMEPlugin.getWorkspace().getRoot();
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setValidator((ISelectionStatusValidator)new JARSelectionValidator());
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.addFilter((ViewerFilter)new ArchiveViewerFilter(this.libraries));
        dialog.setInput((Object)workspaceRoot);
        dialog.setSorter((ViewerSorter)new ResourceSorter(1));
        if (this.libraries == null || this.libraries.size() == 0) {
            dialog.setInitialSelection((Object)workspaceRoot);
        } else {
            IClasspathEntry entry = (IClasspathEntry)this.libraries.get(0);
            dialog.setInitialSelection((Object)entry.getPath());
        }
        if (dialog.open() == 0) {
            Object[] elements = dialog.getResult();
            int i = 0;
            while (i < elements.length) {
                IResource resource = (IResource)elements[i];
                IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)resource.getFullPath(), null, null);
                this.libraries.add(entry);
                ++i;
            }
            this.librariesViewer.refresh();
            this.updateStatus();
        }
    }

    private void addClasspathVariableSelections() {
        NewVariableEntryDialog dialog = new NewVariableEntryDialog(this.getShell());
        dialog.setTitle("New Variable Classpath Entry");
        if (dialog.open() == 0) {
            IPath[] paths = dialog.getResult();
            int i = 0;
            while (i < paths.length) {
                IClasspathEntry entry = JavaCore.newVariableEntry((IPath)paths[i], null, null);
                this.libraries.add(entry);
                ++i;
            }
            this.librariesViewer.refresh();
            this.updateStatus();
        }
    }

    private void addExtJarFile() {
        String title = "JAR Selection";
        FileDialog dialog = new FileDialog(this.getShell(), 2);
        dialog.setText(title);
        dialog.setFilterExtensions(new String[]{"*.jar;*.zip"});
        String res = dialog.open();
        if (res != null) {
            String[] fileNames = dialog.getFileNames();
            Path filterPath = new Path(dialog.getFilterPath());
            int i = 0;
            while (i < fileNames.length) {
                String filename = fileNames[i];
                IPath path = filterPath.append(filename).makeAbsolute();
                IClasspathEntry entry = JavaCore.newLibraryEntry((IPath)path.makeAbsolute(), null, null);
                this.libraries.add(entry);
                ++i;
            }
            this.librariesViewer.refresh();
            this.updateStatus();
        }
    }

    private void createActionButtons(Composite outerGrid) {
        Composite buttonGrid = new Composite(outerGrid, 0);
        buttonGrid.setLayout((Layout)new GridLayout(1, true));
        this.addJarButton = new Button(buttonGrid, 0);
        this.addJarButton.setText("Add JARs...");
        this.addJarButton.setLayoutData((Object)new GridData(768));
        this.addJarButton.setEnabled(true);
        this.addJarButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProfileLibrariesWizardPage.this.addJarFile();
            }
        });
        this.addExternalJarButton = new Button(buttonGrid, 0);
        this.addExternalJarButton.setText("Add External JARs...");
        this.addExternalJarButton.setLayoutData((Object)new GridData(768));
        this.addExternalJarButton.setEnabled(true);
        this.addExternalJarButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProfileLibrariesWizardPage.this.addExtJarFile();
            }
        });
        this.addVariableButton = new Button(buttonGrid, 0);
        this.addVariableButton.setText("Add Variable...");
        this.addVariableButton.setLayoutData((Object)new GridData(768));
        this.addVariableButton.setEnabled(true);
        this.addVariableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProfileLibrariesWizardPage.this.addClasspathVariableSelections();
            }
        });
        new Label(buttonGrid, 0);
        this.removeButton = new Button(buttonGrid, 0);
        this.removeButton.setText("Remove...");
        this.removeButton.setLayoutData((Object)new GridData(768));
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProfileLibrariesWizardPage.this.removeSelectedLibraries();
            }
        });
    }

    private void createLibrariesViewer(Composite parent) {
        this.librariesViewer = new TableViewer(parent, 2048);
        this.librariesViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.librariesViewer.setContentProvider((IContentProvider)new ClasspathContentProvider());
        this.librariesViewer.setLabelProvider((IBaseLabelProvider)new ClasspathLabelProvider());
        this.librariesViewer.setInput((Object)this.libraries);
        Table table = this.librariesViewer.getTable();
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ProfileLibrariesWizardPage.this.updateStatus();
            }
        });
    }

    private void removeSelectedLibraries() {
        int[] selectedIndices = this.librariesViewer.getTable().getSelectionIndices();
        int i = selectedIndices.length;
        while (i > 0) {
            int index = selectedIndices[i - 1];
            this.libraries.remove(index);
            --i;
        }
        this.librariesViewer.refresh();
        this.updateStatus();
    }

    private void updateStatus() {
        boolean complete = this.libraries.size() > 0;
        this.setErrorMessage(complete ? null : "Libraries must be selected");
        this.setPageComplete(complete);
        this.removeButton.setEnabled(this.librariesViewer.getTable().getSelectionCount() > 0);
    }

    private class ArchiveViewerFilter
    extends ViewerFilter {
        private Set excluded = new HashSet();

        public ArchiveViewerFilter(List existing) {
            if (existing != null) {
                Iterator iter = existing.iterator();
                while (iter.hasNext()) {
                    IClasspathEntry entry = (IClasspathEntry)iter.next();
                    this.excluded.add(entry.getPath());
                }
            }
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            boolean selected;
            boolean bl = selected = this.isArchiveFile(element) && !this.isExcluded(element);
            if (!selected && element instanceof IContainer) {
                IContainer container = (IContainer)element;
                try {
                    IResource[] members = container.members();
                    int i = 0;
                    while (i < members.length) {
                        IResource resource = members[i];
                        selected = this.select(viewer, container, resource);
                        if (!selected) {
                            ++i;
                            continue;
                        }
                        break;
                    }
                }
                catch (CoreException e) {
                    EclipseMEPlugin.log(2, "select", e);
                }
            }
            return selected;
        }

        private boolean isExcluded(Object element) {
            IPath path = ((IResource)element).getFullPath();
            return this.excluded.contains(path);
        }

        private boolean isArchiveFile(Object element) {
            return element instanceof IFile && this.isArchiveFile((IFile)element);
        }

        private boolean isArchiveFile(IFile file) {
            String extension = file.getFileExtension();
            return extension.endsWith("jar") || extension.endsWith("zip");
        }
    }

    private class JARSelectionValidator
    implements ISelectionStatusValidator {
        private IStatus okStatus = new Status(0, "eclipseme", 0, "", null);
        private IStatus errorStatus = new Status(4, "eclipseme", 0, "", null);
        static /* synthetic */ Class class$0;

        JARSelectionValidator() {
        }

        public IStatus validate(Object[] selection) {
            return this.isValid(selection) ? this.okStatus : this.errorStatus;
        }

        private boolean isValid(Object[] selection) {
            boolean valid = true;
            if (selection.length > 0) {
                int i = 0;
                while (i < selection.length) {
                    Object object = selection[i];
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.core.resources.IFile");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (!clazz.isInstance(object)) {
                        valid = false;
                        break;
                    }
                    ++i;
                }
            } else {
                valid = false;
            }
            return valid;
        }
    }

    private class ClasspathContentProvider
    implements IStructuredContentProvider {
        ClasspathContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList entries = (ArrayList)inputElement;
            return entries.toArray(new IClasspathEntry[entries.size()]);
        }
    }

    private class ClasspathLabelProvider
    extends LabelProvider {
        private IWorkspaceRoot workspaceRoot;
        private WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider();

        public ClasspathLabelProvider() {
            this.workspaceRoot = EclipseMEPlugin.getWorkspace().getRoot();
        }

        public Image getImage(Object element) {
            IResource resource = this.getResource(element);
            return resource == null ? null : this.labelProvider.getImage((Object)this.getResource(element));
        }

        public String getText(Object element) {
            IClasspathEntry entry = (IClasspathEntry)element;
            return entry.getPath().makeAbsolute().toString();
        }

        private IResource getResource(Object element) {
            IClasspathEntry entry = (IClasspathEntry)element;
            return this.workspaceRoot.findMember(entry.getPath());
        }
    }
}

