/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.ui.wizards;

import eclipseme.EclipseMEPlugin;
import eclipseme.model.ApplicationDescriptor;
import eclipseme.model.IMidletSuiteProject;
import eclipseme.model.impl.generic.MidletSuiteProject;
import eclipseme.ui.wizards.NewMidletWizardPage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewMidletWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    private IStructuredSelection selection;
    private NewMidletWizardPage midletPage;

    public NewMidletWizard() {
        IDialogSettings workbenchSettings = EclipseMEPlugin.getDefault().getDialogSettings();
        IDialogSettings wizardSettings = workbenchSettings.getSection("NewMidletWizard");
        if (wizardSettings == null) {
            wizardSettings = workbenchSettings.addNewSection("NewMidletWizard");
        }
        this.setDialogSettings(wizardSettings);
    }

    public void addPages() {
        this.midletPage = new NewMidletWizardPage();
        this.addPage((IWizardPage)this.midletPage);
        this.midletPage.setWizard((IWizard)this);
        this.midletPage.init(this.selection);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
    }

    public boolean performFinish() {
        boolean completed = true;
        IRunnableWithProgress createMidletOp = this.getCreateMidletOperation();
        try {
            this.getContainer().run(false, true, createMidletOp);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            completed = false;
        }
        catch (InterruptedException e) {
            completed = false;
        }
        return completed;
    }

    private void addMidletToJAD(IType type, IProgressMonitor monitor) throws IOException, CoreException {
        IJavaProject javaProject = (IJavaProject)type.getAncestor(2);
        IMidletSuiteProject midletSuite = MidletSuiteProject.getMidletSuiteProject(javaProject);
        ApplicationDescriptor desc = midletSuite.getApplicationDescriptor();
        if (desc != null) {
            ApplicationDescriptor.MidletDefinition def = new ApplicationDescriptor.MidletDefinition(type.getElementName(), "", type.getFullyQualifiedName());
            desc.addMidletDefinition(def);
            desc.store();
            String jadFileName = midletSuite.getJadFilename();
            IFile jadFile = javaProject.getProject().getFile(jadFileName);
            jadFile.refreshLocal(1, monitor);
        }
    }

    private IRunnableWithProgress getCreateMidletOperation() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(NewMidletWizard.this.midletPage.getRunnable());
                op.run(monitor);
                IType type = NewMidletWizard.this.midletPage.getCreatedType();
                if (type != null) {
                    IResource resource = type.getResource();
                    if (resource != null) {
                        BasicNewResourceWizard.selectAndReveal((IResource)resource, (IWorkbenchWindow)NewMidletWizard.this.workbench.getActiveWorkbenchWindow());
                        NewMidletWizard.this.openResource((IFile)resource);
                    }
                    if (NewMidletWizard.this.midletPage.isAddToJadSelected()) {
                        try {
                            NewMidletWizard.this.addMidletToJAD(type, monitor);
                        }
                        catch (IOException e) {
                            throw new InvocationTargetException(e);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                }
            }
        };
        return new WorkspaceModifyDelegatingOperation(runnable);
    }

    private void openResource(final IFile resource) {
        Display display;
        IWorkbenchPage activePage;
        IWorkbenchWindow window = this.workbench.getActiveWorkbenchWindow();
        if (window != null && (activePage = this.workbench.getActiveWorkbenchWindow().getActivePage()) != null && (display = this.getShell().getDisplay()) != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    try {
                        IDE.openEditor((IWorkbenchPage)activePage, (IFile)resource, (boolean)true);
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }
}

