/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.ui.wizards;

import eclipseme.model.IPlatformDefinition;
import eclipseme.model.impl.generic.PlatformDefinition;
import eclipseme.model.registry.PlatformComponentRegistry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PlatformDefinitionWizardPage
extends WizardPage {
    public static final String PAGE_NAME = "PlatformDefinition";
    private Combo platformDefsCombo;

    public PlatformDefinitionWizardPage() {
        super(PAGE_NAME);
        this.setTitle("Platform Definition");
        this.setDescription("Choose the platform definition for this project.");
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        composite.setFont(font);
        this.initializeDialogUnits((Control)parent);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        new Label(composite, 0).setText("Available Platform Definitions:");
        this.platformDefsCombo = new Combo(composite, 12);
        this.platformDefsCombo.setLayoutData((Object)new GridData(768));
        this.platformDefsCombo.setTextLimit(200);
        this.initializePlatformDefinitions();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    public boolean isPageComplete() {
        return true;
    }

    public IPlatformDefinition getPlatformDefinition() {
        return this.getRegistry().getPlatformDefinition(this.getPlatformDefinitionName());
    }

    public String getPlatformDefinitionName() {
        return this.platformDefsCombo.getItem(this.platformDefsCombo.getSelectionIndex());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.platformDefsCombo.getItemCount() == 0) {
            this.setErrorMessage("No Platform Definitions Available");
            this.setPageComplete(false);
        }
    }

    private PlatformComponentRegistry getRegistry() {
        return PlatformComponentRegistry.getInstance();
    }

    private void initializePlatformDefinitions() {
        ArrayList<String> defs = new ArrayList<String>();
        Iterator defIter = this.getRegistry().getRegisteredPlatformDefinitions();
        if (defIter.hasNext()) {
            while (defIter.hasNext()) {
                PlatformDefinition def = (PlatformDefinition)defIter.next();
                defs.add(def.getName());
            }
            Object[] defNames = defs.toArray(new String[defs.size()]);
            Arrays.sort(defNames);
            this.platformDefsCombo.setItems((String[])defNames);
            this.platformDefsCombo.setText((String)defNames[0]);
        } else {
            this.setPageComplete(false);
        }
    }
}

