/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.utils;

import eclipseme.EclipseMEPlugin;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.ITypeNameRequestor;
import org.eclipse.jdt.core.search.SearchEngine;

public class SubclassSearchScope
implements IJavaSearchScope {
    private IJavaProject javaProject;
    private IType superType;
    private Set resourcePaths;

    public SubclassSearchScope(IJavaProject javaProject, IType superType) {
        this.javaProject = javaProject;
        this.superType = superType;
        this.initializeResourcePaths();
    }

    public boolean encloses(String resourcePath) {
        return this.resourcePaths.contains(resourcePath);
    }

    public boolean encloses(IJavaElement element) {
        return false;
    }

    public IPath[] enclosingProjectsAndJars() {
        ArrayList<IPath> paths = new ArrayList<IPath>();
        try {
            IClasspathEntry[] entries = this.javaProject.getResolvedClasspath(true);
            int i = 0;
            while (i < entries.length) {
                IClasspathEntry entry = entries[i];
                if (entry.getEntryKind() != 3) {
                    paths.add(entry.getPath());
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            EclipseMEPlugin.log(2, "enclosingProjectsAndJars", e);
        }
        return paths.toArray(new IPath[paths.size()]);
    }

    public boolean includesBinaries() {
        return true;
    }

    public boolean includesClasspaths() {
        return true;
    }

    public void setIncludesBinaries(boolean includesBinaries) {
    }

    public void setIncludesClasspaths(boolean includesClasspaths) {
    }

    private void initializeResourcePaths() {
        NullProgressMonitor monitor = new NullProgressMonitor();
        this.resourcePaths = new HashSet();
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this.javaProject}, (boolean)true);
        try {
            new SearchEngine().searchAllTypeNames(null, null, 10, 5, scope, (ITypeNameRequestor)new TypeNameRequest(), 3, (IProgressMonitor)monitor);
        }
        catch (JavaModelException e) {
            EclipseMEPlugin.log(2, "initializeResourcePaths", e);
        }
    }

    private boolean isSubclassInProject(String packageName, String className) throws JavaModelException {
        boolean isSubclass = false;
        IType type = this.javaProject.findType(packageName, className);
        if (type != null) {
            isSubclass = this.isSubclassOfType(type, this.superType);
        }
        return isSubclass;
    }

    private boolean isSubclassOfType(IType type, IType superType) throws JavaModelException {
        String[] firstResolvedType;
        IType t;
        String[][] resolvedSuperName;
        boolean isSubclass = false;
        String superName = type.getSuperclassName();
        if (superName != null && (resolvedSuperName = type.resolveType(superName)) != null && (t = this.javaProject.findType((firstResolvedType = resolvedSuperName[0])[0], firstResolvedType[1])) != null) {
            isSubclass = t.equals(superType) ? true : this.isSubclassOfType(t, superType);
        }
        return isSubclass;
    }

    private class TypeNameRequest
    implements ITypeNameRequestor {
        TypeNameRequest() {
        }

        public void acceptClass(char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
            try {
                if (SubclassSearchScope.this.isSubclassInProject(new String(packageName), new String(simpleTypeName))) {
                    this.addResourcePath(path);
                }
            }
            catch (JavaModelException e) {
                EclipseMEPlugin.log(1, "acceptClass", e);
            }
        }

        public void acceptInterface(char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
        }

        private void addResourcePath(String path) {
            SubclassSearchScope.this.resourcePaths.add(path);
        }
    }
}

