/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.utils.tools;

import eclipseme.utils.Utils;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;

public abstract class AbstractTool {
    protected Process exec(String[] commandLine, File workingDirectory, String[] env) throws CoreException {
        return DebugPlugin.exec((String[])commandLine, (File)workingDirectory, (String[])env);
    }

    protected ILaunch getNewLaunch(String configName) throws CoreException {
        return new Launch(this.getNewLaunchConfiguration(configName), "run", null);
    }

    protected ILaunchConfiguration getNewLaunchConfiguration(String name) throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configType = launchManager.getLaunchConfigurationType(IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION);
        ILaunchConfigurationWorkingCopy config = configType.newInstance(null, name);
        config.setAttribute(IDebugUIConstants.ATTR_PRIVATE, true);
        DebugUITools.setLaunchPerspective((ILaunchConfigurationType)configType, (String)"run", (String)"perspective_default");
        DebugUITools.setLaunchPerspective((ILaunchConfigurationType)configType, (String)"debug", (String)"perspective_default");
        return config;
    }

    protected IProcess launchApplication(String[] commandLine, File workingDirectory, String[] environment, String configName, String label) throws CoreException {
        Process execProcess = this.exec(commandLine, workingDirectory, environment);
        Launch launch = new Launch(this.getNewLaunchConfiguration(configName), "run", null);
        IProcess process = DebugPlugin.newProcess((ILaunch)launch, (Process)execProcess, (String)label);
        Utils.dumpCommandLine(commandLine);
        return process;
    }
}

