/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.AnalysisLocal;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ByteCodePatternDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.JavaVersion;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.bcp.ByteCodePattern;
import edu.umd.cs.findbugs.ba.bcp.ByteCodePatternMatch;
import edu.umd.cs.findbugs.ba.bcp.Invoke;
import edu.umd.cs.findbugs.ba.bcp.MatchAny;
import edu.umd.cs.findbugs.ba.bcp.Opcode;
import edu.umd.cs.findbugs.ba.bcp.PatternElement;
import java.util.ArrayList;
import java.util.BitSet;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class BCPMethodReturnCheck
extends ByteCodePatternDetector {
    private final BugReporter bugReporter;
    private static final boolean CHECK_ALL = SystemProperties.getBoolean((String)"mrc.checkall");
    private static AnalysisLocal<ByteCodePattern> localByteCodePattern = new AnalysisLocal();
    private static AnalysisLocal<ArrayList<PatternElement>> localPatternElementList = new AnalysisLocal();

    public ByteCodePattern getPattern() {
        ByteCodePattern result = (ByteCodePattern)localByteCodePattern.get();
        if (result == null) {
            ArrayList<PatternElement> list = BCPMethodReturnCheck.getPatternElementList();
            PatternElement[] calls = list.toArray(new PatternElement[list.size()]);
            result = new ByteCodePattern().add(new MatchAny(calls).label("call").setAllowTrailingEdges(false)).add((PatternElement)new MatchAny(new PatternElement[]{new Opcode(87), new Opcode(88)}));
            localByteCodePattern.set((Object)result);
        }
        return result;
    }

    public static void addMethodWhoseReturnMustBeChecked(String className, String methodName, String methodSig, int mode) {
        ArrayList<PatternElement> list = BCPMethodReturnCheck.getPatternElementList();
        list.add((PatternElement)new Invoke(className, methodName, methodSig, mode, null));
        localByteCodePattern.remove();
    }

    private static ArrayList<PatternElement> getPatternElementList() {
        String externalCheckReturnValues;
        ArrayList<PatternElement> list = (ArrayList<PatternElement>)localPatternElementList.get();
        if (list != null) {
            return list;
        }
        list = new ArrayList<PatternElement>();
        list.add((PatternElement)new Invoke("/.*", "equals", "/\\(Ljava/lang/Object;\\)Z", 1, null));
        list.add((PatternElement)new Invoke("java.lang.String", "/.*", "/\\(.*\\)Ljava/lang/String;", 1, null));
        list.add((PatternElement)new Invoke("java.lang.StringBuffer", "toString", "()Ljava/lang/String;", 1, null));
        list.add((PatternElement)new Invoke("+java.lang.Thread", "<init>", "/.*", 4, null));
        list.add((PatternElement)new Invoke("+java.lang.Throwable", "<init>", "/.*", 4, null));
        list.add((PatternElement)new Invoke("java.security.MessageDigest", "digest", "([B)[B", 1, null));
        list.add((PatternElement)new Invoke("+java.sql.Connection", "/.*", "/.*", 1, null));
        list.add((PatternElement)new Invoke("java.math.BigDecimal", "/.*", "/.*", 1, null));
        list.add((PatternElement)new Invoke("java.math.BigInteger", "/.*", "/.*", 1, null));
        list.add((PatternElement)new Invoke("+java.util.Enumeration", "hasMoreElements", "()Z", 1, null));
        list.add((PatternElement)new Invoke("+java.util.Iterator", "hasNext", "()Z", 1, null));
        list.add((PatternElement)new Invoke("java.io.File", "createNewFile", "()Z", 1, null));
        if (CHECK_ALL || JavaVersion.getRuntimeVersion().isSameOrNewerThan(JavaVersion.JAVA_1_5)) {
            list.add((PatternElement)new Invoke("+java.util.concurrent.locks.ReadWriteLock", "readLock", "()Ljava/util/concurrent/locks/Lock;", 1, null));
            list.add((PatternElement)new Invoke("+java.util.concurrent.locks.ReadWriteLock", "writeLock", "()Ljava/util/concurrent/locks/Lock;", 1, null));
            list.add((PatternElement)new Invoke("+java.util.concurrent.locks.Condition", "await", "(JLjava/util/concurrent/TimeUnit;)Z", 1, null));
            list.add((PatternElement)new Invoke("+java.util.concurrent.locks.Condition", "awaitUtil", "(Ljava/util/Date;)Z", 1, null));
            list.add((PatternElement)new Invoke("+java.util.concurrent.locks.Condition", "awaitNanos", "(J)Z", 1, null));
            list.add((PatternElement)new Invoke("+java.util.concurrent.Semaphore", "tryAcquire", "(JLjava/util/concurrent/TimeUnit;)Z", 1, null));
            list.add((PatternElement)new Invoke("+java.util.concurrent.Semaphore", "tryAcquire", "()Z", 1, null));
            list.add((PatternElement)new Invoke("+java.util.concurrent.locks.Lock", "tryLock", "(JLjava/util/concurrent/TimeUnit;)Z", 1, null));
            list.add((PatternElement)new Invoke("+java.util.concurrent.locks.Lock", "newCondition", "()Ljava/util/concurrent/locks/Condition;", 1, null));
            list.add((PatternElement)new Invoke("+java.util.concurrent.locks.Lock", "tryLock", "()Z", 1, null));
            list.add((PatternElement)new Invoke("+java.util.Queue", "offer", "(Ljava/lang/Object;)Z", 1, null));
            list.add((PatternElement)new Invoke("+java.util.concurrent.BlockingQueue", "offer", "(Ljava/lang/Object;JLjava/util/concurrent/TimeUnit;)Z", 1, null));
            list.add((PatternElement)new Invoke("+java.util.concurrent.BlockingQueue", "poll", "(JLjava/util/concurrent/TimeUnit;)Ljava/lang/Object;", 1, null));
            list.add((PatternElement)new Invoke("+java.util.Queue", "poll", "()Ljava/lang/Object;", 1, null));
        }
        if ((externalCheckReturnValues = SystemProperties.getProperty((String)"checkReturnValues")) != null) {
            String[] checks;
            for (String check : checks = externalCheckReturnValues.split("[|]")) {
                String[] parts = check.split(":");
                if (parts.length != 3) continue;
                Invoke in = new Invoke(parts[0], parts[1], parts[2], 1, null);
                list.add((PatternElement)in);
            }
        }
        localPatternElementList.set(list);
        return list;
    }

    public BCPMethodReturnCheck(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    protected BugReporter getBugReporter() {
        return this.bugReporter;
    }

    public boolean prescreen(Method method, ClassContext classContext) {
        BitSet bytecodeSet = classContext.getBytecodeSet(method);
        return bytecodeSet != null && (bytecodeSet.get(87) || bytecodeSet.get(88));
    }

    public void reportMatch(ClassContext classContext, Method method, ByteCodePatternMatch match) {
        ConstantPoolGen cp;
        MethodGen methodGen = classContext.getMethodGen(method);
        if (methodGen == null) {
            return;
        }
        JavaClass javaClass = classContext.getJavaClass();
        InstructionHandle call = match.getLabeledInstruction("call");
        InvokeInstruction inv = (InvokeInstruction)call.getInstruction();
        String calledMethodName = inv.getMethodName(cp = methodGen.getConstantPool());
        if (calledMethodName.startsWith("access$") || calledMethodName.startsWith("access+")) {
            return;
        }
        String calledMethodClass = inv.getClassName(cp);
        if (inv.getSignature(cp).endsWith("V") && !calledMethodName.equals("<init>")) {
            return;
        }
        String sourceFile = javaClass.getSourceFileName();
        int priority = 1;
        if (calledMethodName.equals("createNewFile")) {
            priority = 3;
        }
        if (calledMethodClass.startsWith("java.lang") || calledMethodClass.startsWith("java.math") || calledMethodClass.endsWith("Error") || calledMethodClass.endsWith("Exception")) {
            --priority;
        }
        if (calledMethodClass.equals(javaClass.getClassName())) {
            ++priority;
        }
        String calledPackage = BCPMethodReturnCheck.extractPackageName(calledMethodClass);
        String callingPackage = BCPMethodReturnCheck.extractPackageName(javaClass.getClassName());
        if (calledPackage.length() > 0 && callingPackage.length() > 0 && (calledPackage.startsWith(callingPackage) || callingPackage.startsWith(calledPackage))) {
            ++priority;
        }
        this.bugReporter.reportBug(new BugInstance((Detector)this, "RV_RETURN_VALUE_IGNORED2", priority).addClassAndMethod(methodGen, sourceFile).addCalledMethod(methodGen, inv).addSourceLine(classContext, methodGen, sourceFile, call));
    }

    public static String extractPackageName(String className) {
        int i = className.lastIndexOf(46);
        if (i == -1) {
            return "";
        }
        return className.substring(0, i);
    }
}

