/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.ba.AnnotationDatabase;
import edu.umd.cs.findbugs.ba.AnnotationEnumeration;
import edu.umd.cs.findbugs.ba.NullnessAnnotation;
import edu.umd.cs.findbugs.ba.NullnessAnnotationDatabase;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.XMethodParameter;
import edu.umd.cs.findbugs.visitclass.AnnotationVisitor;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildNonNullAnnotationDatabase
extends AnnotationVisitor {
    private static final boolean DEBUG = SystemProperties.getBoolean((String)"fnd.debug.annotation");
    private static final String DEFAULT_ANNOTATION_ANNOTATION_CLASS = "DefaultAnnotation";
    private static final Map<String, AnnotationDatabase.Target> defaultKind = new HashMap<String, AnnotationDatabase.Target>();
    private NullnessAnnotationDatabase database;

    public BuildNonNullAnnotationDatabase(@CheckForNull NullnessAnnotationDatabase database) {
        this.database = database;
    }

    static String lastPortion(String className) {
        int i = className.lastIndexOf(".");
        if (i < 0) {
            return className;
        }
        return className.substring(i + 1);
    }

    public void visitAnnotation(String annotationClass, Map<String, Object> map, boolean runtimeVisible) {
        if (this.database == null) {
            return;
        }
        NullnessAnnotation n = NullnessAnnotation.Parser.parse((String)annotationClass);
        annotationClass = BuildNonNullAnnotationDatabase.lastPortion(annotationClass);
        if (n == null) {
            if (annotationClass.startsWith(DEFAULT_ANNOTATION_ANNOTATION_CLASS)) {
                Object v = map.get("value");
                if (v == null || !(v instanceof Object[])) {
                    return;
                }
                AnnotationDatabase.Target annotationTarget = defaultKind.get(annotationClass = annotationClass.substring(DEFAULT_ANNOTATION_ANNOTATION_CLASS.length()));
                if (annotationTarget != null) {
                    for (Object aClass : (Object[])v) {
                        n = NullnessAnnotation.Parser.parse((String)((String)aClass));
                        if (n == null) continue;
                        this.database.addDefaultAnnotation(annotationTarget, this.getDottedClassName(), n);
                    }
                }
            }
        } else if (this.visitingMethod()) {
            this.database.addDirectAnnotation((Object)XFactory.createXMethod((PreorderVisitor)this), (AnnotationEnumeration)n);
        } else if (this.visitingField()) {
            this.database.addDirectAnnotation((Object)XFactory.createXField((PreorderVisitor)this), (AnnotationEnumeration)n);
        }
    }

    public void visitSyntheticParameterAnnotation(int p, boolean runtimeVisible) {
        if (this.database == null) {
            return;
        }
        XMethod xmethod = XFactory.createXMethod((PreorderVisitor)this);
        XMethodParameter xparameter = new XMethodParameter(xmethod, p);
        this.database.addDirectAnnotation((Object)xparameter, (AnnotationEnumeration)NullnessAnnotation.UNKNOWN_NULLNESS);
    }

    public void visitParameterAnnotation(int p, String annotationClass, Map<String, Object> map, boolean runtimeVisible) {
        if (this.database == null) {
            return;
        }
        NullnessAnnotation n = NullnessAnnotation.Parser.parse((String)annotationClass);
        annotationClass = BuildNonNullAnnotationDatabase.lastPortion(annotationClass);
        if (n == null) {
            return;
        }
        XMethod xmethod = XFactory.createXMethod((PreorderVisitor)this);
        if (DEBUG) {
            System.out.println("Parameter " + p + " @" + annotationClass.substring(annotationClass.lastIndexOf(47) + 1) + " in " + xmethod.toString());
        }
        XMethodParameter xparameter = new XMethodParameter(xmethod, p);
        this.database.addDirectAnnotation((Object)xparameter, (AnnotationEnumeration)n);
    }

    static {
        defaultKind.put("", AnnotationDatabase.Target.ANY);
        defaultKind.put("ForParameters", AnnotationDatabase.Target.PARAMETER);
        defaultKind.put("ForMethods", AnnotationDatabase.Target.METHOD);
        defaultKind.put("ForFields", AnnotationDatabase.Target.FIELD);
    }
}

