/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.ObjectTypeFactory;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import java.util.BitSet;
import java.util.Iterator;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public final class FindJSR166LockMonitorenter
implements Detector,
StatelessDetector {
    private BugReporter bugReporter;
    private static final ObjectType LOCK_TYPE = ObjectTypeFactory.getInstance((String)"java.util.concurrent.locks.Lock");

    public FindJSR166LockMonitorenter(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        JavaClass jclass = classContext.getJavaClass();
        for (Method method : methodList = jclass.getMethods()) {
            BitSet bytecodeSet;
            if (method.getCode() == null || (bytecodeSet = classContext.getBytecodeSet(method)) == null || !bytecodeSet.get(194)) continue;
            this.analyzeMethod(classContext, method);
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method) {
        TypeDataflow typeDataflow;
        CFG cfg;
        ConstantPoolGen cpg = classContext.getConstantPoolGen();
        try {
            cfg = classContext.getCFG(method);
        }
        catch (CFGBuilderException e1) {
            AnalysisContext.logError((String)"Coult not get CFG", (Exception)((Object)e1));
            return;
        }
        try {
            typeDataflow = classContext.getTypeDataflow(method);
        }
        catch (CheckedAnalysisException e1) {
            AnalysisContext.logError((String)"Coult not get Type dataflow", (Exception)((Object)e1));
            return;
        }
        Iterator i = cfg.locationIterator();
        while (i.hasNext()) {
            boolean isSubtype;
            Type type;
            Location location = (Location)i.next();
            InstructionHandle handle = location.getHandle();
            Instruction ins = handle.getInstruction();
            if (ins.getOpcode() != 194) continue;
            try {
                TypeFrame frame = (TypeFrame)typeDataflow.getFactAtLocation(location);
                if (!frame.isValid()) continue;
                type = (Type)frame.getInstance(ins, cpg);
            }
            catch (CheckedAnalysisException e) {
                AnalysisContext.logError((String)"Coult not get Type dataflow", (Exception)((Object)e));
                continue;
            }
            if (!(type instanceof ReferenceType)) {
                return;
            }
            try {
                isSubtype = Hierarchy.isSubtype((ReferenceType)((ReferenceType)type), (ReferenceType)LOCK_TYPE);
            }
            catch (ClassNotFoundException e) {
                this.bugReporter.reportMissingClass(e);
                return;
            }
            if (!isSubtype) continue;
            this.bugReporter.reportBug(new BugInstance((Detector)this, "JLM_JSR166_LOCK_MONITORENTER", 2).addClassAndMethod(classContext.getJavaClass(), method).addSourceLine(classContext, method, location));
        }
    }

    public void report() {
    }
}

