/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.constant.Constant;
import edu.umd.cs.findbugs.ba.constant.ConstantDataflow;
import edu.umd.cs.findbugs.ba.constant.ConstantFrame;
import edu.umd.cs.findbugs.ba.type.TopType;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.AALOAD;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NOP;
import org.apache.bcel.generic.Type;

public class FindSqlInjection
implements Detector {
    BugReporter bugReporter;
    static final Pattern openQuotePattern = Pattern.compile("((^')|[^\\p{Alnum}]')$");
    static final Pattern closeQuotePattern = Pattern.compile("^'($|[^\\p{Alnum}])");
    Method method;
    ClassContext classContext;

    public FindSqlInjection(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        JavaClass javaClass = classContext.getJavaClass();
        for (Method method : methodList = javaClass.getMethods()) {
            MethodGen methodGen = classContext.getMethodGen(method);
            if (methodGen == null) continue;
            try {
                this.analyzeMethod(classContext, method);
            }
            catch (DataflowAnalysisException e) {
                this.bugReporter.logError("FindSqlInjection caught exception while analyzing " + methodGen, (Throwable)e);
            }
            catch (CFGBuilderException e) {
                this.bugReporter.logError("FindSqlInjection caught exception while analyzing " + methodGen, (Throwable)e);
            }
            catch (RuntimeException e) {
                System.out.println("Exception while checking for SQL injection in " + methodGen + " in " + javaClass.getSourceFileName());
                e.printStackTrace(System.out);
            }
        }
    }

    private boolean isStringAppend(Instruction ins, ConstantPoolGen cpg) {
        INVOKEVIRTUAL invoke;
        if (ins instanceof INVOKEVIRTUAL && (invoke = (INVOKEVIRTUAL)ins).getMethodName(cpg).equals("append") && invoke.getClassName(cpg).startsWith("java.lang.StringB")) {
            String sig = invoke.getSignature(cpg);
            char firstChar = sig.charAt(1);
            return firstChar == '[' || firstChar == 'L';
        }
        return false;
    }

    private boolean isConstantStringLoad(Location location, ConstantPoolGen cpg) throws CFGBuilderException {
        LDC load;
        Object value;
        Instruction ins = location.getHandle().getInstruction();
        return ins instanceof LDC && (value = (load = (LDC)ins).getValue(cpg)) instanceof String;
    }

    public static boolean isOpenQuote(String s) {
        return openQuotePattern.matcher(s).find();
    }

    public static boolean isCloseQuote(String s) {
        return closeQuotePattern.matcher(s).find();
    }

    private StringAppendState updateStringAppendState(Location location, ConstantPoolGen cpg, StringAppendState stringAppendState) throws CFGBuilderException {
        InstructionHandle handle = location.getHandle();
        Instruction ins = handle.getInstruction();
        if (!this.isConstantStringLoad(location, cpg)) {
            throw new IllegalArgumentException("instruction must be LDC");
        }
        LDC load = (LDC)ins;
        Object value = load.getValue(cpg);
        String stringValue = ((String)value).trim();
        if (stringValue.startsWith(",") || stringValue.endsWith(",")) {
            stringAppendState.setSawComma(handle);
        }
        if (FindSqlInjection.isOpenQuote(stringValue)) {
            stringAppendState.setSawOpenQuote(handle);
        }
        if (FindSqlInjection.isCloseQuote(stringValue)) {
            stringAppendState.setSawCloseQuote(handle);
        }
        return stringAppendState;
    }

    private boolean isPreparedStatementDatabaseSink(Instruction ins, ConstantPoolGen cpg) {
        if (!(ins instanceof INVOKEINTERFACE)) {
            return false;
        }
        INVOKEINTERFACE invoke = (INVOKEINTERFACE)ins;
        String methodName = invoke.getMethodName(cpg);
        String interfaceName = invoke.getClassName(cpg);
        return methodName.equals("prepareStatement") && interfaceName.equals("java.sql.Connection");
    }

    private boolean isExecuteDatabaseSink(Instruction ins, ConstantPoolGen cpg) {
        if (!(ins instanceof INVOKEINTERFACE)) {
            return false;
        }
        INVOKEINTERFACE invoke = (INVOKEINTERFACE)ins;
        String methodName = invoke.getMethodName(cpg);
        String interfaceName = invoke.getClassName(cpg);
        return methodName.startsWith("execute") && interfaceName.equals("java.sql.Statement");
    }

    private boolean isDatabaseSink(Instruction ins, ConstantPoolGen cpg) {
        return this.isPreparedStatementDatabaseSink(ins, cpg) || this.isExecuteDatabaseSink(ins, cpg);
    }

    private StringAppendState getStringAppendState(CFG cfg, ConstantPoolGen cpg) throws CFGBuilderException {
        StringAppendState stringAppendState = new StringAppendState();
        String sig = this.method.getSignature();
        if ((sig = sig.substring(0, sig.indexOf(41))).indexOf("java/lang/String") >= 0) {
            stringAppendState.setSawInitialTaint();
        }
        Iterator i = cfg.locationIterator();
        while (i.hasNext()) {
            GETFIELD getfield;
            String sig2;
            Location location = (Location)i.next();
            InstructionHandle handle = location.getHandle();
            Instruction ins = handle.getInstruction();
            if (this.isConstantStringLoad(location, cpg)) {
                stringAppendState = this.updateStringAppendState(location, cpg, stringAppendState);
                continue;
            }
            if (this.isStringAppend(ins, cpg)) {
                stringAppendState.setSawAppend(handle);
                Location prevLocation = this.getPreviousLocation(cfg, location, true);
                if (prevLocation == null || this.isSafeValue(prevLocation, cpg)) continue;
                stringAppendState.setSawUnsafeAppend(handle);
                continue;
            }
            if (ins instanceof InvokeInstruction) {
                InvokeInstruction inv = (InvokeInstruction)ins;
                String sig1 = inv.getSignature(cpg);
                String sig22 = sig1.substring(sig1.indexOf(41));
                if (sig22.indexOf("java/lang/String") < 0) continue;
                String methodName = inv.getMethodName(cpg);
                String className = inv.getClassName(cpg);
                if (methodName.equals("valueOf") && className.equals("java.lang.String") && sig1.equals("(Ljava/lang/Object;)Ljava/lang/String;")) {
                    try {
                        String sig3;
                        Type operandType;
                        TypeDataflow typeDataflow = this.classContext.getTypeDataflow(this.method);
                        TypeFrame frame = (TypeFrame)typeDataflow.getFactAtLocation(location);
                        if (!frame.isValid() || (operandType = (Type)frame.getTopValue()).equals((Object)TopType.instance()) || (sig3 = operandType.getSignature()).equals("Ljava/lang/String;")) continue;
                        stringAppendState.setSawTaint(handle);
                    }
                    catch (CheckedAnalysisException e) {
                        stringAppendState.setSawTaint(handle);
                    }
                    continue;
                }
                if (className.startsWith("java.lang.String") || className.equals("java.lang.Long") || className.equals("java.lang.Integer") || className.equals("java.lang.Float") || className.equals("java.lang.Double") || className.equals("java.lang.Short") || className.equals("java.lang.Byte") || className.equals("java.lang.Character") || methodName.startsWith("to") && methodName.endsWith("String") && methodName.length() > 8) continue;
                if (className.startsWith("javax.servlet") && methodName.startsWith("get")) {
                    stringAppendState.setSawTaint(handle);
                    stringAppendState.setSawSeriousTaint(handle);
                    continue;
                }
                stringAppendState.setSawTaint(handle);
                continue;
            }
            if (!(ins instanceof GETFIELD) || (sig2 = (getfield = (GETFIELD)ins).getSignature(cpg)).indexOf("java/lang/String") < 0) continue;
            stringAppendState.setSawTaint(handle);
        }
        return stringAppendState;
    }

    private boolean isSafeValue(Location location, ConstantPoolGen cpg) throws CFGBuilderException {
        GETSTATIC getStatic;
        Location prev2;
        CFG cfg;
        Location prev;
        String methodName;
        Instruction prevIns = location.getHandle().getInstruction();
        if (prevIns instanceof LDC || prevIns instanceof GETSTATIC) {
            return true;
        }
        if (prevIns instanceof InvokeInstruction && (methodName = ((InvokeInstruction)prevIns).getMethodName(cpg)).startsWith("to") && methodName.endsWith("String") && methodName.length() > 8) {
            return true;
        }
        return prevIns instanceof AALOAD && (prev = this.getPreviousLocation(cfg = this.classContext.getCFG(this.method), location, true)) != null && (prev2 = this.getPreviousLocation(cfg, prev, true)) != null && prev2.getHandle().getInstruction() instanceof GETSTATIC && (getStatic = (GETSTATIC)prev2.getHandle().getInstruction()).getSignature(cpg).equals("[Ljava/lang/String;");
    }

    @CheckForNull
    private InstructionHandle getPreviousInstruction(InstructionHandle handle, boolean skipNops) {
        while (handle.getPrev() != null) {
            Instruction prevIns = (handle = handle.getPrev()).getInstruction();
            if (prevIns instanceof NOP && skipNops) continue;
            return handle;
        }
        return null;
    }

    @CheckForNull
    private Location getPreviousLocation(CFG cfg, Location startLocation, boolean skipNops) {
        InstructionHandle lastInstruction;
        Location loc = startLocation;
        InstructionHandle prev = this.getPreviousInstruction(loc.getHandle(), skipNops);
        if (prev != null) {
            return new Location(prev, loc.getBasicBlock());
        }
        BasicBlock block = loc.getBasicBlock();
        do {
            if ((block = cfg.getPredecessorWithEdgeType(block, 0)) != null) continue;
            return null;
        } while ((lastInstruction = block.getLastInstruction()) == null);
        return new Location(lastInstruction, block);
    }

    private BugInstance generateBugInstance(JavaClass javaClass, MethodGen methodGen, InstructionHandle handle, StringAppendState stringAppendState) {
        Instruction instruction = handle.getInstruction();
        ConstantPoolGen cpg = methodGen.getConstantPool();
        int priority = 3;
        if (stringAppendState.getSawAppend(handle)) {
            if (stringAppendState.getSawOpenQuote(handle) && stringAppendState.getSawCloseQuote(handle)) {
                priority = 1;
            } else if (stringAppendState.getSawComma(handle)) {
                priority = 2;
            }
            if (!stringAppendState.getSawUnsafeAppend(handle)) {
                priority += 2;
            } else if (stringAppendState.getSawSeriousTaint(handle)) {
                --priority;
            } else if (!stringAppendState.getSawTaint(handle)) {
                ++priority;
            }
        }
        String description = "";
        if (this.isExecuteDatabaseSink(instruction, cpg)) {
            description = "SQL_NONCONSTANT_STRING_PASSED_TO_EXECUTE";
        } else if (this.isPreparedStatementDatabaseSink(instruction, cpg)) {
            description = "SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING";
        }
        BugInstance bug = new BugInstance((Detector)this, description, priority);
        bug.addClassAndMethod(methodGen, javaClass.getSourceFileName());
        return bug;
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws DataflowAnalysisException, CFGBuilderException {
        JavaClass javaClass = classContext.getJavaClass();
        this.method = method;
        this.classContext = classContext;
        MethodGen methodGen = classContext.getMethodGen(method);
        if (methodGen == null) {
            return;
        }
        ConstantPoolGen cpg = methodGen.getConstantPool();
        CFG cfg = classContext.getCFG(method);
        StringAppendState stringAppendState = this.getStringAppendState(cfg, cpg);
        ConstantDataflow dataflow = classContext.getConstantDataflow(method);
        Iterator i = cfg.locationIterator();
        while (i.hasNext()) {
            Location prev;
            ConstantFrame frame;
            Constant value;
            Location location = (Location)i.next();
            Instruction ins = location.getHandle().getInstruction();
            if (!this.isDatabaseSink(ins, cpg) || (value = (Constant)(frame = (ConstantFrame)dataflow.getFactAtLocation(location)).getStackValue(0)).isConstantString() || (prev = this.getPreviousLocation(cfg, location, true)) != null && this.isSafeValue(prev, cpg)) continue;
            BugInstance bug = this.generateBugInstance(javaClass, methodGen, location.getHandle(), stringAppendState);
            bug.addSourceLine(classContext, methodGen, javaClass.getSourceFileName(), location.getHandle());
            this.bugReporter.reportBug(bug);
        }
    }

    public void report() {
    }

    private static class StringAppendState {
        int sawOpenQuote = Integer.MAX_VALUE;
        int sawCloseQuote = Integer.MAX_VALUE;
        int sawComma = Integer.MAX_VALUE;
        int sawAppend = Integer.MAX_VALUE;
        int sawUnsafeAppend = Integer.MAX_VALUE;
        int sawTaint = Integer.MAX_VALUE;
        int sawSeriousTaint = Integer.MAX_VALUE;

        private StringAppendState() {
        }

        public boolean getSawOpenQuote(InstructionHandle handle) {
            return this.sawOpenQuote <= handle.getPosition();
        }

        public boolean getSawCloseQuote(InstructionHandle handle) {
            return this.sawCloseQuote <= handle.getPosition();
        }

        public boolean getSawComma(InstructionHandle handle) {
            return this.sawComma <= handle.getPosition();
        }

        public boolean getSawAppend(InstructionHandle handle) {
            return this.sawAppend <= handle.getPosition();
        }

        public boolean getSawUnsafeAppend(InstructionHandle handle) {
            return this.sawUnsafeAppend <= handle.getPosition();
        }

        public boolean getSawTaint(InstructionHandle handle) {
            return this.sawTaint <= handle.getPosition();
        }

        public boolean getSawSeriousTaint(InstructionHandle handle) {
            return this.sawSeriousTaint <= handle.getPosition();
        }

        public void setSawOpenQuote(InstructionHandle handle) {
            this.sawOpenQuote = Math.min(this.sawOpenQuote, handle.getPosition());
        }

        public void setSawCloseQuote(InstructionHandle handle) {
            this.sawCloseQuote = Math.min(this.sawCloseQuote, handle.getPosition());
        }

        public void setSawComma(InstructionHandle handle) {
            this.sawComma = Math.min(this.sawComma, handle.getPosition());
        }

        public void setSawAppend(InstructionHandle handle) {
            this.sawAppend = Math.min(this.sawAppend, handle.getPosition());
        }

        public void setSawUnsafeAppend(InstructionHandle handle) {
            this.sawUnsafeAppend = Math.min(this.sawUnsafeAppend, handle.getPosition());
        }

        public void setSawSeriousTaint(InstructionHandle handle) {
            this.sawSeriousTaint = Math.min(this.sawSeriousTaint, handle.getPosition());
        }

        public void setSawTaint(InstructionHandle handle) {
            this.sawTaint = Math.min(this.sawTaint, handle.getPosition());
        }

        public void setSawInitialTaint() {
            this.sawTaint = 0;
        }
    }
}

