/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.props.AbstractWarningProperty;
import edu.umd.cs.findbugs.props.PriorityAdjustment;
import edu.umd.cs.findbugs.props.WarningProperty;
import edu.umd.cs.findbugs.props.WarningPropertySet;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Deprecated;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Naming
extends PreorderVisitor
implements Detector {
    String baseClassName;
    boolean classIsPublicOrProtected;
    HashMap<String, HashSet<String>> canonicalToTrueMapping = new HashMap();
    HashMap<String, HashSet<XMethod>> canonicalToXMethod = new HashMap();
    HashSet<String> visited = new HashSet();
    private BugReporter bugReporter;
    private static final Pattern sigType = Pattern.compile("L([^;]*/)?([^/]+;)");

    @CheckForNull
    public static XMethod definedIn(JavaClass clazz, XMethod m) {
        for (Method m2 : clazz.getMethods()) {
            if (!m.getName().equals(m2.getName()) || !m.getSignature().equals(m2.getSignature()) || m.isStatic() != m2.isStatic()) continue;
            return XFactory.createXMethod((JavaClass)clazz, (Method)m2);
        }
        return null;
    }

    public static boolean confusingMethodNames(XMethod m1, XMethod m2) {
        if (m1.isStatic() != m2.isStatic()) {
            return false;
        }
        if (m1.getClassName().equals(m2.getClassName())) {
            return false;
        }
        if (m1.getName().equalsIgnoreCase(m2.getName()) && !m1.getName().equals(m2.getName()) && m1.getSignature().equals(m2.getSignature())) {
            return true;
        }
        if (m1.getSignature().equals(m2.getSignature())) {
            return false;
        }
        return Naming.removePackageNamesFromSignature(m1.getSignature()).equals(Naming.removePackageNamesFromSignature(m2.getSignature()));
    }

    public Naming(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        classContext.getJavaClass().accept((Visitor)this);
    }

    private boolean checkSuper(XMethod m, HashSet<XMethod> others) {
        if (m.isStatic()) {
            return false;
        }
        if (m.getName().equals("<init>") || m.getName().equals("<clinit>")) {
            return false;
        }
        for (XMethod m2 : others) {
            try {
                String pattern;
                if (!Naming.confusingMethodNames(m, m2) || !Repository.instanceOf((String)m.getClassName(), (String)m2.getClassName())) continue;
                WarningPropertySet propertySet = new WarningPropertySet();
                int priority = 1;
                XMethod m3 = null;
                try {
                    JavaClass clazz = Repository.lookupClass((String)m.getClassName());
                    m3 = Naming.definedIn(clazz, m2);
                    if (m3 == null) {
                        priority = 2;
                    }
                    if (m3 == null) {
                        for (JavaClass s : clazz.getSuperClasses()) {
                            m3 = Naming.definedIn(s, m);
                            if (m3 == null) continue;
                            priority = 2;
                        }
                    }
                    if (m3 == null) {
                        for (JavaClass i : clazz.getAllInterfaces()) {
                            m3 = Naming.definedIn(i, m);
                            if (m3 == null) continue;
                            priority = 2;
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    ++priority;
                    AnalysisContext.reportMissingClass((ClassNotFoundException)e);
                }
                XFactory xFactory = AnalysisContext.currentXFactory();
                if (m3 == null && AnalysisContext.currentXFactory().isCalled(m)) {
                    propertySet.addProperty((WarningProperty)NamingProperty.METHOD_IS_CALLED);
                } else if (m.isDeprecated() || m2.isDeprecated()) {
                    propertySet.addProperty((WarningProperty)NamingProperty.METHOD_IS_DEPRECATED);
                }
                priority = propertySet.computePriority(priority);
                if (!m.getName().equals(m2.getName()) && m.getName().equalsIgnoreCase(m2.getName())) {
                    pattern = m3 != null ? "NM_VERY_CONFUSING_INTENTIONAL" : "NM_VERY_CONFUSING";
                    BugInstance bug = new BugInstance((Detector)this, pattern, priority).addClass(m.getClassName()).addMethod(m).addClass(m2.getClassName()).addMethod(m2);
                    if (m3 != null) {
                        bug.addMethod(m3);
                    }
                    propertySet.decorateBugInstance(bug);
                    this.bugReporter.reportBug(bug);
                }
                if (!m.getSignature().equals(m2.getSignature()) && Naming.removePackageNamesFromSignature(m.getSignature()).equals(Naming.removePackageNamesFromSignature(m2.getSignature()))) {
                    pattern = m3 != null ? "NM_WRONG_PACKAGE_INTENTIONAL" : "NM_WRONG_PACKAGE";
                    Iterator s = new SignatureParser(m.getSignature()).parameterSignatureIterator();
                    Iterator s2 = new SignatureParser(m2.getSignature()).parameterSignatureIterator();
                    while (s.hasNext()) {
                        String p2;
                        String p = (String)s.next();
                        if (p.equals(p2 = (String)s2.next())) continue;
                        BugInstance bug = new BugInstance((Detector)this, pattern, priority).addClass(m.getClassName()).addMethod(m).addClass(m2.getClassName()).addMethod(m2).addFoundAndExpectedType(p, p2);
                        if (m3 != null) {
                            bug.addMethod(m3);
                        }
                        propertySet.decorateBugInstance(bug);
                        this.bugReporter.reportBug(bug);
                    }
                }
                return true;
            }
            catch (ClassNotFoundException e) {
                AnalysisContext.reportMissingClass((ClassNotFoundException)e);
            }
        }
        return false;
    }

    private boolean checkNonSuper(XMethod m, HashSet<XMethod> others) {
        if (m.isStatic()) {
            return false;
        }
        if (m.getName().startsWith("<init>") || m.getName().startsWith("<clinit>")) {
            return false;
        }
        for (XMethod m2 : others) {
            if (!Naming.confusingMethodNames(m, m2)) continue;
            XMethod mm1 = m;
            XMethod mm2 = m2;
            if (m.compareTo((Object)m2) < 0) {
                mm1 = m;
                mm2 = m2;
            } else {
                mm1 = m2;
                mm2 = m;
            }
            this.bugReporter.reportBug(new BugInstance((Detector)this, "NM_CONFUSING", 3).addClass(mm1.getClassName()).addMethod(mm1).addClass(mm2.getClassName()).addMethod(mm2));
            return true;
        }
        return false;
    }

    public void report() {
        for (String allSmall : this.canonicalToTrueMapping.keySet()) {
            HashSet<String> s = this.canonicalToTrueMapping.get(allSmall);
            if (s.size() <= 1) continue;
            HashSet<XMethod> conflictingMethods = this.canonicalToXMethod.get(allSmall);
            Iterator<XMethod> j = conflictingMethods.iterator();
            while (j.hasNext()) {
                if (!this.checkSuper(j.next(), conflictingMethods)) continue;
                j.remove();
            }
            for (XMethod conflictingMethod : conflictingMethods) {
                if (this.checkNonSuper(conflictingMethod, conflictingMethods)) break;
            }
        }
    }

    public String stripPackageName(String className) {
        if (className.indexOf(46) >= 0) {
            return className.substring(className.lastIndexOf(46) + 1);
        }
        if (className.indexOf(47) >= 0) {
            return className.substring(className.lastIndexOf(47) + 1);
        }
        return className;
    }

    public boolean sameSimpleName(String class1, String class2) {
        return class1 != null && class2 != null && this.stripPackageName(class1).equals(this.stripPackageName(class2));
    }

    public void visitJavaClass(JavaClass obj) {
        String name = obj.getClassName();
        if (!this.visited.add(name)) {
            return;
        }
        String superClassName = obj.getSuperclassName();
        if (!name.equals("java.lang.Object")) {
            if (this.sameSimpleName(superClassName, name)) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "NM_SAME_SIMPLE_NAME_AS_SUPERCLASS", 1).addClass(name).addClass(superClassName));
            }
            for (String interfaceName : obj.getInterfaceNames()) {
                if (!this.sameSimpleName(interfaceName, name)) continue;
                this.bugReporter.reportBug(new BugInstance((Detector)this, "NM_SAME_SIMPLE_NAME_AS_INTERFACE", 2).addClass(name).addClass(interfaceName));
            }
        }
        if (obj.isInterface()) {
            return;
        }
        if (superClassName.equals("java.lang.Object") && !this.visited.contains(superClassName)) {
            try {
                this.visitJavaClass(obj.getSuperClass());
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        super.visitJavaClass(obj);
    }

    private static boolean mightInheritFromException(ClassDescriptor d) {
        while (d != null) {
            try {
                if ("java.lang.Exception".equals(d.getDottedClassName())) {
                    return true;
                }
                XClass classNameAndInfo = (XClass)Global.getAnalysisCache().getClassAnalysis(XClass.class, d);
                d = classNameAndInfo.getSuperclassDescriptor();
            }
            catch (CheckedAnalysisException e) {
                return true;
            }
        }
        return false;
    }

    public void visit(JavaClass obj) {
        String name = obj.getClassName();
        String[] parts = name.split("[$+.]");
        this.baseClassName = parts[parts.length - 1];
        boolean bl = this.classIsPublicOrProtected = obj.isPublic() || obj.isProtected();
        if (this.baseClassName.length() == 1) {
            return;
        }
        if (Character.isLetter(this.baseClassName.charAt(0)) && !Character.isUpperCase(this.baseClassName.charAt(0)) && this.baseClassName.indexOf("_") == -1) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "NM_CLASS_NAMING_CONVENTION", this.classIsPublicOrProtected ? 2 : 3).addClass((PreorderVisitor)this));
        }
        if (name.endsWith("Exception") && !Naming.mightInheritFromException(DescriptorFactory.createClassDescriptor((JavaClass)obj))) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "NM_CLASS_NOT_EXCEPTION", 2).addClass((PreorderVisitor)this));
        }
        super.visit(obj);
    }

    public void visit(Field obj) {
        if (this.getFieldName().length() == 1) {
            return;
        }
        if (!obj.isFinal() && Character.isLetter(this.getFieldName().charAt(0)) && !Character.isLowerCase(this.getFieldName().charAt(0)) && this.getFieldName().indexOf("_") == -1 && Character.isLetter(this.getFieldName().charAt(1)) && Character.isLowerCase(this.getFieldName().charAt(1))) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "NM_FIELD_NAMING_CONVENTION", this.classIsPublicOrProtected && (obj.isPublic() || obj.isProtected()) ? 2 : 3).addClass((PreorderVisitor)this).addVisitedField((PreorderVisitor)this));
        }
    }

    private boolean isInnerClass(JavaClass obj) {
        for (Field f : obj.getFields()) {
            if (!f.getName().startsWith("this$")) continue;
            return true;
        }
        return false;
    }

    private boolean markedAsNotUsable(Method obj) {
        for (Attribute a : obj.getAttributes()) {
            if (!(a instanceof Deprecated)) continue;
            return true;
        }
        Code code = obj.getCode();
        if (code == null) {
            return false;
        }
        byte[] codeBytes = code.getCode();
        if (codeBytes.length > 1 && codeBytes.length < 10) {
            int lastOpcode = codeBytes[codeBytes.length - 1] & 0xFF;
            if (lastOpcode != 191) {
                return false;
            }
            for (byte b : codeBytes) {
                if ((b & 0xFF) != 177) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @CheckForNull
    private static Method findVoidConstructor(JavaClass clazz) {
        for (Method m : clazz.getMethods()) {
            if (!m.getName().equals("<init>") || !m.getSignature().equals("()V")) continue;
            return m;
        }
        return null;
    }

    public void visit(Method obj) {
        String mName = this.getMethodName();
        if (mName.length() == 1) {
            return;
        }
        if (mName.equals("isRequestedSessionIdFromURL") || mName.equals("isRequestedSessionIdFromUrl")) {
            return;
        }
        if (Character.isLetter(mName.charAt(0)) && !Character.isLowerCase(mName.charAt(0)) && Character.isLetter(mName.charAt(1)) && Character.isLowerCase(mName.charAt(1)) && mName.indexOf("_") == -1) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "NM_METHOD_NAMING_CONVENTION", this.classIsPublicOrProtected && (obj.isPublic() || obj.isProtected()) ? 2 : 3).addClassAndMethod((PreorderVisitor)this));
        }
        String sig = this.getMethodSig();
        if (mName.equals(this.baseClassName) && sig.equals("()V")) {
            Code code = obj.getCode();
            Method realVoidConstructor = Naming.findVoidConstructor(this.getThisClass());
            if (code != null && !this.markedAsNotUsable(obj)) {
                int priority = 2;
                if (this.codeDoesSomething(code)) {
                    --priority;
                } else if (!obj.isPublic() && this.getThisClass().isPublic()) {
                    --priority;
                }
                if (realVoidConstructor == null) {
                    ++priority;
                }
                this.bugReporter.reportBug(new BugInstance((Detector)this, "NM_METHOD_CONSTRUCTOR_CONFUSION", priority).addClassAndMethod((PreorderVisitor)this).lowerPriorityIfDeprecated());
                return;
            }
        }
        if (obj.isAbstract()) {
            return;
        }
        if (obj.isPrivate()) {
            return;
        }
        if (mName.equals("equal") && sig.equals("(Ljava/lang/Object;)Z")) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "NM_BAD_EQUAL", 1).addClassAndMethod((PreorderVisitor)this).lowerPriorityIfDeprecated());
            return;
        }
        if (mName.equals("hashcode") && sig.equals("()I")) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "NM_LCASE_HASHCODE", 1).addClassAndMethod((PreorderVisitor)this).lowerPriorityIfDeprecated());
            return;
        }
        if (mName.equals("tostring") && sig.equals("()Ljava/lang/String;")) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "NM_LCASE_TOSTRING", 1).addClassAndMethod((PreorderVisitor)this).lowerPriorityIfDeprecated());
            return;
        }
        if (obj.isPrivate() || obj.isStatic() || mName.equals("<init>")) {
            return;
        }
        String trueName = mName + sig;
        String sig2 = Naming.removePackageNamesFromSignature(sig);
        String allSmall = mName.toLowerCase() + sig2;
        XMethod xm = this.getXMethod();
        HashSet<String> s = this.canonicalToTrueMapping.get(allSmall);
        if (s == null) {
            s = new HashSet();
            this.canonicalToTrueMapping.put(allSmall, s);
        }
        s.add(trueName);
        s = this.canonicalToXMethod.get(allSmall);
        if (s == null) {
            s = new HashSet();
            this.canonicalToXMethod.put(allSmall, s);
        }
        s.add((String)xm);
    }

    private boolean codeDoesSomething(Code code) {
        byte[] codeBytes = code.getCode();
        return codeBytes.length > 1;
    }

    private static String removePackageNamesFromSignature(String sig) {
        int end = sig.indexOf(")");
        Matcher m = sigType.matcher(sig.substring(0, end));
        return m.replaceAll("L$2") + sig.substring(end);
    }

    public static class NamingProperty
    extends AbstractWarningProperty {
        public static final NamingProperty METHOD_IS_CALLED = new NamingProperty("CONFUSING_METHOD_IS_CALLED", PriorityAdjustment.LOWER_PRIORITY);
        public static final NamingProperty METHOD_IS_DEPRECATED = new NamingProperty("CONFUSING_METHOD_IS_DEPRECATED", PriorityAdjustment.LOWER_PRIORITY);

        private NamingProperty(String name, PriorityAdjustment priorityAdjustment) {
            super(name, priorityAdjustment);
        }
    }
}

