/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.DeepSubtypeAnalysis;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.bcel.classfile.Attribute;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Synthetic;
import org.apache.bcel.classfile.Visitor;

public class SerializableIdiom
extends OpcodeStackDetector {
    private static final boolean DEBUG = SystemProperties.getBoolean((String)"se.debug");
    static final boolean reportTransientFieldOfNonSerializableClass = SystemProperties.getBoolean((String)"reportTransientFieldOfNonSerializableClass");
    boolean sawSerialVersionUID;
    boolean isSerializable;
    boolean implementsSerializableDirectly;
    boolean isExternalizable;
    boolean isGUIClass;
    boolean foundSynthetic;
    boolean seenTransientField;
    boolean foundSynchronizedMethods;
    boolean writeObjectIsSynchronized;
    private BugReporter bugReporter;
    boolean isAbstract;
    private List<BugInstance> fieldWarningList = new LinkedList<BugInstance>();
    private HashMap<String, XField> fieldsThatMightBeAProblem = new HashMap();
    private HashMap<String, XField> transientFields = new HashMap();
    private HashMap<String, Integer> transientFieldsUpdates = new HashMap();
    private HashSet<String> transientFieldsSetInConstructor = new HashSet();
    private HashSet<String> transientFieldsSetToDefaultValueInConstructor = new HashSet();
    private boolean sawReadExternal;
    private boolean sawWriteExternal;
    private boolean sawReadObject;
    private boolean sawReadResolve;
    private boolean sawWriteObject;
    private boolean superClassImplementsSerializable;
    private boolean hasPublicVoidConstructor;
    private boolean superClassHasVoidConstructor;
    private boolean directlyImplementsExternalizable;
    static final Pattern anonymousInnerClassNamePattern = Pattern.compile(".+\\$\\d+");
    boolean isAnonymousInnerClass;
    boolean innerClassHasOuterInstance;
    private boolean isEnum;

    public SerializableIdiom(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        classContext.getJavaClass().accept((Visitor)this);
        this.flush();
    }

    private void flush() {
        if (!(this.isAbstract || this.sawReadExternal && this.sawWriteExternal || this.sawReadObject && this.sawWriteObject)) {
            for (BugInstance aFieldWarningList : this.fieldWarningList) {
                this.bugReporter.reportBug(aFieldWarningList);
            }
        }
        this.fieldWarningList.clear();
    }

    public void visit(JavaClass obj) {
        block19: {
            String[] interface_names;
            String superClassname = obj.getSuperclassName();
            this.isEnum = superClassname.equals("java.lang.Enum");
            if (this.isEnum) {
                return;
            }
            int flags = obj.getAccessFlags();
            this.isAbstract = (flags & 0x400) != 0 || (flags & 0x200) != 0;
            this.isAnonymousInnerClass = anonymousInnerClassNamePattern.matcher(this.getClassName()).matches();
            this.innerClassHasOuterInstance = false;
            for (Field f : obj.getFields()) {
                if (!f.getName().equals("this$0")) continue;
                this.innerClassHasOuterInstance = true;
                break;
            }
            this.sawSerialVersionUID = false;
            this.implementsSerializableDirectly = false;
            this.isSerializable = false;
            this.isExternalizable = false;
            this.directlyImplementsExternalizable = false;
            this.isGUIClass = false;
            this.seenTransientField = false;
            this.fieldsThatMightBeAProblem.clear();
            this.transientFields.clear();
            this.transientFieldsUpdates.clear();
            this.transientFieldsSetInConstructor.clear();
            this.transientFieldsSetToDefaultValueInConstructor.clear();
            for (String interface_name : interface_names = obj.getInterfaceNames()) {
                if (interface_name.equals("java.io.Externalizable")) {
                    this.directlyImplementsExternalizable = true;
                    this.isExternalizable = true;
                    if (!DEBUG) continue;
                    System.out.println("Directly implements Externalizable: " + this.getClassName());
                    continue;
                }
                if (!interface_name.equals("java.io.Serializable")) continue;
                this.implementsSerializableDirectly = true;
                this.isSerializable = true;
                if (!DEBUG) break;
                System.out.println("Directly implements Serializable: " + this.getClassName());
                break;
            }
            if (!this.isSerializable) {
                if (Subtypes2.instanceOf((JavaClass)obj, (String)"java.io.Externalizable")) {
                    this.isExternalizable = true;
                    if (DEBUG) {
                        System.out.println("Indirectly implements Externalizable: " + this.getClassName());
                    }
                }
                if (Subtypes2.instanceOf((JavaClass)obj, (String)"java.io.Serializable")) {
                    this.isSerializable = true;
                    if (DEBUG) {
                        System.out.println("Indirectly implements Serializable: " + this.getClassName());
                    }
                }
            }
            this.hasPublicVoidConstructor = false;
            this.superClassHasVoidConstructor = true;
            this.superClassImplementsSerializable = this.isSerializable && !this.implementsSerializableDirectly;
            ClassDescriptor superclassDescriptor = this.getXClass().getSuperclassDescriptor();
            if (superclassDescriptor != null) {
                try {
                    XClass superXClass = (XClass)Global.getAnalysisCache().getClassAnalysis(XClass.class, superclassDescriptor);
                    if (superXClass == null) break block19;
                    this.superClassImplementsSerializable = AnalysisContext.currentAnalysisContext().getSubtypes2().isSubtype(superXClass.getClassDescriptor(), DescriptorFactory.createClassDescriptor((String)"java/io/Serializable"));
                    this.superClassHasVoidConstructor = false;
                    for (XMethod m : superXClass.getXMethods()) {
                        if (!m.getName().equals("<init>") || !m.getSignature().equals("()V") || m.isPrivate()) continue;
                        this.superClassHasVoidConstructor = true;
                        break;
                    }
                }
                catch (ClassNotFoundException e) {
                    this.bugReporter.reportMissingClass(e);
                }
                catch (CheckedAnalysisException e) {
                    this.bugReporter.logError("huh", (Throwable)e);
                }
            }
        }
        this.isGUIClass = false;
        boolean bl = this.isGUIClass = Subtypes2.instanceOf((JavaClass)obj, (String)"java.lang.Throwable") || Subtypes2.instanceOf((JavaClass)obj, (String)"java.awt.Component") || Subtypes2.instanceOf((JavaClass)obj, (String)"java.awt.Component$AccessibleAWTComponent") || Subtypes2.instanceOf((JavaClass)obj, (String)"java.awt.event.ActionListener") || Subtypes2.instanceOf((JavaClass)obj, (String)"java.util.EventListener");
        if (!this.isGUIClass) {
            for (JavaClass o = obj; o != null; o = o.getSuperClass()) {
                if (o.getClassName().startsWith("java.awt") || o.getClassName().startsWith("javax.swing")) {
                    this.isGUIClass = true;
                    break;
                }
                try {
                    continue;
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                    break;
                }
            }
        }
        this.foundSynthetic = false;
        this.foundSynchronizedMethods = false;
        this.writeObjectIsSynchronized = false;
        this.sawWriteObject = false;
        this.sawReadResolve = false;
        this.sawReadObject = false;
        this.sawWriteExternal = false;
        this.sawReadExternal = false;
    }

    public void visitAfter(JavaClass obj) {
        int priority;
        if (this.isEnum) {
            return;
        }
        if (DEBUG) {
            System.out.println(this.getDottedClassName());
            System.out.println("  hasPublicVoidConstructor: " + this.hasPublicVoidConstructor);
            System.out.println("  superClassHasVoidConstructor: " + this.superClassHasVoidConstructor);
            System.out.println("  isExternalizable: " + this.isExternalizable);
            System.out.println("  isSerializable: " + this.isSerializable);
            System.out.println("  isAbstract: " + this.isAbstract);
            System.out.println("  superClassImplementsSerializable: " + this.superClassImplementsSerializable);
        }
        if (this.isSerializable && !this.sawReadObject && !this.sawReadResolve && this.seenTransientField) {
            for (Map.Entry<String, Integer> e : this.transientFieldsUpdates.entrySet()) {
                XField fieldX = this.transientFields.get(e.getKey());
                int priority2 = 2;
                if (this.transientFieldsSetInConstructor.contains(e.getKey())) {
                    --priority2;
                } else {
                    if (this.isGUIClass) {
                        ++priority2;
                    }
                    if (e.getValue() < 3) {
                        ++priority2;
                    }
                    if (this.transientFieldsSetToDefaultValueInConstructor.contains(e.getKey())) {
                        ++priority2;
                    }
                }
                try {
                    double isSerializable = DeepSubtypeAnalysis.isDeepSerializable((String)fieldX.getSignature());
                    if (isSerializable < 0.6) {
                        ++priority2;
                    }
                }
                catch (ClassNotFoundException e1) {
                    // empty catch block
                }
                this.bugReporter.reportBug(new BugInstance((Detector)this, "SE_TRANSIENT_FIELD_NOT_RESTORED", priority2).addClass(this.getThisClass()).addField(fieldX));
            }
        }
        if (this.isSerializable && !this.isExternalizable && !this.superClassHasVoidConstructor && !this.superClassImplementsSerializable) {
            int priority3;
            int n = this.implementsSerializableDirectly || this.seenTransientField ? 1 : (priority3 = this.sawSerialVersionUID ? 2 : 3);
            if (this.isGUIClass) {
                ++priority3;
            }
            this.bugReporter.reportBug(new BugInstance((Detector)this, "SE_NO_SUITABLE_CONSTRUCTOR", priority3).addClass(this.getThisClass().getClassName()));
        }
        int n = priority = this.isGUIClass ? 3 : 2;
        if (obj.getClassName().endsWith("_Stub")) {
            ++priority;
        }
        if (this.isExternalizable && !this.hasPublicVoidConstructor && !this.isAbstract) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "SE_NO_SUITABLE_CONSTRUCTOR_FOR_EXTERNALIZATION", this.directlyImplementsExternalizable ? 1 : 2).addClass(this.getThisClass().getClassName()));
        }
        if (!this.foundSynthetic) {
            ++priority;
        }
        if (this.seenTransientField) {
            --priority;
        }
        if (!(this.isAnonymousInnerClass || this.isExternalizable || this.isGUIClass || obj.isAbstract() || !this.isSerializable || this.isAbstract || this.sawSerialVersionUID)) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "SE_NO_SERIALVERSIONID", priority).addClass((PreorderVisitor)this));
        }
        if (this.writeObjectIsSynchronized && !this.foundSynchronizedMethods) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "WS_WRITEOBJECT_SYNC", 3).addClass((PreorderVisitor)this));
        }
    }

    public void visit(Method obj) {
        boolean isSynchronized;
        int accessFlags = obj.getAccessFlags();
        boolean bl = isSynchronized = (accessFlags & 0x20) != 0;
        if (this.getMethodName().equals("<init>") && this.getMethodSig().equals("()V") && (accessFlags & 1) != 0) {
            this.hasPublicVoidConstructor = true;
        }
        if (!this.getMethodName().equals("<init>") && this.isSynthetic((FieldOrMethod)obj)) {
            this.foundSynthetic = true;
        }
        if (this.getMethodName().equals("readExternal") && this.getMethodSig().equals("(Ljava/io/ObjectInput;)V")) {
            this.sawReadExternal = true;
            if (DEBUG && !obj.isPrivate()) {
                System.out.println("Non-private readExternal method in: " + this.getDottedClassName());
            }
        } else if (this.getMethodName().equals("writeExternal") && this.getMethodSig().equals("(Ljava/io/Objectoutput;)V")) {
            this.sawWriteExternal = true;
            if (DEBUG && !obj.isPrivate()) {
                System.out.println("Non-private writeExternal method in: " + this.getDottedClassName());
            }
        } else if (this.getMethodName().equals("readResolve") && this.getMethodSig().startsWith("()") && this.isSerializable) {
            this.sawReadResolve = true;
            if (!this.getMethodSig().equals("()Ljava/lang/Object;")) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "SE_READ_RESOLVE_MUST_RETURN_OBJECT", 1).addClassAndMethod((PreorderVisitor)this));
            }
        } else if (this.getMethodName().equals("readObject") && this.getMethodSig().equals("(Ljava/io/ObjectInputStream;)V") && this.isSerializable) {
            this.sawReadObject = true;
            if (!obj.isPrivate()) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "SE_METHOD_MUST_BE_PRIVATE", 1).addClassAndMethod((PreorderVisitor)this));
            }
        } else if (this.getMethodName().equals("readObjectNoData") && this.getMethodSig().equals("()V") && this.isSerializable) {
            if (!obj.isPrivate()) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "SE_METHOD_MUST_BE_PRIVATE", 1).addClassAndMethod((PreorderVisitor)this));
            }
        } else if (this.getMethodName().equals("writeObject") && this.getMethodSig().equals("(Ljava/io/ObjectOutputStream;)V") && this.isSerializable) {
            this.sawReadObject = true;
            if (!obj.isPrivate()) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "SE_METHOD_MUST_BE_PRIVATE", 1).addClassAndMethod((PreorderVisitor)this));
            }
        }
        if (isSynchronized) {
            if (this.getMethodName().equals("readObject") && this.getMethodSig().equals("(Ljava/io/ObjectInputStream;)V") && this.isSerializable) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "RS_READOBJECT_SYNC", 2).addClass((PreorderVisitor)this));
            } else if (this.getMethodName().equals("writeObject") && this.getMethodSig().equals("(Ljava/io/ObjectOutputStream;)V") && this.isSerializable) {
                this.writeObjectIsSynchronized = true;
            } else {
                this.foundSynchronizedMethods = true;
            }
        }
        super.visit(obj);
    }

    boolean isSynthetic(FieldOrMethod obj) {
        Attribute[] a;
        for (Attribute aA : a = obj.getAttributes()) {
            if (!(aA instanceof Synthetic)) continue;
            return true;
        }
        return false;
    }

    public void visit(Code obj) {
        if (this.isSerializable) {
            super.visit(obj);
        }
    }

    public void sawOpcode(int seen) {
        if (seen == 181) {
            String nameOfClass = this.getClassConstantOperand();
            if (this.getClassName().equals(nameOfClass)) {
                String nameOfField;
                Object constant;
                boolean isPutOfDefaultValue;
                OpcodeStack.Item first = this.stack.getStackItem(0);
                boolean bl = isPutOfDefaultValue = first.isNull() || first.isInitialParameter();
                if (!isPutOfDefaultValue && first.getConstant() != null && ((constant = first.getConstant()) instanceof Number && ((Number)constant).intValue() == 0 || constant.equals(Boolean.FALSE))) {
                    isPutOfDefaultValue = true;
                }
                if (isPutOfDefaultValue) {
                    nameOfField = this.getNameConstantOperand();
                    if (this.getMethodName().equals("<init>")) {
                        this.transientFieldsSetToDefaultValueInConstructor.add(nameOfField);
                    }
                } else {
                    nameOfField = this.getNameConstantOperand();
                    if (this.transientFieldsUpdates.containsKey(nameOfField)) {
                        if (this.getMethodName().equals("<init>")) {
                            this.transientFieldsSetInConstructor.add(nameOfField);
                        } else {
                            this.transientFieldsUpdates.put(nameOfField, this.transientFieldsUpdates.get(nameOfField) + 1);
                        }
                    } else if (this.fieldsThatMightBeAProblem.containsKey(nameOfField)) {
                        try {
                            String genSig;
                            XField f;
                            String sig;
                            JavaClass classStored = first.getJavaClass();
                            if (classStored == null) {
                                JavaClass huh = first.getJavaClass();
                                return;
                            }
                            double isSerializable = DeepSubtypeAnalysis.isDeepSerializable((JavaClass)classStored);
                            if (isSerializable <= 0.2 && !(sig = (f = this.fieldsThatMightBeAProblem.get(nameOfField)).getSignature()).equals(genSig = "L" + classStored.getClassName().replace('.', '/') + ";")) {
                                double bias = 0.0;
                                if (!this.getMethodName().equals("<init>")) {
                                    bias = 1.0;
                                }
                                int priority = this.computePriority(isSerializable, bias);
                                this.fieldWarningList.add(new BugInstance((Detector)this, "SE_BAD_FIELD_STORE", priority).addClass(this.getThisClass().getClassName()).addField(f).addType(genSig).describe("TYPE_FOUND").addSourceLine((BytecodeScanningDetector)this));
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    public void visit(Field obj) {
        int flags = obj.getAccessFlags();
        if (obj.isTransient()) {
            if (this.isSerializable) {
                this.seenTransientField = true;
                this.transientFields.put(obj.getName(), XFactory.createXField((PreorderVisitor)this));
                this.transientFieldsUpdates.put(obj.getName(), 0);
            } else if (reportTransientFieldOfNonSerializableClass) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "SE_TRANSIENT_FIELD_OF_NONSERIALIZABLE_CLASS", 2).addClass((PreorderVisitor)this).addVisitedField((PreorderVisitor)this));
            }
        } else if (this.getClassName().indexOf("ObjectStreamClass") == -1 && this.isSerializable && !this.isExternalizable && this.getFieldSig().indexOf("L") >= 0 && !obj.isTransient() && !obj.isStatic()) {
            if (DEBUG) {
                System.out.println("Examining non-transient field with name: " + this.getFieldName() + ", sig: " + this.getFieldSig());
            }
            try {
                double isSerializable = DeepSubtypeAnalysis.isDeepSerializable((String)this.getFieldSig());
                if (DEBUG) {
                    System.out.println("  isSerializable: " + isSerializable);
                }
                if (isSerializable < 1.0) {
                    this.fieldsThatMightBeAProblem.put(obj.getName(), XFactory.createXField((PreorderVisitor)this));
                }
                if (isSerializable < 0.9) {
                    int priority = this.computePriority(isSerializable, 0.0);
                    if (priority > 2 && obj.getName().startsWith("this$")) {
                        priority = 2;
                    } else if (this.innerClassHasOuterInstance) {
                        priority = this.isAnonymousInnerClass ? (priority += 2) : ++priority;
                    }
                    if (this.isGUIClass) {
                        ++priority;
                    }
                    if (DEBUG) {
                        System.out.println("SE_BAD_FIELD: " + this.getThisClass().getClassName() + " " + obj.getName() + " " + isSerializable + " " + this.implementsSerializableDirectly + " " + this.sawSerialVersionUID + " " + this.isGUIClass);
                    }
                    if (obj.getName().equals("this$0")) {
                        this.fieldWarningList.add(new BugInstance((Detector)this, "SE_BAD_FIELD_INNER_CLASS", priority).addClass(this.getThisClass().getClassName()));
                    } else if (isSerializable < 0.9) {
                        this.fieldWarningList.add(new BugInstance((Detector)this, "SE_BAD_FIELD", priority).addClass(this.getThisClass().getClassName()).addField(this.getDottedClassName(), obj.getName(), this.getFieldSig(), false));
                    }
                } else if (!this.isGUIClass && obj.getName().equals("this$0")) {
                    this.fieldWarningList.add(new BugInstance((Detector)this, "SE_INNER_CLASS", this.implementsSerializableDirectly ? 2 : 3).addClass(this.getThisClass().getClassName()));
                }
            }
            catch (ClassNotFoundException e) {
                if (DEBUG) {
                    System.out.println("Caught ClassNotFoundException");
                }
                this.bugReporter.reportMissingClass(e);
            }
        }
        if (!this.getFieldName().startsWith("this") && this.isSynthetic((FieldOrMethod)obj)) {
            this.foundSynthetic = true;
        }
        if (!this.getFieldName().equals("serialVersionUID")) {
            return;
        }
        int mask = 24;
        if (!this.getFieldSig().equals("I") && !this.getFieldSig().equals("J")) {
            return;
        }
        if ((flags & mask) == mask && this.getFieldSig().equals("I")) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "SE_NONLONG_SERIALVERSIONID", 3).addClass((PreorderVisitor)this).addVisitedField((PreorderVisitor)this));
            this.sawSerialVersionUID = true;
            return;
        }
        if ((flags & 8) == 0) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "SE_NONSTATIC_SERIALVERSIONID", 2).addClass((PreorderVisitor)this).addVisitedField((PreorderVisitor)this));
            return;
        }
        if ((flags & 0x10) == 0) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "SE_NONFINAL_SERIALVERSIONID", 2).addClass((PreorderVisitor)this).addVisitedField((PreorderVisitor)this));
            return;
        }
        this.sawSerialVersionUID = true;
    }

    private int computePriority(double isSerializable, double bias) {
        int priority = (int)(1.9 + isSerializable * 3.0 + bias);
        if (this.implementsSerializableDirectly || this.sawSerialVersionUID || this.sawReadObject) {
            --priority;
        }
        if (!this.implementsSerializableDirectly && priority == 1) {
            priority = 2;
        }
        return priority;
    }
}

