/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.LockDataflow;
import edu.umd.cs.findbugs.ba.LockSet;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Collection;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Constant;
import org.apache.bcel.classfile.ConstantClass;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class StaticCalendarDetector
extends OpcodeStackDetector {
    private static final boolean DEBUG = Boolean.getBoolean("debug.staticcal");
    private static final String PROP_SKIP_SYNCHRONIZED_CHECK = "staticcal.skipsynccheck";
    private final BugReporter reporter;
    private final BugAccumulator bugAccumulator;
    private String currentClass;
    private final ClassDescriptor calendarType = DescriptorFactory.createClassDescriptor((String)"java/util/Calendar");
    private final ClassDescriptor dateFormatType = DescriptorFactory.createClassDescriptor((String)"java/text/DateFormat");
    private Method currentMethod = null;
    private CFG currentCFG;
    private LockDataflow currentLockDataFlow;
    Subtypes2 subtypes2 = AnalysisContext.currentAnalysisContext().getSubtypes2();
    private boolean sawDateClass;

    public StaticCalendarDetector(BugReporter aReporter) {
        this.reporter = aReporter;
        this.bugAccumulator = new BugAccumulator(this.reporter);
    }

    public void visit(JavaClass someObj) {
        this.currentClass = someObj.getClassName();
        this.currentMethod = null;
        this.currentCFG = null;
        this.currentLockDataFlow = null;
        this.sawDateClass = false;
    }

    public void visit(ConstantPool pool) {
        for (Constant constant : pool.getConstantPool()) {
            ConstantClass cc;
            String className;
            if (!(constant instanceof ConstantClass) || !(className = (cc = (ConstantClass)constant).getBytes(pool)).equals("java/util/Calendar") && !className.equals("java/text/DateFormat")) continue;
            this.sawDateClass = true;
        }
    }

    public void visit(Field aField) {
        if (!aField.isStatic()) {
            return;
        }
        if (!aField.isPublic() && !aField.isProtected()) {
            return;
        }
        ClassDescriptor classOfField = DescriptorFactory.createClassDescriptorFromFieldSignature((String)aField.getSignature());
        String tBugType = null;
        if (classOfField != null) {
            try {
                if (this.subtypes2.isSubtype(classOfField, this.calendarType)) {
                    tBugType = "STCAL_STATIC_CALENDAR_INSTANCE";
                } else if (this.subtypes2.isSubtype(classOfField, this.dateFormatType)) {
                    tBugType = "STCAL_STATIC_SIMPLE_DATE_FORMAT_INSTANCE";
                }
                if (tBugType != null) {
                    this.reporter.reportBug(new BugInstance((Detector)this, tBugType, aField.isPublic() ? 1 : 2).addClass(this.currentClass).addField((PreorderVisitor)this));
                }
            }
            catch (ClassNotFoundException e) {
                AnalysisContext.reportMissingClass((ClassNotFoundException)e);
            }
        }
    }

    public void visitMethod(Method obj) {
        if (this.sawDateClass) {
            try {
                super.visitMethod(obj);
                this.currentMethod = obj;
                this.currentLockDataFlow = this.getClassContext().getLockDataflow(this.currentMethod);
                this.currentCFG = this.getClassContext().getCFG(this.currentMethod);
            }
            catch (CFGBuilderException e) {
                this.reporter.logError("Synchronization check in Static Calendar Detector caught an error.", (Throwable)e);
            }
            catch (DataflowAnalysisException e) {
                this.reporter.logError("Synchronization check in Static Calendar Detector caught an error.", (Throwable)e);
            }
        }
    }

    public void visit(Code obj) {
        if (this.sawDateClass) {
            super.visit(obj);
            this.bugAccumulator.reportAccumulatedBugs();
        }
    }

    public void sawOpcode(int seen) {
        if (seen != 182) {
            return;
        }
        try {
            String tBugType;
            OpcodeStack.Item passedAsArgument;
            String className = this.getClassConstantOperand();
            if (className.startsWith("[")) {
                return;
            }
            ClassDescriptor cDesc = DescriptorFactory.createClassDescriptor((String)className);
            boolean isCalendar = this.subtypes2.isSubtype(cDesc, this.calendarType);
            boolean isDateFormat = this.subtypes2.isSubtype(cDesc, this.dateFormatType);
            if (!isCalendar && !isDateFormat) {
                return;
            }
            int numArguments = StaticCalendarDetector.getNumberArguments((String)this.getSigConstantOperand());
            OpcodeStack.Item invokedOn = this.stack.getStackItem(numArguments);
            XField field = invokedOn.getXField();
            if (field == null || !field.isStatic()) {
                return;
            }
            if (this.getMethodName().equals("<clinit>") && field.getClassName().equals(this.getDottedClassName())) {
                return;
            }
            if (this.getNameConstantOperand().equals("equals") && numArguments == 1 && ((field = (passedAsArgument = this.stack.getStackItem(0)).getXField()) == null || !field.isStatic())) {
                return;
            }
            if (!SystemProperties.getBoolean((String)PROP_SKIP_SYNCHRONIZED_CHECK)) {
                try {
                    if (this.currentMethod != null && this.currentLockDataFlow != null && this.currentCFG != null) {
                        Collection tLocations = this.currentCFG.getLocationsContainingInstructionWithOffset(this.getPC());
                        for (Location tLoc : tLocations) {
                            LockSet lockSet = (LockSet)this.currentLockDataFlow.getFactAtLocation(tLoc);
                            if (lockSet.getNumLockedObjects() <= 0) continue;
                            return;
                        }
                    }
                }
                catch (DataflowAnalysisException e) {
                    this.reporter.logError("Synchronization check in Static Calendar Detector caught an error.", (Throwable)e);
                }
            }
            if (isCalendar) {
                tBugType = "STCAL_INVOKE_ON_STATIC_CALENDAR_INSTANCE";
            } else if (isDateFormat) {
                tBugType = "STCAL_INVOKE_ON_STATIC_DATE_FORMAT_INSTANCE";
            } else {
                throw new IllegalStateException("Not possible");
            }
            this.bugAccumulator.accumulateBug(new BugInstance((Detector)this, tBugType, 2).addClassAndMethod((PreorderVisitor)this).addCalledMethod((DismantleBytecode)this).addOptionalField(field), (BytecodeScanningDetector)this);
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass((ClassNotFoundException)e);
        }
    }
}

