/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs;

import de.tobject.findbugs.FindbugsSaveParticipant;
import de.tobject.findbugs.builder.FindBugsBuilder;
import de.tobject.findbugs.builder.FindBugsWorker;
import de.tobject.findbugs.io.FileOutput;
import de.tobject.findbugs.io.IO;
import de.tobject.findbugs.nature.FindBugsNature;
import de.tobject.findbugs.reporter.Reporter;
import de.tobject.findbugs.view.DetailsView;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import edu.umd.cs.findbugs.config.UserPreferences;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.BugResolutionAssociations;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.BugResolutionLoader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.dom4j.DocumentException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class FindbugsPlugin
extends AbstractUIPlugin {
    public static final String ICON_PATH = "icons/";
    public static final String DETAILS_VIEW_ID = "de.tobject.findbugs.view.detailsview";
    public static final String USER_ANNOTATIONS_VIEW_ID = "de.tobject.findbugs.view.userannotationsview";
    public static final String TREE_VIEW_ID = "de.tobject.findbugs.view.bugtreeview";
    private Map<String, ImageDescriptor> imageDescriptors = new HashMap<String, ImageDescriptor>(13);
    public static boolean DEBUG;
    public static final String PLUGIN_ID = "edu.umd.cs.findbugs.plugin.eclipse";
    public static final String BUILDER_ID = "edu.umd.cs.findbugs.plugin.eclipse.findbugsBuilder";
    public static final String NATURE_ID = "edu.umd.cs.findbugs.plugin.eclipse.findbugsNature";
    private static final String PLUGIN_DEBUG = "edu.umd.cs.findbugs.plugin.eclipse/debug/plugin";
    private static final String BUILDER_DEBUG = "edu.umd.cs.findbugs.plugin.eclipse/debug/builder";
    private static final String NATURE_DEBUG = "edu.umd.cs.findbugs.plugin.eclipse/debug/nature";
    private static final String REPORTER_DEBUG = "edu.umd.cs.findbugs.plugin.eclipse/debug/reporter";
    public static final QualifiedName SESSION_PROPERTY_BUG_COLLECTION;
    public static final QualifiedName SESSION_PROPERTY_FB_PROJECT;
    public static final QualifiedName SESSION_PROPERTY_BUG_COLLECTION_DIRTY;
    public static final QualifiedName SESSION_PROPERTY_USERPREFS;
    public static final String LIST_DELIMITER = ";";
    private static FindbugsPlugin plugin;
    private ResourceBundle resourceBundle;
    private BugResolutionAssociations bugResolutions;

    public FindbugsPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.configurePluginDebugOptions();
        try {
            this.resourceBundle = ResourceBundle.getBundle("de.tobject.findbugs.messages");
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
        String findBugsHome = FindbugsPlugin.getFindBugsEnginePluginLocation();
        if (DEBUG) {
            this.logInfo("Looking for FindBugs detectors in: " + findBugsHome);
        }
        System.setProperty("findbugs.home", findBugsHome);
        FindbugsSaveParticipant saveParticipant = new FindbugsSaveParticipant();
        ResourcesPlugin.getWorkspace().addSaveParticipant((Plugin)this, (ISaveParticipant)saveParticipant);
    }

    public static FindbugsPlugin getDefault() {
        return plugin;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        if (Display.getCurrent() != null) {
            return FindbugsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        }
        final IWorkbenchWindow[] window = new IWorkbenchWindow[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                window[0] = FindbugsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
            }
        });
        return window[0];
    }

    public static Shell getShell() {
        IWorkbenchWindow window = FindbugsPlugin.getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        return window.getShell();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = FindbugsPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    @SuppressWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public void configurePluginDebugOptions() {
        if (this.isDebugging()) {
            String option = Platform.getDebugOption((String)PLUGIN_DEBUG);
            if (option != null) {
                DEBUG = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)BUILDER_DEBUG)) != null) {
                FindBugsWorker.DEBUG = FindBugsBuilder.DEBUG = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)NATURE_DEBUG)) != null) {
                FindBugsNature.DEBUG = option.equalsIgnoreCase("true");
            }
            if ((option = Platform.getDebugOption((String)REPORTER_DEBUG)) != null) {
                Reporter.DEBUG = option.equalsIgnoreCase("true");
            }
        }
    }

    public static String getFindBugsEnginePluginLocation() {
        URL u = plugin.getBundle().getEntry("/");
        try {
            URL bundleRoot = FileLocator.resolve((URL)u);
            if (FindBugsBuilder.DEBUG) {
                System.out.println("Pluginpath: " + bundleRoot.getPath());
            }
            return bundleRoot.getPath();
        }
        catch (IOException e) {
            FindbugsPlugin.getDefault().logException(e, "IO Exception locating engine plugin");
            return null;
        }
    }

    public String getMessage(String key) {
        return FindbugsPlugin.getResourceString(key);
    }

    public void logException(Throwable e, String message) {
        this.logMessage(4, message, e);
    }

    public void logError(String message) {
        this.logMessage(4, message, null);
    }

    public void logWarning(String message) {
        this.logMessage(2, message, null);
    }

    public void logInfo(String message) {
        this.logMessage(1, message, null);
    }

    public void logMessage(int severity, String message, Throwable e) {
        if (DEBUG) {
            String what = severity == 4 ? (e != null ? "Exception" : "Error") : "Warning";
            System.out.println(what + " in FindBugs plugin: " + message);
            if (e != null) {
                e.printStackTrace();
            }
        }
        Status status = new Status(severity, PLUGIN_ID, 0, message, e);
        this.getLog().log((IStatus)status);
    }

    private static IPath getBugCollectionFile(IProject project) {
        IPath path = FindbugsPlugin.getDefault().getStateLocation();
        return path.append(project.getName() + ".fbwarnings");
    }

    private static boolean isBugCollectionDirty(IProject project) throws CoreException {
        Object dirty = project.getSessionProperty(SESSION_PROPERTY_BUG_COLLECTION_DIRTY);
        if (dirty == null) {
            return false;
        }
        return (Boolean)dirty;
    }

    public static void markBugCollectionDirty(IProject project, boolean isDirty) throws CoreException {
        project.setSessionProperty(SESSION_PROPERTY_BUG_COLLECTION_DIRTY, (Object)(isDirty ? Boolean.TRUE : Boolean.FALSE));
    }

    public static SortedBugCollection getBugCollection(IProject project, IProgressMonitor monitor) throws CoreException {
        SortedBugCollection bugCollection = (SortedBugCollection)project.getSessionProperty(SESSION_PROPERTY_BUG_COLLECTION);
        if (bugCollection == null) {
            try {
                FindbugsPlugin.readBugCollectionAndProject(project, monitor);
                bugCollection = (SortedBugCollection)project.getSessionProperty(SESSION_PROPERTY_BUG_COLLECTION);
            }
            catch (IOException e) {
                FindbugsPlugin.getDefault().logException(e, "Could not read bug collection for project");
                bugCollection = FindbugsPlugin.createDefaultEmptyBugCollection(project);
            }
            catch (DocumentException e) {
                FindbugsPlugin.getDefault().logException(e, "Could not read bug collection for project");
                bugCollection = FindbugsPlugin.createDefaultEmptyBugCollection(project);
            }
        }
        return bugCollection;
    }

    private static void cacheBugCollectionAndProject(IProject project, SortedBugCollection bugCollection, Project fbProject) throws CoreException {
        project.setSessionProperty(SESSION_PROPERTY_BUG_COLLECTION, (Object)bugCollection);
        project.setSessionProperty(SESSION_PROPERTY_FB_PROJECT, (Object)fbProject);
        FindbugsPlugin.markBugCollectionDirty(project, false);
    }

    private static SortedBugCollection createDefaultEmptyBugCollection(IProject project) throws CoreException {
        SortedBugCollection bugCollection = new SortedBugCollection();
        Project fbProject = new Project();
        FindbugsPlugin.cacheBugCollectionAndProject(project, bugCollection, fbProject);
        return bugCollection;
    }

    private static void readBugCollectionAndProject(IProject project, IProgressMonitor monitor) throws IOException, DocumentException, CoreException {
        IPath bugCollectionPath = FindbugsPlugin.getBugCollectionFile(project);
        File bugCollectionFile = bugCollectionPath.toFile();
        if (!bugCollectionFile.exists()) {
            FindbugsPlugin.getDefault().logInfo("creating new bug collection: " + bugCollectionPath.toOSString());
            FindbugsPlugin.createDefaultEmptyBugCollection(project);
            return;
        }
        SortedBugCollection bugCollection = new SortedBugCollection();
        Project findbugsProject = new Project();
        BufferedInputStream contents = new BufferedInputStream(new FileInputStream(bugCollectionFile));
        bugCollection.readXML((InputStream)contents, findbugsProject);
        FindbugsPlugin.cacheBugCollectionAndProject(project, bugCollection, findbugsProject);
    }

    public static void storeBugCollection(IProject project, SortedBugCollection bugCollection, Project findbugsProject, IProgressMonitor monitor) throws IOException, CoreException {
        project.setSessionProperty(SESSION_PROPERTY_BUG_COLLECTION, (Object)bugCollection);
        project.setSessionProperty(SESSION_PROPERTY_FB_PROJECT, (Object)findbugsProject);
        if (bugCollection != null && findbugsProject != null) {
            FindbugsPlugin.writeBugCollection(project, bugCollection, findbugsProject, monitor);
        }
    }

    public static void saveCurrentBugCollection(IProject project, IProgressMonitor monitor) throws CoreException, IOException {
        if (FindbugsPlugin.isBugCollectionDirty(project)) {
            SortedBugCollection bugCollection = (SortedBugCollection)project.getSessionProperty(SESSION_PROPERTY_BUG_COLLECTION);
            Project fbProject = (Project)project.getSessionProperty(SESSION_PROPERTY_FB_PROJECT);
            if (bugCollection != null && fbProject != null) {
                FindbugsPlugin.writeBugCollection(project, bugCollection, fbProject, monitor);
            }
        }
    }

    private static void writeBugCollection(IProject project, final SortedBugCollection bugCollection, final Project findbugsProject, IProgressMonitor monitor) throws CoreException {
        IPath bugCollectionPath = FindbugsPlugin.getBugCollectionFile(project);
        File bugCollectionFile = bugCollectionPath.toFile();
        FileOutput fileOutput = new FileOutput(){

            public void writeFile(OutputStream os) throws IOException {
                bugCollection.writeXML(os, findbugsProject);
            }

            public String getTaskDescription() {
                return "creating XML FindBugs data file";
            }
        };
        IO.writeFile(bugCollectionFile, fileOutput, monitor);
        FindbugsPlugin.markBugCollectionDirty(project, false);
    }

    private static IFile getUserPreferencesFile(IProject project) {
        return project.getFile(".fbprefs");
    }

    public static UserPreferences getUserPreferences(IProject project) throws CoreException {
        UserPreferences prefs = (UserPreferences)project.getSessionProperty(SESSION_PROPERTY_USERPREFS);
        if (prefs == null) {
            prefs = FindbugsPlugin.readUserPreferences(project);
            if (prefs == null) {
                prefs = UserPreferences.createDefaultUserPreferences();
            }
            project.setSessionProperty(SESSION_PROPERTY_USERPREFS, (Object)prefs);
        }
        return prefs;
    }

    public static void saveUserPreferences(IProject project, final UserPreferences userPrefs) throws CoreException, IOException {
        project.setSessionProperty(SESSION_PROPERTY_USERPREFS, (Object)userPrefs);
        IFile userPrefsFile = FindbugsPlugin.getUserPreferencesFile(project);
        FindbugsPlugin.ensureReadWrite(userPrefsFile);
        FileOutput userPrefsOutput = new FileOutput(){

            public void writeFile(OutputStream os) throws IOException {
                userPrefs.write(os);
            }

            public String getTaskDescription() {
                return "writing user preferences for project";
            }
        };
        IO.writeFile(userPrefsFile, userPrefsOutput, null);
    }

    private static void ensureReadWrite(IFile file) throws CoreException {
        IStatus checkOutStatus;
        if (file.isReadOnly() && !(checkOutStatus = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{file}, null)).isOK()) {
            throw new CoreException(checkOutStatus);
        }
    }

    private static UserPreferences readUserPreferences(IProject project) throws CoreException {
        IFile userPrefsFile = FindbugsPlugin.getUserPreferencesFile(project);
        if (!userPrefsFile.exists()) {
            return null;
        }
        try {
            InputStream in = userPrefsFile.getContents(true);
            UserPreferences userPrefs = UserPreferences.createDefaultUserPreferences();
            userPrefs.read(in);
            return userPrefs;
        }
        catch (IOException e) {
            FindbugsPlugin.getDefault().logException(e, "Could not read user preferences for project");
            return null;
        }
    }

    public BugResolutionAssociations getBugResolutions() {
        if (this.bugResolutions == null) {
            this.bugResolutions = this.loadBugResolutions();
        }
        return this.bugResolutions;
    }

    private BugResolutionAssociations loadBugResolutions() {
        BugResolutionLoader loader = new BugResolutionLoader();
        File xmlFile = new File(FindBugs.getHome() + File.separator + "plugin" + File.separator + "findbugs-resolutions.xml");
        return loader.loadBugResolutions(xmlFile);
    }

    public static void showMarker(IMarker marker) {
        DetailsView.showMarker(marker);
    }

    public ImageDescriptor getImageDescriptor(String id) {
        ImageDescriptor imageDescriptor = this.imageDescriptors.get(id);
        if (imageDescriptor == null) {
            imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)FindbugsPlugin.getDefault().getBundle().getSymbolicName(), (String)(ICON_PATH + id));
            this.imageDescriptors.put(id, imageDescriptor);
        }
        return imageDescriptor;
    }

    static {
        SESSION_PROPERTY_BUG_COLLECTION = new QualifiedName("edu.umd.cs.findbugs.plugin.eclipse.sessionprops", "bugcollection");
        SESSION_PROPERTY_FB_PROJECT = new QualifiedName("edu.umd.cs.findbugs.plugin.eclipse.sessionprops", "fbproject");
        SESSION_PROPERTY_BUG_COLLECTION_DIRTY = new QualifiedName("edu.umd.cs.findbugs.plugin.eclipse.sessionprops", "bugcollection.dirty");
        SESSION_PROPERTY_USERPREFS = new QualifiedName("edu.umd.cs.findbugs.plugin.eclipse.sessionprops", "userprefs");
    }
}

