/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.builder;

import de.tobject.findbugs.util.Util;
import edu.umd.cs.findbugs.Project;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.team.internal.core.subscribers.ChangeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtils {
    private static final IResource[] EMPTY = new IResource[0];

    private ResourceUtils() {
    }

    public static void addFiles(Project findBugsProject, File clzDir, Pattern pat) {
        if (clzDir.isDirectory()) {
            clzDir.listFiles(new RecurseFileCollector(pat, findBugsProject));
        }
    }

    public static IPath relativeToAbsolute(IPath relativePath) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember(relativePath);
        if (resource != null) {
            return resource.getLocation();
        }
        return relativePath;
    }

    public static List<IResource> collectIncremental(IResourceDelta delta) {
        ArrayList<IResource> result = new ArrayList<IResource>();
        ArrayList<IResourceDelta> foldersDelta = new ArrayList<IResourceDelta>();
        IResourceDelta[] affectedChildren = delta.getAffectedChildren();
        for (int i = 0; i < affectedChildren.length; ++i) {
            IResourceDelta childDelta = affectedChildren[i];
            IResource child = childDelta.getResource();
            if (child.isDerived()) continue;
            int childType = child.getType();
            int deltaKind = childDelta.getKind();
            if (childType == 1) {
                if (deltaKind != 1 && deltaKind != 4 || !Util.isJavaArtifact(child)) continue;
                result.add(child);
                continue;
            }
            if (childType != 2) continue;
            if (deltaKind == 1) {
                result.add(child);
                continue;
            }
            if (deltaKind == 2) {
                IContainer parent = child.getParent();
                if (parent instanceof IProject) {
                    result.clear();
                    result.add((IResource)parent);
                    return result;
                }
                result.add((IResource)parent);
                continue;
            }
            if (deltaKind == 2) continue;
            foldersDelta.add(childDelta);
        }
        for (IResourceDelta childDelta : foldersDelta) {
            result.addAll(ResourceUtils.collectIncremental(childDelta));
        }
        return result;
    }

    public static Map<IProject, List<IResource>> getResourcesPerProject(IStructuredSelection structuredSelection) {
        HashMap<IProject, List<IResource>> projectsMap = new HashMap<IProject, List<IResource>>();
        for (Object element : structuredSelection) {
            IResource resource = ResourceUtils.getResource(element);
            if (resource == null) {
                ChangeSet set = (ChangeSet)((IAdaptable)element).getAdapter(ChangeSet.class);
                for (IResource change : ResourceUtils.getResources(set)) {
                    ResourceUtils.mapResource(change, projectsMap, true);
                }
                continue;
            }
            ResourceUtils.mapResource(resource, projectsMap, false);
        }
        return projectsMap;
    }

    private static void mapResource(IResource resource, Map<IProject, List<IResource>> projectsMap, boolean checkJavaProject) {
        if (resource.getType() == 1 && !Util.isJavaArtifact(resource)) {
            return;
        }
        IProject project = resource.getProject();
        if (checkJavaProject && !Util.isJavaProject(project)) {
            return;
        }
        List<IResource> resources = projectsMap.get(project);
        if (resources == null) {
            resources = new ArrayList<IResource>();
            projectsMap.put(project, resources);
        }
        if (!ResourceUtils.containsParents(resources, resource)) {
            resources.add(resource);
        }
    }

    public static IResource[] getResources(ChangeSet set) {
        if (set != null && !set.isEmpty()) {
            return set.getResources();
        }
        return EMPTY;
    }

    private static boolean containsParents(List<IResource> resources, IResource candidate) {
        IPath location = candidate.getLocation();
        for (IResource resource : resources) {
            IContainer parent;
            IPath parentLoc;
            if (resource.getType() == 1 || (parentLoc = (parent = (IContainer)resource).getLocation()) == null || !parentLoc.isPrefixOf(location)) continue;
            return true;
        }
        return false;
    }

    public static IResource getResource(Object element) {
        if (element instanceof IResource) {
            return (IResource)element;
        }
        if (element instanceof IAdaptable) {
            return (IResource)((IAdaptable)element).getAdapter(IResource.class);
        }
        return null;
    }

    public static final class RecurseFileCollector
    implements FileFilter {
        private final Pattern pat;
        private final Project findBugsProject;

        private RecurseFileCollector(Pattern pat, Project findBugsProject) {
            this.pat = pat;
            this.findBugsProject = findBugsProject;
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                ResourceUtils.addFiles(this.findBugsProject, file, this.pat);
            } else if (this.pat.matcher(file.getName()).matches()) {
                this.findBugsProject.addFile(file.getAbsolutePath());
            }
            return false;
        }
    }
}

