/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.reporter;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.reporter.MarkerUtil;
import edu.umd.cs.findbugs.AbstractBugReporter;
import edu.umd.cs.findbugs.AnalysisError;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.FindBugsProgress;
import edu.umd.cs.findbugs.ProjectStats;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.config.UserPreferences;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;

public class Reporter
extends AbstractBugReporter
implements FindBugsProgress {
    public static boolean DEBUG;
    private final IJavaProject project;
    private final IProgressMonitor monitor;
    private final SortedBugCollection bugCollection;
    private UserPreferences userPrefs;
    private int pass = -1;
    private int filteredBugCount;

    public Reporter(IJavaProject project, IProgressMonitor monitor) {
        this.monitor = monitor;
        this.project = project;
        this.bugCollection = new SortedBugCollection();
        try {
            this.userPrefs = FindbugsPlugin.getUserPreferences(project.getProject());
        }
        catch (CoreException e) {
            FindbugsPlugin.getDefault().logException(e, "Error getting FindBugs preferences for project");
            this.userPrefs = UserPreferences.createDefaultUserPreferences();
        }
    }

    protected void doReportBug(BugInstance bug) {
        this.getBugCollection().add(bug);
        if (MarkerUtil.displayWarning(bug, this.userPrefs.getFilterSettings())) {
            MarkerUtil.createMarker(bug, this.project, (BugCollection)this.getBugCollection());
            ++this.filteredBugCount;
        }
    }

    public ProjectStats getProjectStats() {
        return this.bugCollection.getProjectStats();
    }

    public void finish() {
        if (DEBUG) {
            System.out.println("Finish: Found " + this.filteredBugCount + " bugs.");
        }
        this.monitor.done();
    }

    public SortedBugCollection getBugCollection() {
        return this.bugCollection;
    }

    public void observeClass(ClassDescriptor classDescriptor) {
        if (this.monitor.isCanceled()) {
            Thread.currentThread().interrupt();
        }
        int work = this.pass == 0 ? 1 : 2;
        String className = classDescriptor.getDottedClassName();
        if (DEBUG) {
            System.out.println("Observing class: " + className);
        }
        if (this.pass <= 0) {
            this.monitor.setTaskName("Prescanning... (found " + this.filteredBugCount + ", checking " + className + ")");
        } else {
            this.monitor.setTaskName("Checking... (pass #" + this.pass + ") (found " + this.filteredBugCount + ", checking " + className + ")");
        }
        this.monitor.worked(work);
    }

    public void reportAnalysisError(AnalysisError error) {
        FindbugsPlugin.getDefault().logException(error.getException(), "FindBugs analysis error: " + error.getMessage());
    }

    public void reportMissingClass(String missingClass) {
        FindbugsPlugin.getDefault().logWarning("FindBugs could not find a class that would be useful in analyzing your code: " + missingClass);
    }

    public BugReporter getRealBugReporter() {
        return this;
    }

    public void finishArchive() {
    }

    public void finishClass() {
    }

    public void finishPerClassAnalysis() {
    }

    public void reportNumberOfArchives(int numArchives) {
    }

    public void startAnalysis(int numClasses) {
        ++this.pass;
    }

    public void predictPassCount(int[] classesPerPass) {
        int expectedWork = 0;
        for (int count : classesPerPass) {
            expectedWork += 2 * count;
        }
        expectedWork -= classesPerPass[0];
        if (!(this.monitor instanceof SubProgressMonitor)) {
            this.monitor.beginTask("Performing bug checking...", expectedWork);
        }
    }
}

