/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.view.explorer;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.view.explorer.BugPatternGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.navigator.CommonViewer;

public class BugContentProvider
implements ITreeContentProvider {
    private CommonViewer viewer;
    private IResourceChangeListener resourceListener;
    private Map<String, BugPatternGroup> groups = new HashMap<String, BugPatternGroup>();
    private static final Object[] EMPTY = new Object[0];
    private static final int SHORT_DELAY = 100;
    private static final int LONG_DELAY = 1000;
    private RefreshJob refreshJob;

    public BugContentProvider() {
        this.resourceListener = new MyResourceChangeListener();
        this.refreshJob = new RefreshJob("Updating bugs in bug exporer");
        this.refreshJob.setSystem(true);
        this.refreshJob.setPriority(50);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceListener);
    }

    public Object[] getChildren(Object parentElement) {
        return this.getElements(parentElement);
    }

    public Object getParent(Object element) {
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            IProject project = resource.getProject();
            return project == resource ? project.getParent() : project;
        }
        if (element instanceof BugPatternGroup) {
            BugPatternGroup groupElement = (BugPatternGroup)element;
            return groupElement.getParent();
        }
        if (element instanceof IMarker) {
            IMarker marker = (IMarker)element;
            String patternDescr = marker.getAttribute("PATTERN_DESCR_SHORT", "");
            BugPatternGroup groupElement = this.groups.get(patternDescr);
            if (groupElement != null) {
                return groupElement;
            }
            return marker.getResource().getProject();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof IResource || element instanceof BugPatternGroup;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IWorkspaceRoot) {
            return this.getWorkspaceRootChildren((IWorkspaceRoot)inputElement);
        }
        if (inputElement instanceof IResource) {
            IResource resource = (IResource)inputElement;
            return this.getResourceChildren(resource);
        }
        if (inputElement instanceof BugPatternGroup) {
            BugPatternGroup groupElement = (BugPatternGroup)inputElement;
            return groupElement.getChildren();
        }
        return EMPTY;
    }

    private Object[] getResourceChildren(IResource resource) {
        IProject project;
        if (resource instanceof IProject && !(project = (IProject)resource).isAccessible()) {
            return EMPTY;
        }
        return BugPatternGroup.createGroups(resource);
    }

    private Object[] getWorkspaceRootChildren(IWorkspaceRoot workspaceRoot) {
        IProject[] projects = workspaceRoot.getProjects();
        ArrayList<IProject> projList = new ArrayList<IProject>();
        for (IProject project : projects) {
            projList.add(project);
        }
        return projList.toArray();
    }

    public void dispose() {
        this.viewer = null;
        this.groups.clear();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceListener);
    }

    public void inputChanged(Viewer viewer2, Object oldInput, Object newInput) {
        if (viewer2 instanceof CommonViewer) {
            this.viewer = (CommonViewer)viewer2;
        }
    }

    void scheduleRefreshJob(int delay) {
        this.refreshJob.cancel();
        this.refreshJob.schedule(delay);
    }

    private class RefreshJob
    extends Job {
        volatile LinkedList<IResource> resourcesToRefresh;

        public RefreshJob(String name) {
            super(name);
            this.resourcesToRefresh = new LinkedList();
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask("Updating bug markers", this.resourcesToRefresh.size());
            while (!this.resourcesToRefresh.isEmpty() && !monitor.isCanceled() && BugContentProvider.this.viewer != null) {
                final IResource resource = this.resourcesToRefresh.poll();
                monitor.subTask("Update bug markers for " + resource);
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        if (BugContentProvider.this.viewer != null && !BugContentProvider.this.viewer.getControl().isDisposed()) {
                            BugContentProvider.this.groups.clear();
                            if (resource == null) {
                                BugContentProvider.this.viewer.refresh();
                            } else if (BugContentProvider.this.viewer.testFindItem((Object)resource) == null) {
                                BugContentProvider.this.viewer.refresh();
                            } else {
                                BugContentProvider.this.viewer.refresh((Object)resource);
                            }
                        }
                    }
                });
                monitor.worked(1);
            }
            if (BugContentProvider.this.viewer == null) {
                this.resourcesToRefresh.clear();
            }
            monitor.done();
            return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
        }

        boolean addToQueue(IResource res) {
            if (!this.resourcesToRefresh.contains(res)) {
                this.resourcesToRefresh.add(res);
                return true;
            }
            return false;
        }
    }

    private static final class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        IResource project;

        public boolean visit(IResourceDelta delta) {
            if (delta == null) {
                return false;
            }
            IResource resource = delta.getResource();
            int kind = delta.getKind();
            int flags = delta.getFlags();
            if (kind == 8 || kind == 16) {
                return false;
            }
            switch (resource.getType()) {
                case 8: {
                    return true;
                }
                case 1: 
                case 2: {
                    this.project = resource.getProject();
                    return false;
                }
                case 4: {
                    boolean refreshRoot;
                    boolean open = (flags & 0x4000) != 0;
                    boolean bl = refreshRoot = kind == 1 || kind == 2 || kind == 2048 || open;
                    if (refreshRoot) {
                        this.project = null;
                    } else {
                        this.project = resource.getProject();
                        try {
                            IMarker[] markerArr = resource.findMarkers("edu.umd.cs.findbugs.plugin.eclipse.findbugsMarker", true, 2);
                            if (markerArr.length == 0) {
                                this.project = null;
                                return false;
                            }
                        }
                        catch (CoreException e) {
                            FindbugsPlugin.getDefault().logException(e, "Core exception on decorateText() for: " + resource);
                        }
                    }
                    return !refreshRoot;
                }
            }
            return false;
        }
    }

    private final class MyResourceChangeListener
    implements IResourceChangeListener {
        private MyResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResource resource;
            boolean postBuild;
            IResourceDelta delta = event.getDelta();
            boolean bl = postBuild = event.getType() == 16;
            if (delta == null) {
                resource = null;
            } else {
                ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
                try {
                    delta.accept((IResourceDeltaVisitor)visitor);
                }
                catch (CoreException e) {
                    FindbugsPlugin.getDefault().logException(e, "Error visiting changed resources: " + delta);
                }
                resource = visitor.project;
            }
            boolean accepted = BugContentProvider.this.refreshJob.addToQueue(resource);
            if (!accepted) {
                return;
            }
            if (postBuild) {
                BugContentProvider.this.scheduleRefreshJob(100);
            } else {
                BugContentProvider.this.scheduleRefreshJob(1000);
            }
        }
    }
}

