/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.view.explorer;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.marker.FindBugsMarker;
import de.tobject.findbugs.view.explorer.BugPatternGroup;
import java.text.Collator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class BugPrioritySorter
extends ViewerSorter {
    public BugPrioritySorter() {
    }

    public BugPrioritySorter(Collator collator) {
        super(collator);
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int cat2;
        int cat1 = this.category(e1);
        if (cat1 != (cat2 = this.category(e2))) {
            return cat1 - cat2;
        }
        if (e1 instanceof IMarker) {
            IMarker marker1 = (IMarker)e1;
            IMarker marker2 = (IMarker)e2;
            return this.compare(marker1, marker2, true);
        }
        if (e1 instanceof BugPatternGroup) {
            IMarker marker2;
            BugPatternGroup group1 = (BugPatternGroup)e1;
            BugPatternGroup group2 = (BugPatternGroup)e2;
            IMarker marker1 = group1.getFirstElement();
            int result = this.compare(marker1, marker2 = group2.getFirstElement(), false);
            if (result == 0) {
                return group1.getShortPatternDescription().compareTo(group2.getShortPatternDescription());
            }
            return result;
        }
        return super.compare(viewer, e1, e2);
    }

    private int compare(IMarker marker1, IMarker marker2, boolean compareNames) {
        try {
            int ordinal1 = FindBugsMarker.Priority.ordinal(marker1.getType());
            int ordinal2 = FindBugsMarker.Priority.ordinal(marker2.getType());
            int result = ordinal1 - ordinal2;
            if (compareNames && result == 0) {
                String a1 = marker1.getAttribute("message", "");
                String a2 = marker1.getAttribute("message", "");
                return a1.compareTo(a2);
            }
            return result;
        }
        catch (CoreException e) {
            FindbugsPlugin.getDefault().logException(e, "Sort error");
            return 0;
        }
    }

    public int category(Object element) {
        if (element instanceof IMarker) {
            return 1;
        }
        if (element instanceof IResource) {
            return 10;
        }
        if (element instanceof BugPatternGroup) {
            return 5;
        }
        return super.category(element);
    }
}

