/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.Analyze;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import java.util.Set;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.JavaClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeepSubtypeAnalysis {
    private static JavaClass serializable;
    private static JavaClass collection;
    private static JavaClass comparator;
    private static JavaClass map;
    private static JavaClass remote;
    private static ClassNotFoundException storedException;
    private static final boolean DEBUG;

    private static boolean containsConcreteClasses(Set<JavaClass> s) {
        for (JavaClass c : s) {
            if (c.isInterface() || c.isAbstract()) continue;
            return true;
        }
        return false;
    }

    public static double isDeepSerializable(String refSig) throws ClassNotFoundException {
        if (storedException != null) {
            throw storedException;
        }
        if (DeepSubtypeAnalysis.isPrimitiveComponentClass(refSig)) {
            if (DEBUG) {
                System.out.println("regSig \"" + refSig + "\" is primitive component class");
            }
            return 1.0;
        }
        String refName = DeepSubtypeAnalysis.getComponentClass(refSig);
        if (refName.equals("java.lang.Object")) {
            return 0.99;
        }
        JavaClass refJavaClass = Repository.lookupClass(refName);
        return DeepSubtypeAnalysis.isDeepSerializable(refJavaClass);
    }

    public static double isDeepRemote(String refSig) {
        if (remote == null) {
            return 0.1;
        }
        String refName = DeepSubtypeAnalysis.getComponentClass(refSig);
        if (refName.equals("java.lang.Object")) {
            return 0.99;
        }
        try {
            JavaClass refJavaClass = Repository.lookupClass(refName);
            return Analyze.deepInstanceOf(refJavaClass, remote);
        }
        catch (ClassNotFoundException e) {
            return 0.99;
        }
    }

    private static boolean isPrimitiveComponentClass(String refSig) {
        int c;
        for (c = 0; c < refSig.length() && refSig.charAt(c) == '['; ++c) {
        }
        return c >= refSig.length() || refSig.charAt(c) != 'L';
    }

    public static String getComponentClass(String refSig) {
        while (refSig.charAt(0) == '[') {
            refSig = refSig.substring(1);
        }
        if (refSig.charAt(0) == 'L') {
            return refSig.substring(1, refSig.length() - 1).replace('/', '.');
        }
        return refSig;
    }

    public static double isDeepSerializable(JavaClass x) throws ClassNotFoundException {
        if (storedException != null) {
            throw storedException;
        }
        if (x.getClassName().equals("java.lang.Object")) {
            return 0.4;
        }
        double result = Analyze.deepInstanceOf(x, serializable);
        if (result >= 0.9) {
            if (DEBUG) {
                System.out.println("High serializable result: " + result);
            }
            return result;
        }
        if ((result = Math.max(result, Analyze.deepInstanceOf(x, collection))) >= 0.9) {
            if (DEBUG) {
                System.out.println("High collection result: " + result);
            }
            return result;
        }
        if ((result = Math.max(result, Analyze.deepInstanceOf(x, map))) >= 0.9) {
            if (DEBUG) {
                System.out.println("High map result: " + result);
            }
            return result;
        }
        if ((result = Math.max(result, 0.5 * Analyze.deepInstanceOf(x, comparator))) >= 0.9) {
            if (DEBUG) {
                System.out.println("High comparator result: " + result);
            }
            return result;
        }
        if (DEBUG) {
            System.out.println("No high results; max: " + result);
        }
        return result;
    }

    public static double deepInstanceOf(@DottedClassName String x, @DottedClassName String y) throws ClassNotFoundException {
        return Analyze.deepInstanceOf(x, y);
    }

    public static double deepInstanceOf(JavaClass x, JavaClass y) throws ClassNotFoundException {
        return Analyze.deepInstanceOf(x, y);
    }

    static {
        block4: {
            DEBUG = SystemProperties.getBoolean("dsa.debug");
            try {
                serializable = AnalysisContext.lookupSystemClass("java.io.Serializable");
                collection = AnalysisContext.lookupSystemClass("java.util.Collection");
                map = AnalysisContext.lookupSystemClass("java.util.Map");
                comparator = AnalysisContext.lookupSystemClass("java.util.Comparator");
            }
            catch (ClassNotFoundException e) {
                storedException = e;
            }
            try {
                remote = AnalysisContext.lookupSystemClass("java.rmi.Remote");
            }
            catch (ClassNotFoundException e) {
                if (storedException != null) break block4;
                storedException = e;
            }
        }
    }
}

