/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugCode;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.PluginException;
import edu.umd.cs.findbugs.PluginLoader;
import edu.umd.cs.findbugs.SystemProperties;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetectorFactoryCollection {
    private HashMap<String, Plugin> pluginByIdMap = new HashMap();
    private ArrayList<DetectorFactory> factoryList = new ArrayList();
    private HashMap<String, DetectorFactory> factoriesByName = new HashMap();
    private HashMap<String, DetectorFactory> factoriesByDetectorClassName = new HashMap();
    private static DetectorFactoryCollection theInstance;
    private static final Object lock;
    private boolean loaded = false;
    private URL[] pluginList;

    DetectorFactoryCollection() {
    }

    public void setPluginList(URL[] pluginList) {
        if (this.loaded) {
            throw new IllegalStateException();
        }
        this.pluginList = new URL[pluginList.length];
        System.arraycopy(pluginList, 0, this.pluginList, 0, pluginList.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setInstance(DetectorFactoryCollection instance) {
        Object object = lock;
        synchronized (object) {
            if (theInstance != null) {
                throw new IllegalStateException();
            }
            theInstance = instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void resetInstance(DetectorFactoryCollection instance) {
        Object object = lock;
        synchronized (object) {
            theInstance = instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DetectorFactoryCollection instance() {
        Object object = lock;
        synchronized (object) {
            if (theInstance == null) {
                theInstance = new DetectorFactoryCollection();
            }
            theInstance.ensureLoaded();
            return theInstance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DetectorFactoryCollection rawInstance() {
        Object object = lock;
        synchronized (object) {
            if (theInstance == null) {
                theInstance = new DetectorFactoryCollection();
            }
            return theInstance;
        }
    }

    public Iterator<Plugin> pluginIterator() {
        this.ensureLoaded();
        return this.pluginByIdMap.values().iterator();
    }

    public Plugin getPluginById(String pluginId) {
        this.ensureLoaded();
        return this.pluginByIdMap.get(pluginId);
    }

    public Iterator<DetectorFactory> factoryIterator() {
        this.ensureLoaded();
        return this.factoryList.iterator();
    }

    public DetectorFactory getFactory(String name) {
        this.ensureLoaded();
        return this.factoriesByName.get(name);
    }

    public DetectorFactory getFactoryByClassName(String className) {
        this.ensureLoaded();
        return this.factoriesByDetectorClassName.get(className);
    }

    void registerDetector(DetectorFactory factory) {
        if (FindBugs.DEBUG) {
            System.out.println("Registering detector: " + factory.getFullName());
        }
        String detectorName = factory.getShortName();
        this.factoryList.add(factory);
        this.factoriesByName.put(detectorName, factory);
        this.factoriesByDetectorClassName.put(factory.getFullName(), factory);
    }

    private void determinePlugins() {
        if (this.pluginList != null) {
            return;
        }
        String homeDir = FindBugs.getHome();
        if (homeDir == null) {
            System.err.println("Error: FindBugs home directory is not set");
            return;
        }
        File pluginDir = new File(homeDir + File.separator + "plugin");
        File[] contentList = pluginDir.listFiles();
        if (contentList == null) {
            System.err.println("Error: The path " + pluginDir.getPath() + " does not seem to be a directory!");
            System.err.println("No FindBugs plugins could be loaded");
            this.pluginList = new URL[0];
            return;
        }
        ArrayList<URL> arr = new ArrayList<URL>();
        for (File aContentList : contentList) {
            if (!aContentList.getName().endsWith(".jar")) continue;
            try {
                arr.add(aContentList.toURL());
                if (!FindBugs.DEBUG) continue;
                System.out.println("Found plugin: " + aContentList.toString());
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        this.pluginList = arr.toArray(new URL[arr.size()]);
    }

    public void ensureLoaded() {
        if (this.loaded) {
            return;
        }
        this.loadPlugins();
    }

    void setPlugins(Plugin[] plugins) {
        if (this.loaded) {
            throw new IllegalStateException();
        }
        for (Plugin plugin : plugins) {
            this.pluginByIdMap.put(plugin.getPluginId(), plugin);
        }
        this.loaded = true;
    }

    void loadPlugins() {
        if (this.loaded) {
            throw new IllegalStateException();
        }
        if (SystemProperties.getBoolean("findbugs.jaws")) {
            URL u = DetectorFactoryCollection.class.getResource("/findbugs.xml");
            URL[] plugins = new URL[1];
            if (u != null) {
                String path = u.toString();
                path = path.substring(0, path.length() - "findbugs.xml".length());
                if (FindBugs.DEBUG) {
                    System.out.println("Jaws uses plugin: " + path);
                }
                try {
                    plugins[0] = new URL(path);
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException(e);
                }
                this.setPluginList(plugins);
            }
        }
        this.loaded = true;
        this.determinePlugins();
        int numLoaded = 0;
        for (final URL url : this.pluginList) {
            try {
                if (FindBugs.DEBUG) {
                    System.out.println("Loading plugin: " + url.toString());
                }
                PluginLoader pluginLoader = AccessController.doPrivileged(new PrivilegedExceptionAction<PluginLoader>(){

                    @Override
                    public PluginLoader run() throws PluginException {
                        return new PluginLoader(url, this.getClass().getClassLoader());
                    }
                });
                Plugin plugin = pluginLoader.getPlugin();
                this.pluginByIdMap.put(plugin.getPluginId(), plugin);
                Iterator<DetectorFactory> j = plugin.detectorFactoryIterator();
                while (j.hasNext()) {
                    DetectorFactory factory = j.next();
                    this.registerDetector(factory);
                }
                I18N i18n = I18N.instance();
                Iterator<Object> j2 = plugin.bugPatternIterator();
                while (j2.hasNext()) {
                    BugPattern bugPattern = j2.next();
                    i18n.registerBugPattern(bugPattern);
                }
                j2 = plugin.bugCodeIterator();
                while (j2.hasNext()) {
                    BugCode bugCode = (BugCode)j2.next();
                    i18n.registerBugCode(bugCode);
                }
                ++numLoaded;
            }
            catch (PluginException e) {
                System.err.println("Warning: could not load plugin " + url + ": " + e.toString());
                if (!FindBugs.DEBUG) continue;
                e.printStackTrace();
            }
            catch (PrivilegedActionException e) {
                System.err.println("Warning: could not load plugin " + url + ": " + e.toString());
                if (!FindBugs.DEBUG) continue;
                e.printStackTrace();
            }
        }
    }

    static {
        lock = new Object();
    }
}

