/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.TigerSubstitutes;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.AnalysisException;
import edu.umd.cs.findbugs.ba.AssertionMethods;
import edu.umd.cs.findbugs.ba.BlockTypeDataflow;
import edu.umd.cs.findbugs.ba.BytecodeScanner;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.CompactLocationNumbering;
import edu.umd.cs.findbugs.ba.Dataflow;
import edu.umd.cs.findbugs.ba.DataflowAnalysis;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.DominatorsAnalysis;
import edu.umd.cs.findbugs.ba.LiveLocalStoreDataflow;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.LockChecker;
import edu.umd.cs.findbugs.ba.LockDataflow;
import edu.umd.cs.findbugs.ba.MethodBytecodeSet;
import edu.umd.cs.findbugs.ba.PostDominatorsAnalysis;
import edu.umd.cs.findbugs.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.ba.ReturnPathDataflow;
import edu.umd.cs.findbugs.ba.ReverseDepthFirstSearch;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.ca.CallListDataflow;
import edu.umd.cs.findbugs.ba.constant.ConstantDataflow;
import edu.umd.cs.findbugs.ba.deref.UnconditionalValueDerefDataflow;
import edu.umd.cs.findbugs.ba.heap.LoadDataflow;
import edu.umd.cs.findbugs.ba.heap.StoreDataflow;
import edu.umd.cs.findbugs.ba.npe.IsNullValueDataflow;
import edu.umd.cs.findbugs.ba.npe.ReturnPathTypeDataflow;
import edu.umd.cs.findbugs.ba.npe.UsagesRequiringNonNullValues;
import edu.umd.cs.findbugs.ba.npe2.DefinitelyNullSetDataflow;
import edu.umd.cs.findbugs.ba.type.ExceptionSetFactory;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.vna.LoadedFieldSet;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.bcel.BCELUtil;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.ResourceNotFoundException;
import edu.umd.cs.findbugs.classfile.analysis.ClassInfo;
import edu.umd.cs.findbugs.classfile.engine.SelfMethodCalls;
import edu.umd.cs.findbugs.classfile.engine.bcel.NonExceptionPostdominatorsAnalysis;
import edu.umd.cs.findbugs.classfile.engine.bcel.NonImplicitExceptionPostDominatorsAnalysis;
import edu.umd.cs.findbugs.classfile.engine.bcel.UnpackedBytecodeCallback;
import edu.umd.cs.findbugs.classfile.engine.bcel.UnpackedCode;
import edu.umd.cs.findbugs.util.MapCache;
import edu.umd.cs.findbugs.util.MultiMap;
import edu.umd.cs.findbugs.util.TopologicalSort;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumber;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.MethodGen;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassContext {
    public static final boolean DEBUG = SystemProperties.getBoolean("classContext.debug");
    public static final boolean TIME_ANALYSES = SystemProperties.getBoolean("classContext.timeAnalyses");
    public static final boolean DUMP_DATAFLOW_ANALYSIS = SystemProperties.getBoolean("dataflow.dump");
    public static int depth;
    private final JavaClass jclass;
    private final ClassInfo classInfo;
    private final AnalysisContext analysisContext;
    private final Map<Class<?>, Map<MethodDescriptor, Object>> methodAnalysisObjectMap;
    @CheckForNull
    List<Method> methodsInCallOrder = null;
    static MapCache<XMethod, BitSet> cachedBitsets;
    static MapCache<XMethod, Set<Integer>> cachedLoopExits;

    public static void indent() {
        for (int i = 0; i < depth; ++i) {
            System.out.print("  ");
        }
    }

    public ClassContext(JavaClass jclass, AnalysisContext analysisContext) {
        this.jclass = jclass;
        this.analysisContext = analysisContext;
        this.methodAnalysisObjectMap = new HashMap();
        try {
            this.classInfo = (ClassInfo)Global.getAnalysisCache().getClassAnalysis(XClass.class, DescriptorFactory.createClassDescriptor(jclass));
        }
        catch (CheckedAnalysisException e) {
            throw new AssertionError((Object)("No ClassInfo for " + jclass));
        }
    }

    public Map<MethodDescriptor, Object> getObjectMap(Class<?> analysisClass) {
        Map<MethodDescriptor, Object> objectMap = this.methodAnalysisObjectMap.get(analysisClass);
        if (objectMap == null) {
            objectMap = new HashMap<MethodDescriptor, Object>();
            this.methodAnalysisObjectMap.put(analysisClass, objectMap);
        }
        return objectMap;
    }

    public void putMethodAnalysis(Class<?> analysisClass, MethodDescriptor methodDescriptor, Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        Map<MethodDescriptor, Object> objectMap = this.getObjectMap(analysisClass);
        objectMap.put(methodDescriptor, object);
    }

    public Object getMethodAnalysis(Class<?> analysisClass, MethodDescriptor methodDescriptor) throws CheckedAnalysisException {
        Map<MethodDescriptor, Object> objectMap = this.getObjectMap(analysisClass);
        return objectMap.get(methodDescriptor);
    }

    public void purgeAllMethodAnalyses() {
        this.methodAnalysisObjectMap.clear();
    }

    public void purgeMethodAnalyses(MethodDescriptor methodDescriptor) {
        Set<Map.Entry<Class<?>, Map<MethodDescriptor, Object>>> entrySet = this.methodAnalysisObjectMap.entrySet();
        for (Map.Entry<Class<?>, Map<MethodDescriptor, Object>> entry : entrySet) {
            Class<?> cls = entry.getKey();
            if (!DataflowAnalysis.class.isAssignableFrom(cls) && !Dataflow.class.isAssignableFrom(cls)) continue;
            entry.getValue().remove(methodDescriptor);
        }
    }

    public JavaClass getJavaClass() {
        return this.jclass;
    }

    public XClass getXClass() {
        return this.classInfo;
    }

    public ClassDescriptor getClassDescriptor() {
        return this.classInfo;
    }

    public Method getMethod(MethodGen methodGen) {
        Method[] methodList;
        for (Method method : methodList = this.jclass.getMethods()) {
            if (!method.getName().equals(methodGen.getName()) || !method.getSignature().equals(methodGen.getSignature()) || method.getAccessFlags() != methodGen.getAccessFlags()) continue;
            return method;
        }
        return null;
    }

    @NonNull
    public List<Method> getMethodsInCallOrder() {
        if (this.methodsInCallOrder != null) {
            return this.methodsInCallOrder;
        }
        List<Method> methodList = Arrays.asList(this.getJavaClass().getMethods());
        HashMap<String, Method> map = new HashMap<String, Method>();
        for (Method m : methodList) {
            map.put(m.getName() + m.getSignature() + m.isStatic(), m);
        }
        final MultiMap multiMap = SelfMethodCalls.getSelfCalls(this.getClassDescriptor(), map);
        TopologicalSort.OutEdges<Method> edges1 = new TopologicalSort.OutEdges<Method>(){

            @Override
            public Collection<Method> getOutEdges(Method method) {
                return multiMap.get(method);
            }
        };
        this.methodsInCallOrder = TopologicalSort.sortByCallGraph(methodList, edges1);
        assert (methodList.size() == this.methodsInCallOrder.size());
        return this.methodsInCallOrder;
    }

    public AnalysisContext getAnalysisContext() {
        return this.analysisContext;
    }

    public RepositoryLookupFailureCallback getLookupFailureCallback() {
        return this.analysisContext.getLookupFailureCallback();
    }

    @CheckForNull
    public MethodGen getMethodGen(Method method) {
        return this.getMethodAnalysisNoException(MethodGen.class, method);
    }

    public CFG getCFG(Method method) throws CFGBuilderException {
        return this.getMethodAnalysisNoDataflowAnalysisException(CFG.class, method);
    }

    @NonNull
    public ConstantPoolGen getConstantPoolGen() {
        return this.getClassAnalysisNoException(ConstantPoolGen.class);
    }

    public UsagesRequiringNonNullValues getUsagesRequiringNonNullValues(Method method) throws DataflowAnalysisException, CFGBuilderException {
        return this.getMethodAnalysis(UsagesRequiringNonNullValues.class, method);
    }

    public ValueNumberDataflow getValueNumberDataflow(Method method) throws DataflowAnalysisException, CFGBuilderException {
        return this.getMethodAnalysis(ValueNumberDataflow.class, method);
    }

    public IsNullValueDataflow getIsNullValueDataflow(Method method) throws DataflowAnalysisException, CFGBuilderException {
        return this.getMethodAnalysis(IsNullValueDataflow.class, method);
    }

    public TypeDataflow getTypeDataflow(Method method) throws DataflowAnalysisException, CFGBuilderException {
        return this.getMethodAnalysis(TypeDataflow.class, method);
    }

    public DepthFirstSearch getDepthFirstSearch(Method method) throws CFGBuilderException {
        return this.getMethodAnalysisNoDataflowAnalysisException(DepthFirstSearch.class, method);
    }

    public ReverseDepthFirstSearch getReverseDepthFirstSearch(Method method) throws CFGBuilderException {
        return this.getMethodAnalysisNoDataflowAnalysisException(ReverseDepthFirstSearch.class, method);
    }

    @CheckForNull
    public BitSet getBytecodeSet(Method method) {
        return ClassContext.getBytecodeSet(this.jclass, method);
    }

    @CheckForNull
    public static BitSet getBytecodeSet(JavaClass clazz, Method method) {
        XMethod xmethod = XFactory.createXMethod(clazz, method);
        if (cachedBitsets.containsKey(xmethod)) {
            return (BitSet)cachedBitsets.get(xmethod);
        }
        Code code = method.getCode();
        if (code == null) {
            return null;
        }
        byte[] instructionList = code.getCode();
        UnpackedBytecodeCallback callback = new UnpackedBytecodeCallback(instructionList.length);
        BytecodeScanner scanner = new BytecodeScanner();
        scanner.scan(instructionList, callback);
        UnpackedCode unpackedCode = callback.getUnpackedCode();
        MethodBytecodeSet result = null;
        if (unpackedCode != null) {
            result = unpackedCode.getBytecodeSet();
        }
        cachedBitsets.put(xmethod, result);
        return result;
    }

    @CheckForNull
    public static Set<Integer> getLoopExitBranches(Method method, MethodGen methodGen) {
        XMethod xmethod = XFactory.createXMethod(methodGen);
        if (cachedLoopExits.containsKey(xmethod)) {
            return (Set)cachedLoopExits.get(xmethod);
        }
        Code code = method.getCode();
        if (code == null) {
            return null;
        }
        byte[] instructionList = code.getCode();
        HashSet<Integer> result = new HashSet<Integer>();
        for (int i = 0; i < instructionList.length; ++i) {
            if (!ClassContext.checkForBranchExit(instructionList, i)) continue;
            result.add(i);
        }
        if (result.size() == 0) {
            result = TigerSubstitutes.emptySet();
        }
        cachedLoopExits.put(xmethod, result);
        return result;
    }

    static short getBranchOffset(byte[] codeBytes, int pos) {
        int branchByte1 = 0xFF & codeBytes[pos];
        int branchByte2 = 0xFF & codeBytes[pos + 1];
        short branchOffset = (short)(branchByte1 << 8 | branchByte2);
        return branchOffset;
    }

    static boolean checkForBranchExit(byte[] codeBytes, int pos) {
        if (pos < 0 || pos + 2 >= codeBytes.length) {
            return false;
        }
        switch (0xFF & codeBytes[pos]) {
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                break;
            }
            default: {
                return false;
            }
        }
        int branchTarget = pos + ClassContext.getBranchOffset(codeBytes, pos + 1);
        if (branchTarget - 3 < pos || branchTarget >= codeBytes.length) {
            return false;
        }
        if ((codeBytes[branchTarget - 3] & 0xFF) != 167) {
            return false;
        }
        int backBranchTarget = branchTarget + ClassContext.getBranchOffset(codeBytes, branchTarget - 2);
        return backBranchTarget <= pos && backBranchTarget + 12 >= pos;
    }

    public short[] getOffsetToOpcodeMap(Method method) {
        UnpackedCode unpackedCode = this.getMethodAnalysisNoException(UnpackedCode.class, method);
        return unpackedCode != null ? unpackedCode.getOffsetToBytecodeMap() : null;
    }

    public LockDataflow getLockDataflow(Method method) throws CFGBuilderException, DataflowAnalysisException {
        return this.getMethodAnalysis(LockDataflow.class, method);
    }

    public LockChecker getLockChecker(Method method) throws CFGBuilderException, DataflowAnalysisException {
        return this.getMethodAnalysis(LockChecker.class, method);
    }

    public ReturnPathDataflow getReturnPathDataflow(Method method) throws CFGBuilderException, DataflowAnalysisException {
        return this.getMethodAnalysis(ReturnPathDataflow.class, method);
    }

    public DominatorsAnalysis getNonExceptionDominatorsAnalysis(Method method) throws CFGBuilderException, DataflowAnalysisException {
        return this.getMethodAnalysis(DominatorsAnalysis.class, method);
    }

    public PostDominatorsAnalysis getNonImplicitExceptionDominatorsAnalysis(Method method) throws CFGBuilderException, DataflowAnalysisException {
        return this.getMethodAnalysis(NonImplicitExceptionPostDominatorsAnalysis.class, method);
    }

    public PostDominatorsAnalysis getNonExceptionPostDominatorsAnalysis(Method method) throws CFGBuilderException, DataflowAnalysisException {
        return this.getMethodAnalysis(NonExceptionPostdominatorsAnalysis.class, method);
    }

    public ExceptionSetFactory getExceptionSetFactory(Method method) {
        return this.getMethodAnalysisNoException(ExceptionSetFactory.class, method);
    }

    public String[] getParameterSignatureList(Method method) {
        return (String[])this.getMethodAnalysisNoException(new String[0].getClass(), method);
    }

    public LoadedFieldSet getLoadedFieldSet(Method method) {
        return this.getMethodAnalysisNoException(LoadedFieldSet.class, method);
    }

    public LiveLocalStoreDataflow getLiveLocalStoreDataflow(Method method) throws DataflowAnalysisException, CFGBuilderException {
        return this.getMethodAnalysis(LiveLocalStoreDataflow.class, method);
    }

    public BlockTypeDataflow getBlockTypeDataflow(Method method) throws DataflowAnalysisException, CFGBuilderException {
        return this.getMethodAnalysis(BlockTypeDataflow.class, method);
    }

    public AssertionMethods getAssertionMethods() {
        return this.getClassAnalysisNoException(AssertionMethods.class);
    }

    public ConstantDataflow getConstantDataflow(Method method) throws CFGBuilderException, DataflowAnalysisException {
        return this.getMethodAnalysis(ConstantDataflow.class, method);
    }

    public LoadDataflow getLoadDataflow(Method method) throws CFGBuilderException, DataflowAnalysisException {
        return this.getMethodAnalysis(LoadDataflow.class, method);
    }

    public StoreDataflow getStoreDataflow(Method method) throws CFGBuilderException, DataflowAnalysisException {
        return this.getMethodAnalysis(StoreDataflow.class, method);
    }

    public CallListDataflow getCallListDataflow(Method method) throws CFGBuilderException, DataflowAnalysisException {
        return this.getMethodAnalysis(CallListDataflow.class, method);
    }

    public static BitSet linesMentionedMultipleTimes(Method method) {
        BitSet lineMentionedMultipleTimes = new BitSet();
        Code code = method.getCode();
        if (code == null || code.getExceptionTable() == null) {
            return lineMentionedMultipleTimes;
        }
        BitSet foundOnce = new BitSet();
        LineNumberTable lineNumberTable = method.getLineNumberTable();
        int lineNum = -1;
        if (lineNumberTable != null) {
            for (LineNumber line : lineNumberTable.getLineNumberTable()) {
                int newLine = line.getLineNumber();
                if (newLine == lineNum || newLine == -1) continue;
                lineNum = newLine;
                if (foundOnce.get(lineNum)) {
                    lineMentionedMultipleTimes.set(lineNum);
                    continue;
                }
                foundOnce.set(lineNum);
            }
        }
        return lineMentionedMultipleTimes;
    }

    public UnconditionalValueDerefDataflow getUnconditionalValueDerefDataflow(Method method) throws CFGBuilderException, DataflowAnalysisException {
        return this.getMethodAnalysis(UnconditionalValueDerefDataflow.class, method);
    }

    public CompactLocationNumbering getCompactLocationNumbering(Method method) throws CFGBuilderException {
        return this.getMethodAnalysisNoDataflowAnalysisException(CompactLocationNumbering.class, method);
    }

    public DefinitelyNullSetDataflow getDefinitelyNullSetDataflow(Method method) throws CFGBuilderException, DataflowAnalysisException {
        return this.getMethodAnalysis(DefinitelyNullSetDataflow.class, method);
    }

    public ReturnPathTypeDataflow getReturnPathTypeDataflow(Method method) throws CFGBuilderException, DataflowAnalysisException {
        return this.getMethodAnalysis(ReturnPathTypeDataflow.class, method);
    }

    public void dumpSimpleDataflowInformation(Method method) {
        try {
            ClassContext.dumpDataflowInformation(method, this.getCFG(method), this.getValueNumberDataflow(method), this.getIsNullValueDataflow(method), null, null);
        }
        catch (DataflowAnalysisException e) {
            AnalysisContext.logError("Could not dump data information for " + this.getJavaClass().getClassName() + "." + method.getName(), e);
        }
        catch (CFGBuilderException e) {
            AnalysisContext.logError("Could not dump data information for " + this.getJavaClass().getClassName() + "." + method.getName(), e);
        }
    }

    public void dumpDataflowInformation(Method method) {
        try {
            ClassContext.dumpDataflowInformation(method, this.getCFG(method), this.getValueNumberDataflow(method), this.getIsNullValueDataflow(method), this.getUnconditionalValueDerefDataflow(method), this.getTypeDataflow(method));
        }
        catch (DataflowAnalysisException e) {
            AnalysisContext.logError("Could not dump data information for " + this.getJavaClass().getClassName() + "." + method.getName(), e);
        }
        catch (CFGBuilderException e) {
            AnalysisContext.logError("Could not dump data information for " + this.getJavaClass().getClassName() + "." + method.getName(), e);
        }
    }

    public static void dumpDataflowInformation(Method method, CFG cfg, ValueNumberDataflow vnd, IsNullValueDataflow inv, @CheckForNull UnconditionalValueDerefDataflow dataflow, @CheckForNull TypeDataflow typeDataflow) throws DataflowAnalysisException {
        System.out.println("\n\n{ UnconditionalValueDerefAnalysis analysis for " + method.getName());
        TreeSet<Location> tree = new TreeSet<Location>();
        Iterator<Location> locs = cfg.locationIterator();
        while (locs.hasNext()) {
            Location loc = locs.next();
            tree.add(loc);
        }
        for (Location loc : tree) {
            System.out.println();
            if (dataflow != null) {
                System.out.println("\n Pre: " + dataflow.getFactAfterLocation(loc));
            }
            System.out.println("Vna: " + vnd.getFactAtLocation(loc));
            System.out.println("inv: " + inv.getFactAtLocation(loc));
            if (typeDataflow != null) {
                System.out.println("type: " + typeDataflow.getFactAtLocation(loc));
            }
            System.out.println("Location: " + loc);
            if (dataflow != null) {
                System.out.println("Post: " + dataflow.getFactAtLocation(loc));
            }
            System.out.println("Vna: " + vnd.getFactAfterLocation(loc));
            System.out.println("inv: " + inv.getFactAfterLocation(loc));
            if (typeDataflow == null) continue;
            System.out.println("type: " + typeDataflow.getFactAfterLocation(loc));
        }
        System.out.println("}\n\n");
    }

    public static void dumpTypeDataflow(Method method, CFG cfg, TypeDataflow typeDataflow) throws DataflowAnalysisException {
        System.out.println("\n\n{ Type analysis for " + cfg.getMethodGen().getClassName() + "." + method.getName());
        TreeSet<Location> tree = new TreeSet<Location>();
        Iterator<Location> locs = cfg.locationIterator();
        while (locs.hasNext()) {
            Location loc = locs.next();
            tree.add(loc);
        }
        for (Location loc : tree) {
            System.out.println("\n Pre: " + typeDataflow.getFactAtLocation(loc));
            System.out.println("Location: " + loc);
            System.out.println("Post: " + typeDataflow.getFactAfterLocation(loc));
        }
        System.out.println("}\n\n");
    }

    private <Analysis> Analysis getMethodAnalysisNoException(Class<Analysis> analysisClass, Method method) {
        try {
            return this.getMethodAnalysis(analysisClass, method);
        }
        catch (CheckedAnalysisException e) {
            IllegalStateException ise = new IllegalStateException("should not happen");
            ise.initCause(e);
            throw ise;
        }
    }

    private <Analysis> Analysis getMethodAnalysisNoDataflowAnalysisException(Class<Analysis> analysisClass, Method method) throws CFGBuilderException {
        try {
            return this.getMethodAnalysis(analysisClass, method);
        }
        catch (CFGBuilderException e) {
            throw e;
        }
        catch (CheckedAnalysisException e) {
            IllegalStateException ise = new IllegalStateException("should not happen");
            ise.initCause(e);
            throw ise;
        }
    }

    private <Analysis> Analysis getMethodAnalysis(Class<Analysis> analysisClass, Method method) throws DataflowAnalysisException, CFGBuilderException {
        try {
            MethodDescriptor methodDescriptor = BCELUtil.getMethodDescriptor(this.jclass, method);
            return Global.getAnalysisCache().getMethodAnalysis(analysisClass, methodDescriptor);
        }
        catch (DataflowAnalysisException e) {
            throw e;
        }
        catch (CFGBuilderException e) {
            throw e;
        }
        catch (CheckedAnalysisException e) {
            Throwable cause = e.getCause();
            if (cause instanceof CFGBuilderException) {
                throw (CFGBuilderException)cause;
            }
            System.out.println("Bad CAE: " + e.getClass().getName() + " for " + analysisClass.getName() + " of " + method);
            e.printStackTrace(System.out);
            IllegalStateException ise = new IllegalStateException("should not happen");
            ise.initCause(e);
            throw ise;
        }
    }

    private <Analysis> Analysis getClassAnalysis(Class<Analysis> analysisClass) throws CheckedAnalysisException {
        ClassDescriptor classDescriptor = BCELUtil.getClassDescriptor(this.jclass);
        return Global.getAnalysisCache().getClassAnalysis(analysisClass, classDescriptor);
    }

    private <Analysis> Analysis getClassAnalysisNoException(Class<Analysis> analysisClass) {
        try {
            return this.getClassAnalysis(analysisClass);
        }
        catch (CheckedAnalysisException e) {
            IllegalStateException ise = new IllegalStateException("should not happen");
            ise.initCause(e);
            throw ise;
        }
    }

    private <Analysis> Analysis getClassAnalysisPossibleClassNotFoundException(Class<Analysis> analysisClass) throws ClassNotFoundException {
        try {
            return Global.getAnalysisCache().getClassAnalysis(analysisClass, BCELUtil.getClassDescriptor(this.jclass));
        }
        catch (ResourceNotFoundException e) {
            throw e.toClassNotFoundException();
        }
        catch (CheckedAnalysisException e) {
            throw new AnalysisException("Unexpected exception", e);
        }
    }

    static {
        cachedBitsets = new MapCache(64);
        cachedLoopExits = new MapCache(13);
    }
}

