/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.jsr305;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.AnalysisException;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.ch.OverriddenMethodsVisitor;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierAnnotation;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierApplications;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierValue;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.annotation.meta.When;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Analysis {
    private static final boolean DEBUG = SystemProperties.getBoolean("ctq.debug.analysis");

    public static Collection<TypeQualifierValue> getRelevantTypeQualifiers(MethodDescriptor methodDescriptor) throws CheckedAnalysisException {
        final IAnalysisCache analysisCache = Global.getAnalysisCache();
        final HashSet<TypeQualifierValue> result = new HashSet<TypeQualifierValue>();
        XMethod xmethod = XFactory.createXMethod(methodDescriptor);
        if (methodDescriptor.isStatic()) {
            Analysis.getDirectlyRelevantTypeQualifiers(xmethod, analysisCache, result);
        } else {
            OverriddenMethodsVisitor visitor = new OverriddenMethodsVisitor(xmethod){

                protected boolean visitOverriddenMethod(XMethod xmethod) {
                    Analysis.getDirectlyRelevantTypeQualifiers(xmethod, analysisCache, result);
                    return true;
                }
            };
            try {
                AnalysisContext.currentAnalysisContext().getSubtypes2().traverseSupertypes(xmethod.getClassDescriptor(), visitor);
            }
            catch (ClassNotFoundException e) {
                AnalysisContext.currentAnalysisContext().getLookupFailureCallback().reportMissingClass(e);
                return Collections.EMPTY_SET;
            }
            catch (AnalysisException e) {
                AnalysisContext.currentAnalysisContext().getLookupFailureCallback().logError("Error getting relevant type qualifiers for " + xmethod.toString(), e);
                return Collections.EMPTY_SET;
            }
        }
        return result;
    }

    private static void getDirectlyRelevantTypeQualifiers(XMethod xmethod, IAnalysisCache analysisCache, HashSet<TypeQualifierValue> result) {
        result.addAll(AnalysisContext.currentAnalysisContext().getDirectlyRelevantTypeQualifiersDatabase().getDirectlyRelevantTypeQualifiers(xmethod.getMethodDescriptor()));
    }

    public static void addKnownTypeQualifiersForParameters(HashSet<TypeQualifierValue> result, XMethod m) {
        int numParameters = new SignatureParser(m.getSignature()).getNumParameters();
        for (int p = 0; p < numParameters; ++p) {
            Analysis.addKnownTypeQualifiers(result, TypeQualifierApplications.getApplicableApplications(m, p));
        }
    }

    public static void addKnownTypeQualifiers(HashSet<TypeQualifierValue> result, Collection<TypeQualifierAnnotation> applicableApplications) {
        for (TypeQualifierAnnotation t : applicableApplications) {
            if (t.when == When.UNKNOWN) continue;
            result.add(t.typeQualifier);
        }
    }
}

