/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.jsr305;

import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.MissingClassException;
import edu.umd.cs.findbugs.classfile.analysis.AnnotationValue;
import edu.umd.cs.findbugs.classfile.analysis.EnumValue;
import java.lang.annotation.ElementType;
import java.util.Collection;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeQualifierResolver {
    static ClassDescriptor typeQualifier = DescriptorFactory.createClassDescriptor("javax/annotation/meta/TypeQualifier");
    static ClassDescriptor typeQualifierNickname = DescriptorFactory.createClassDescriptor("javax/annotation/meta/TypeQualifierNickname");
    static ClassDescriptor typeQualifierDefault = DescriptorFactory.createClassDescriptor("javax/annotation/meta/TypeQualifierDefault");
    static ClassDescriptor elementTypeDescriptor = DescriptorFactory.createClassDescriptor("java/lang/annotation/ElementType");

    public static Collection<AnnotationValue> resolveTypeQualifiers(AnnotationValue value) {
        LinkedList<AnnotationValue> result = new LinkedList<AnnotationValue>();
        TypeQualifierResolver.resolveTypeQualifierNicknames(value, result, new LinkedList<ClassDescriptor>());
        return result;
    }

    public static Collection<AnnotationValue> resolveTypeQualifierDefaults(Collection<AnnotationValue> values, ElementType elementType) {
        LinkedList<AnnotationValue> result = new LinkedList<AnnotationValue>();
        for (AnnotationValue value : values) {
            TypeQualifierResolver.resolveTypeQualifierDefaults(value, elementType, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void resolveTypeQualifierNicknames(AnnotationValue value, LinkedList<AnnotationValue> result, LinkedList<ClassDescriptor> onStack) {
        if (onStack.contains(value.getAnnotationClass())) {
            AnalysisContext.logError("Cycle found in type nicknames: " + onStack);
            return;
        }
        try {
            onStack.add(value.getAnnotationClass());
            try {
                XClass c = Global.getAnalysisCache().getClassAnalysis(XClass.class, value.getAnnotationClass());
                if (c.getAnnotationDescriptors().contains(typeQualifierNickname)) {
                    for (ClassDescriptor d : c.getAnnotationDescriptors()) {
                        if (c.equals(typeQualifierNickname)) continue;
                        TypeQualifierResolver.resolveTypeQualifierNicknames(c.getAnnotation(d), result, onStack);
                    }
                } else if (c.getAnnotationDescriptors().contains(typeQualifier)) {
                    result.add(value);
                }
            }
            catch (MissingClassException e) {
                onStack.removeLast();
                return;
            }
            catch (CheckedAnalysisException e) {
                AnalysisContext.logError("Error resolving " + value.getAnnotationClass(), e);
                onStack.removeLast();
                return;
            }
        }
        finally {
            onStack.removeLast();
        }
    }

    public static Collection<AnnotationValue> resolveTypeQualifiers(Collection<AnnotationValue> values) {
        LinkedList<AnnotationValue> result = new LinkedList<AnnotationValue>();
        LinkedList<ClassDescriptor> onStack = new LinkedList<ClassDescriptor>();
        for (AnnotationValue value : values) {
            TypeQualifierResolver.resolveTypeQualifierNicknames(value, result, onStack);
        }
        return result;
    }

    private static void resolveTypeQualifierDefaults(AnnotationValue value, ElementType defaultFor, LinkedList<AnnotationValue> result) {
        try {
            XClass c = Global.getAnalysisCache().getClassAnalysis(XClass.class, value.getAnnotationClass());
            AnnotationValue defaultAnnotation = c.getAnnotation(typeQualifierDefault);
            if (defaultAnnotation == null) {
                return;
            }
            for (Object o : (Object[])defaultAnnotation.getValue("value")) {
                if (!(o instanceof EnumValue)) continue;
                EnumValue e = (EnumValue)o;
                if (!e.desc.equals(elementTypeDescriptor) || !e.value.equals(defaultFor.name())) continue;
                for (ClassDescriptor d : c.getAnnotationDescriptors()) {
                    if (d.equals(typeQualifierDefault)) continue;
                    TypeQualifierResolver.resolveTypeQualifierNicknames(c.getAnnotation(d), result, new LinkedList<ClassDescriptor>());
                }
                break;
            }
        }
        catch (MissingClassException e) {
        }
        catch (CheckedAnalysisException e) {
            AnalysisContext.logError("Error resolving " + value.getAnnotationClass(), e);
        }
        catch (ClassCastException e) {
            AnalysisContext.logError("ClassCastException " + value.getAnnotationClass(), e);
        }
    }
}

