/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.npe;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.npe.DerefFinder;
import edu.umd.cs.findbugs.ba.npe.PointerUsageRequiringNonNullValue;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.util.MultiMap;
import java.util.Collection;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsagesRequiringNonNullValues {
    MultiMap<Location, Pair> map = new MultiMap(LinkedList.class);

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (Location loc : this.map.keySet()) {
            buf.append(loc.getHandle().getPosition() + ":" + loc.getHandle().getInstruction() + "\n");
            for (Pair pair : this.getPairs(loc)) {
                buf.append("  ").append(pair.vn).append("\n");
            }
        }
        return buf.toString();
    }

    public void add(Location loc, ValueNumber vn, PointerUsageRequiringNonNullValue usage) {
        Pair p = new Pair(vn, usage);
        if (DerefFinder.DEBUG) {
            System.out.println("At " + loc + " adding dereference " + p);
        }
        this.map.add(loc, p);
    }

    @CheckForNull
    public PointerUsageRequiringNonNullValue get(Location loc, ValueNumber vn) {
        PointerUsageRequiringNonNullValue secondBest = null;
        for (Pair p : this.map.get(loc)) {
            if (p.vn.equals(vn)) {
                return p.pu;
            }
            secondBest = p.pu;
        }
        return secondBest;
    }

    public Collection<? extends Pair> getPairs(Location loc) {
        return this.map.get(loc);
    }

    public static class Pair {
        public final ValueNumber vn;
        public final PointerUsageRequiringNonNullValue pu;

        Pair(ValueNumber vn, PointerUsageRequiringNonNullValue pu) {
            this.vn = vn;
            this.pu = pu;
        }

        public String toString() {
            return this.vn.toString();
        }
    }
}

