/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.type;

import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.type.ExceptionSetFactory;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class ExceptionSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ExceptionSetFactory factory;
    private BitSet exceptionSet;
    private BitSet explicitSet;
    private int size;
    private boolean universalHandler;
    private Type commonSupertype;

    ExceptionSet(ExceptionSetFactory factory) {
        this.factory = factory;
        this.exceptionSet = new BitSet();
        this.explicitSet = new BitSet();
        this.size = 0;
        this.universalHandler = false;
    }

    public ExceptionSet duplicate() {
        ExceptionSet dup = this.factory.createExceptionSet();
        dup.exceptionSet.clear();
        dup.exceptionSet.or(this.exceptionSet);
        dup.explicitSet.clear();
        dup.explicitSet.or(this.explicitSet);
        dup.size = this.size;
        dup.universalHandler = this.universalHandler;
        dup.commonSupertype = this.commonSupertype;
        return dup;
    }

    public int hashCode() {
        return this.exceptionSet.hashCode() + this.explicitSet.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        ExceptionSet other = (ExceptionSet)o;
        return this.exceptionSet.equals(other.exceptionSet) && this.explicitSet.equals(other.explicitSet) && this.universalHandler == other.universalHandler;
    }

    public Type getCommonSupertype() throws ClassNotFoundException {
        if (this.commonSupertype != null) {
            return this.commonSupertype;
        }
        if (this.isEmpty()) {
            return TypeFrame.getTopType();
        }
        ThrownExceptionIterator i = this.iterator();
        ReferenceType result = i.next();
        while (i.hasNext()) {
            result = AnalysisContext.currentAnalysisContext().getSubtypes2().getFirstCommonSuperclass(result, (ReferenceType)i.next());
            if (result != null) continue;
            result = Type.THROWABLE;
            break;
        }
        this.commonSupertype = result;
        return result;
    }

    public ThrownExceptionIterator iterator() {
        return new ThrownExceptionIterator();
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean isSingleton(String exceptionName) {
        if (this.size != 1) {
            return false;
        }
        ObjectType e = this.iterator().next();
        return e.toString().equals(exceptionName);
    }

    public void addExplicit(ObjectType type) {
        this.add(type, true);
    }

    public void addImplicit(ObjectType type) {
        this.add(type, false);
    }

    public void add(ObjectType type, boolean explicit) {
        int index = this.factory.getIndexOfType(type);
        if (!this.exceptionSet.get(index)) {
            ++this.size;
        }
        this.exceptionSet.set(index);
        if (explicit) {
            this.explicitSet.set(index);
        }
        this.commonSupertype = null;
    }

    public void addAll(ExceptionSet other) {
        this.exceptionSet.or(other.exceptionSet);
        this.explicitSet.or(other.explicitSet);
        this.size = this.countBits(this.exceptionSet);
        this.commonSupertype = null;
    }

    private int countBits(BitSet bitSet) {
        int count = 0;
        for (int i = 0; i < this.factory.getNumTypes(); ++i) {
            if (!bitSet.get(i)) continue;
            ++count;
        }
        return count;
    }

    public void clear() {
        this.exceptionSet.clear();
        this.explicitSet.clear();
        this.universalHandler = false;
        this.commonSupertype = null;
    }

    public void sawUniversal() {
        this.clear();
        this.universalHandler = true;
    }

    public boolean sawUniversalHandler() {
        return this.universalHandler;
    }

    public boolean containsCheckedExceptions() throws ClassNotFoundException {
        ThrownExceptionIterator i = this.iterator();
        while (i.hasNext()) {
            ObjectType type = i.next();
            if (Hierarchy.isUncheckedException(type)) continue;
            return true;
        }
        return false;
    }

    public boolean containsExplicitExceptions() {
        ThrownExceptionIterator i = this.iterator();
        while (i.hasNext()) {
            i.next();
            if (!i.isExplicit()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append('{');
        boolean first = true;
        ThrownExceptionIterator i = this.iterator();
        while (i.hasNext()) {
            boolean implicit;
            ObjectType type = i.next();
            if (first) {
                first = false;
            } else {
                buf.append(',');
            }
            boolean bl = implicit = !i.isExplicit();
            if (implicit) {
                buf.append('[');
            }
            buf.append(type.toString());
            if (!implicit) continue;
            buf.append(']');
        }
        buf.append('}');
        return buf.toString();
    }

    public int size() {
        return this.size;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ThrownExceptionIterator
    implements Iterator<ObjectType> {
        private int last = -1;
        private int next = -1;

        ThrownExceptionIterator() {
            this.findNext();
        }

        @Override
        public boolean hasNext() {
            if (this.last == this.next) {
                this.findNext();
            }
            return this.next < ExceptionSet.this.factory.getNumTypes();
        }

        @Override
        public ObjectType next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ObjectType result = ExceptionSet.this.factory.getType(this.next);
            this.last = this.next;
            return result;
        }

        public boolean isExplicit() {
            return ExceptionSet.this.explicitSet.get(this.last);
        }

        @Override
        public void remove() {
            ExceptionSet.this.exceptionSet.clear(this.last);
            ExceptionSet.this.explicitSet.clear(this.last);
            --ExceptionSet.this.size;
            ExceptionSet.this.commonSupertype = null;
        }

        private void findNext() {
            ++this.next;
            while (this.next < ExceptionSet.this.factory.getNumTypes() && !ExceptionSet.this.exceptionSet.get(this.next)) {
                ++this.next;
            }
        }
    }
}

