/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.engine.bcel;

import edu.umd.cs.findbugs.ba.BytecodeScanner;
import edu.umd.cs.findbugs.ba.MethodBytecodeSet;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.IAnalysisCache;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;
import edu.umd.cs.findbugs.classfile.engine.bcel.AnalysisFactory;
import edu.umd.cs.findbugs.classfile.engine.bcel.UnpackedBytecodeCallback;
import edu.umd.cs.findbugs.classfile.engine.bcel.UnpackedCode;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodBytecodeSetFactory
extends AnalysisFactory<MethodBytecodeSet> {
    public MethodBytecodeSetFactory(String analysisName, Class<MethodBytecodeSet> analysisClass) {
        super(analysisName, analysisClass);
    }

    @Override
    public MethodBytecodeSet analyze(IAnalysisCache analysisCache, MethodDescriptor descriptor) throws CheckedAnalysisException {
        Method method = analysisCache.getMethodAnalysis(Method.class, descriptor);
        Code code = method.getCode();
        if (code == null) {
            return null;
        }
        byte[] instructionList = code.getCode();
        UnpackedBytecodeCallback callback = new UnpackedBytecodeCallback(instructionList.length);
        BytecodeScanner scanner = new BytecodeScanner();
        scanner.scan(instructionList, callback);
        UnpackedCode unpackedCode = callback.getUnpackedCode();
        MethodBytecodeSet result = null;
        if (unpackedCode != null) {
            result = unpackedCode.getBytecodeSet();
        }
        return result;
    }

    @Override
    public void registerWith(IAnalysisCache analysisCache) {
        analysisCache.registerMethodAnalysisEngine(MethodBytecodeSet.class, this);
    }
}

