/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.classfile.impl;

import edu.umd.cs.findbugs.classfile.ICodeBaseLocator;
import edu.umd.cs.findbugs.classfile.impl.AbstractScannableCodeBase;
import edu.umd.cs.findbugs.classfile.impl.ZipFileCodeBase;
import edu.umd.cs.findbugs.classfile.impl.ZipInputStreamCodeBase;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipCodeBaseFactory {
    public static AbstractScannableCodeBase makeZipCodeBase(ICodeBaseLocator codeBaseLocator, File file) throws IOException {
        ZipEntry e;
        int zipEntries;
        long size = file.length();
        long estimatedEntries = size / 2000L;
        if (estimatedEntries < 20000L) {
            return new ZipFileCodeBase(codeBaseLocator, file);
        }
        ZipInputStream in = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
        for (zipEntries = 0; (e = in.getNextEntry()) != null && zipEntries < 30000; ++zipEntries) {
        }
        in.close();
        if (zipEntries < 30000) {
            return new ZipFileCodeBase(codeBaseLocator, file);
        }
        return new ZipInputStreamCodeBase(codeBaseLocator, file);
    }
}

