/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ml;

import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.xml.Dom4JXMLOutput;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class GenerateUIDs {
    private BugCollection bugCollection = new SortedBugCollection();
    @NonNull
    private Project project = new Project();
    private String inputFilename;
    private String outputFilename;

    public GenerateUIDs(String inputFilename, String outputFilename) {
        this.inputFilename = inputFilename;
        this.outputFilename = outputFilename;
    }

    public void execute() throws IOException, DocumentException {
        InputStream in;
        if (this.inputFilename.equals("-")) {
            in = System.in;
        } else {
            in = new BufferedInputStream(new FileInputStream(this.inputFilename));
            if (this.inputFilename.endsWith(".gz")) {
                in = new GZIPInputStream(in);
            }
        }
        this.bugCollection.readXML(in, this.project);
        Document document = DocumentFactory.getInstance().createDocument();
        Dom4JXMLOutput xmlOutput = new Dom4JXMLOutput(document);
        this.bugCollection.writeXML(xmlOutput, this.project);
        int count = 0;
        List bugInstanceList = document.selectNodes("/BugCollection/BugInstance");
        for (Element element : bugInstanceList) {
            Attribute uidAttr = element.attribute("uid");
            if (uidAttr != null) continue;
            element.addAttribute("uid", Integer.toString(count++));
        }
        FilterOutputStream out = this.outputFilename.equals("-") ? System.out : new BufferedOutputStream(new FileOutputStream(this.outputFilename));
        XMLWriter xmlWriter = new XMLWriter(out, OutputFormat.createPrettyPrint());
        xmlWriter.write(document);
    }

    public static void main(String[] args) throws IOException, DocumentException {
        if (args.length != 2) {
            System.err.println("Usage: " + GenerateUIDs.class.getName() + " <input file> <output file>");
            System.exit(1);
        }
        String inputFilename = args[0];
        String outputFilename = args[1];
        GenerateUIDs generateUIDs = new GenerateUIDs(inputFilename, outputFilename);
        generateUIDs.execute();
    }
}

