/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.AppVersion;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugDesignation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.PackageStats;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.TigerSubstitutes;
import edu.umd.cs.findbugs.VersionInsensitiveBugComparator;
import edu.umd.cs.findbugs.config.CommandLine;
import edu.umd.cs.findbugs.model.MovedClassMap;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeMap;
import org.dom4j.DocumentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Update {
    private static final String USAGE = "Usage: " + Update.class.getName() + " [options]  data1File data2File data3File ... ";
    private HashMap<BugInstance, BugInstance> mapFromNewToOldBug = new HashMap();
    private HashSet<BugInstance> matchedOldBugs = new HashSet();
    boolean noPackageMoves = false;
    boolean preciseMatch = false;
    boolean precisePriorityMatch = false;
    int mostRecent = -1;
    VersionInsensitiveBugComparator versionInsensitiveBugComparator = new VersionInsensitiveBugComparator();
    VersionInsensitiveBugComparator fuzzyBugPatternMatcher = new VersionInsensitiveBugComparator();
    boolean verbose;

    public Update() {
        this.fuzzyBugPatternMatcher.setExactBugPatternMatch(false);
        this.verbose = true;
    }

    HashSet<String> sourceFilesInCollection(BugCollection collection) {
        HashSet<String> result = new HashSet<String>();
        for (PackageStats pStats : collection.getProjectStats().getPackageStats()) {
            for (PackageStats.ClassStats cStats : pStats.getClassStats()) {
                result.add(cStats.getSourceFile());
            }
        }
        return result;
    }

    public void removeBaselineBugs(BugCollection baselineCollection, BugCollection bugCollection) {
        this.matchBugs(baselineCollection, bugCollection);
        this.matchBugs(SortedBugCollection.BugInstanceComparator.instance, baselineCollection, bugCollection);
        this.matchBugs(this.versionInsensitiveBugComparator, baselineCollection, bugCollection);
        Iterator<BugInstance> i = bugCollection.getCollection().iterator();
        while (i.hasNext()) {
            BugInstance bug = i.next();
            if (!this.matchedOldBugs.contains(bug)) continue;
            i.remove();
        }
    }

    public BugCollection mergeCollections(BugCollection origCollection, BugCollection newCollection, boolean copyDeadBugs, boolean incrementalAnalysis) {
        BugInstance newBug;
        this.mapFromNewToOldBug.clear();
        this.matchedOldBugs.clear();
        BugCollection resultCollection = newCollection.createEmptyCollectionWithMetadata();
        long lastSequence = origCollection.getSequenceNumber();
        resultCollection.clearAppVersions();
        Iterator<AppVersion> i = origCollection.appVersionIterator();
        while (i.hasNext()) {
            AppVersion appVersion = i.next();
            resultCollection.addAppVersion((AppVersion)appVersion.clone());
        }
        AppVersion origCollectionVersion = origCollection.getCurrentAppVersion();
        AppVersion origCollectionVersionClone = new AppVersion(lastSequence);
        origCollectionVersionClone.setTimestamp(origCollectionVersion.getTimestamp());
        origCollectionVersionClone.setReleaseName(origCollectionVersion.getReleaseName());
        origCollectionVersionClone.setNumClasses(origCollection.getProjectStats().getNumClasses());
        origCollectionVersionClone.setCodeSize(origCollection.getProjectStats().getCodeSize());
        resultCollection.addAppVersion(origCollectionVersionClone);
        long currentSequence = origCollection.getSequenceNumber() + 1L;
        resultCollection.setSequenceNumber(currentSequence);
        int oldBugs = 0;
        if (copyDeadBugs) {
            for (BugInstance bug : origCollection.getCollection()) {
                if (bug.getLastVersion() == -1L) continue;
                ++oldBugs;
                BugInstance newBug2 = (BugInstance)bug.clone();
                resultCollection.add(newBug2, false);
            }
        }
        this.matchBugs(origCollection, newCollection);
        int newlyDeadBugs = 0;
        int persistantBugs = 0;
        int addedBugs = 0;
        int addedInNewCode = 0;
        int deadBugInDeadCode = 0;
        HashSet<String> analyzedSourceFiles = this.sourceFilesInCollection(newCollection);
        if (copyDeadBugs || incrementalAnalysis) {
            for (BugInstance bug : origCollection.getCollection()) {
                boolean removed;
                if (this.matchedOldBugs.contains(bug) || bug.getLastVersion() != -1L) continue;
                ++newlyDeadBugs;
                newBug = (BugInstance)bug.clone();
                ClassAnnotation classBugFoundIn = bug.getPrimaryClass();
                String className = classBugFoundIn.getClassName();
                String sourceFile = classBugFoundIn.getSourceFileName();
                boolean bl = removed = sourceFile != null && analyzedSourceFiles.contains(sourceFile) || newCollection.getProjectStats().getClassStats(className) != null;
                if (removed) {
                    if (!copyDeadBugs) continue;
                    newBug.setRemovedByChangeOfPersistingClass(true);
                    newBug.setLastVersion(lastSequence);
                } else {
                    ++deadBugInDeadCode;
                    if (!incrementalAnalysis) {
                        newBug.setLastVersion(lastSequence);
                    }
                }
                if (newBug.getLastVersion() != -1L && newBug.getFirstVersion() > newBug.getLastVersion()) {
                    throw new IllegalStateException("Illegal Version range: " + newBug.getFirstVersion() + ".." + newBug.getLastVersion());
                }
                resultCollection.add(newBug, false);
            }
        }
        for (BugInstance bug : newCollection.getCollection()) {
            newBug = (BugInstance)bug.clone();
            if (this.mapFromNewToOldBug.containsKey(bug)) {
                BugInstance origWarning = this.mapFromNewToOldBug.get(bug);
                assert (origWarning.getLastVersion() == -1L);
                Update.copyBugHistory(origWarning, newBug);
                BugDesignation designation = newBug.getUserDesignation();
                if (designation != null) {
                    designation.merge(origWarning.getUserDesignation());
                } else {
                    newBug.setUserDesignation(origWarning.getUserDesignation());
                }
                ++persistantBugs;
            } else {
                newBug.setFirstVersion(lastSequence + 1L);
                ++addedBugs;
                ClassAnnotation classBugFoundIn = bug.getPrimaryClass();
                String className = classBugFoundIn.getClassName();
                if (origCollection.getProjectStats().getClassStats(className) != null) {
                    newBug.setIntroducedByChangeOfExistingClass(true);
                } else {
                    ++addedInNewCode;
                }
            }
            assert (newBug.getLastVersion() == -1L);
            if (newBug.getLastVersion() != -1L) {
                throw new IllegalStateException("Illegal Version range: " + newBug.getFirstVersion() + ".." + newBug.getLastVersion());
            }
            int oldSize = resultCollection.getCollection().size();
            resultCollection.add(newBug, false);
            int newSize = resultCollection.getCollection().size();
            if (newSize == oldSize + 1) continue;
            System.out.println("Failed to add bug #" + newBug.getUniqueId() + " : " + newBug.getMessage());
        }
        return resultCollection;
    }

    private void matchBugs(BugCollection origCollection, BugCollection newCollection) {
        this.matchBugs(SortedBugCollection.BugInstanceComparator.instance, origCollection, newCollection);
        this.mapFromNewToOldBug.clear();
        this.matchedOldBugs.clear();
        this.matchBugs(this.versionInsensitiveBugComparator, origCollection, newCollection);
        if (!this.preciseMatch) {
            this.matchBugs(this.fuzzyBugPatternMatcher, origCollection, newCollection);
        }
        if (!this.noPackageMoves) {
            VersionInsensitiveBugComparator movedBugComparator = new VersionInsensitiveBugComparator();
            MovedClassMap movedClassMap = new MovedClassMap(origCollection, newCollection).execute();
            if (!movedClassMap.isEmpty()) {
                movedBugComparator.setClassNameRewriter(movedClassMap);
                movedBugComparator.setComparePriorities(this.precisePriorityMatch);
                this.matchBugs(movedBugComparator, origCollection, newCollection);
                if (!this.preciseMatch) {
                    movedBugComparator.setExactBugPatternMatch(false);
                    this.matchBugs(movedBugComparator, origCollection, newCollection);
                }
            }
        }
    }

    public static String[] getFilePathParts(String filePath) {
        String regex = File.separatorChar == '\\' ? "\\\\" : File.separator;
        return filePath.split(regex);
    }

    public static void main(String[] args) throws IOException, DocumentException {
        new Update().doit(args);
    }

    public void doit(String[] args) throws IOException, DocumentException {
        DetectorFactoryCollection.instance();
        UpdateCommandLine commandLine = new UpdateCommandLine();
        int argCount = commandLine.parse(args, 1, Integer.MAX_VALUE, USAGE);
        if (commandLine.outputFilename == null) {
            this.verbose = false;
        }
        String[] firstPathParts = Update.getFilePathParts(args[argCount]);
        int commonPrefix = firstPathParts.length;
        for (int i = argCount + 1; i <= args.length - 1; ++i) {
            commonPrefix = Math.min(commonPrefix, Update.lengthCommonPrefix(firstPathParts, Update.getFilePathParts(args[i])));
        }
        if (this.mostRecent > 0) {
            argCount = Math.max(argCount, args.length - this.mostRecent);
        }
        String origFilename = args[argCount++];
        Project project = new Project();
        BugCollection origCollection = new SortedBugCollection();
        if (this.verbose) {
            System.out.println("Starting with " + origFilename);
        }
        origCollection.readXML(origFilename, project);
        if (commandLine.overrideRevisionNames || origCollection.getReleaseName() == null || origCollection.getReleaseName().length() == 0) {
            if (commonPrefix >= firstPathParts.length) {
                commonPrefix = firstPathParts.length - 1;
            }
            origCollection.setReleaseName(firstPathParts[commonPrefix]);
        }
        for (BugInstance bug : origCollection.getCollection()) {
            if (bug.getLastVersion() < 0L || bug.getFirstVersion() <= bug.getLastVersion()) continue;
            throw new IllegalStateException("Illegal Version range: " + bug.getFirstVersion() + ".." + bug.getLastVersion());
        }
        while (argCount <= args.length - 1) {
            SortedBugCollection newCollection = new SortedBugCollection();
            String newFilename = args[argCount++];
            if (this.verbose) {
                System.out.println("Merging " + newFilename);
            }
            project = new Project();
            try {
                File f = new File(newFilename);
                if (f.length() == 0L) {
                    if (!this.verbose) continue;
                    System.out.println("Empty input file: " + f);
                    continue;
                }
                newCollection.readXML(newFilename, project);
                if (commandLine.overrideRevisionNames || newCollection.getReleaseName() == null || newCollection.getReleaseName().length() == 0) {
                    newCollection.setReleaseName(Update.getFilePathParts(newFilename)[commonPrefix]);
                }
                origCollection = this.mergeCollections(origCollection, newCollection, true, false);
            }
            catch (IOException e) {
                if (this.verbose) {
                    System.out.println(e);
                    continue;
                }
                throw e;
            }
        }
        origCollection.setWithMessages(commandLine.withMessages);
        if (commandLine.outputFilename != null) {
            origCollection.writeXML(commandLine.outputFilename, project);
        } else {
            origCollection.writeXML(System.out, project);
        }
    }

    private static int lengthCommonPrefix(String[] string, String[] string2) {
        int maxLength = Math.min(string.length, string2.length);
        for (int result = 0; result < maxLength; ++result) {
            if (string[result].equals(string2[result])) continue;
            return result;
        }
        return maxLength;
    }

    private static void copyBugHistory(BugInstance src, BugInstance dest) {
        dest.setFirstVersion(src.getFirstVersion());
        dest.setLastVersion(src.getLastVersion());
        dest.setIntroducedByChangeOfExistingClass(src.isIntroducedByChangeOfExistingClass());
        dest.setRemovedByChangeOfPersistingClass(src.isRemovedByChangeOfPersistingClass());
    }

    private void matchBugs(Comparator<BugInstance> bugInstanceComparator, BugCollection origCollection, BugCollection newCollection) {
        LinkedList q;
        TreeMap<BugInstance, LinkedList<BugInstance>> set = new TreeMap<BugInstance, LinkedList<BugInstance>>(bugInstanceComparator);
        int oldBugs = 0;
        int newBugs = 0;
        int matchedBugs = 0;
        for (BugInstance bug : origCollection.getCollection()) {
            if (bug.getLastVersion() != -1L || this.matchedOldBugs.contains(bug)) continue;
            ++oldBugs;
            q = (LinkedList)set.get(bug);
            if (q == null) {
                q = new LinkedList();
                set.put(bug, q);
            }
            q.add(bug);
        }
        for (BugInstance bug : newCollection.getCollection()) {
            if (this.mapFromNewToOldBug.containsKey(bug)) continue;
            ++newBugs;
            q = (LinkedList)set.get(bug);
            if (q == null || q.isEmpty()) continue;
            ++matchedBugs;
            BugInstance matchedBug = (BugInstance)q.removeFirst();
            this.mapFromNewToOldBug.put(bug, matchedBug);
            this.matchedOldBugs.add(matchedBug);
        }
    }

    class UpdateCommandLine
    extends CommandLine {
        boolean overrideRevisionNames = false;
        String outputFilename;
        boolean withMessages = false;

        UpdateCommandLine() {
            this.addSwitch("-overrideRevisionNames", "override revision names for each version with names computed filenames");
            this.addSwitch("-noPackageMoves", "if a class seems to have moved from one package to another, treat warnings in that class as two seperate warnings");
            this.addSwitch("-preciseMatch", "require bug patterns to match precisely");
            this.addSwitch("-precisePriorityMatch", "only consider two warnings to be the same if their priorities match exactly");
            this.addOption("-output", "output file", "explicit filename for merged results (standard out used if not specified)");
            this.addSwitch("-quiet", "don't generate any outout to standard out unless there is an error");
            this.addSwitch("-withMessages", "Add bug description");
            this.addOption("-onlyMostRecent", "number", "only use the last # input files");
        }

        protected void handleOption(String option, String optionExtraPart) throws IOException {
            if (option.equals("-overrideRevisionNames")) {
                this.overrideRevisionNames = optionExtraPart.length() == 0 ? true : TigerSubstitutes.parseBoolean(optionExtraPart);
            } else if (option.equals("-noPackageMoves")) {
                Update.this.noPackageMoves = optionExtraPart.length() == 0 ? true : TigerSubstitutes.parseBoolean(optionExtraPart);
            } else if (option.equals("-preciseMatch")) {
                Update.this.preciseMatch = true;
            } else if (option.equals("-precisePriorityMatch")) {
                Update.this.versionInsensitiveBugComparator.setComparePriorities(true);
                Update.this.fuzzyBugPatternMatcher.setComparePriorities(true);
                Update.this.precisePriorityMatch = true;
            } else if (option.equals("-quiet")) {
                Update.this.verbose = false;
            } else if (option.equals("-withMessages")) {
                this.withMessages = true;
            } else {
                throw new IllegalArgumentException("no option " + option);
            }
        }

        protected void handleOptionWithArgument(String option, String argument) throws IOException {
            if (option.equals("-output")) {
                this.outputFilename = argument;
            } else if (option.equals("-onlyMostRecent")) {
                Update.this.mostRecent = Integer.parseInt(argument);
            } else {
                throw new IllegalArgumentException("Can't handle option " + option);
            }
        }
    }
}

