/**
 * <copyright>
 *
 * Copyright (c) 2003-2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * $Id: SDOSwitch.java,v 1.11 2007/06/12 21:15:33 emerks Exp $
 */
package org.eclipse.emf.ecore.sdo.util;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.FeatureChange;
import org.eclipse.emf.ecore.sdo.*;

import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.ecore.xml.type.SimpleAnyType;

import commonj.sdo.ChangeSummary;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Sequence;
import commonj.sdo.Type;

import java.io.Serializable;

import java.util.List;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.eclipse.emf.ecore.sdo.SDOPackage
 * @generated
 */
public class SDOSwitch<T> {
  /**
   * The cached model package
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  protected static SDOPackage modelPackage;

  /**
   * Creates an instance of the switch.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public SDOSwitch()
  {
    if (modelPackage == null)
    {
      modelPackage = SDOPackage.eINSTANCE;
    }
  }

  /**
   * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the first non-null result returned by a <code>caseXXX</code> call.
   * @generated
   */
  public T doSwitch(EObject theEObject)
  {
    return doSwitch(theEObject.eClass(), theEObject);
  }

  /**
   * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the first non-null result returned by a <code>caseXXX</code> call.
   * @generated
   */
  protected T doSwitch(EClass theEClass, EObject theEObject)
  {
    if (theEClass.eContainer() == modelPackage)
    {
      return doSwitch(theEClass.getClassifierID(), theEObject);
    }
    else
    {
      List<EClass> eSuperTypes = theEClass.getESuperTypes();
      return
        eSuperTypes.isEmpty() ?
          defaultCase(theEObject) :
          doSwitch(eSuperTypes.get(0), theEObject);
    }
  }

  /**
   * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @return the first non-null result returned by a <code>caseXXX</code> call.
   * @generated
   */
  protected T doSwitch(int classifierID, EObject theEObject)
  {
    switch (classifierID)
    {
      case SDOPackage.ECHANGE_SUMMARY:
      {
        EChangeSummary eChangeSummary = (EChangeSummary)theEObject;
        T result = caseEChangeSummary(eChangeSummary);
        if (result == null) result = caseChangeDescription(eChangeSummary);
        if (result == null) result = caseChangeSummary(eChangeSummary);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case SDOPackage.ECHANGE_SUMMARY_SETTING:
      {
        EChangeSummarySetting eChangeSummarySetting = (EChangeSummarySetting)theEObject;
        T result = caseEChangeSummarySetting(eChangeSummarySetting);
        if (result == null) result = caseFeatureChange(eChangeSummarySetting);
        if (result == null) result = caseChangeSummarySetting(eChangeSummarySetting);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case SDOPackage.EDATA_GRAPH:
      {
        EDataGraph eDataGraph = (EDataGraph)theEObject;
        T result = caseEDataGraph(eDataGraph);
        if (result == null) result = caseDataGraph(eDataGraph);
        if (result == null) result = caseEJavaSerializable(eDataGraph);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case SDOPackage.EDATA_OBJECT:
      {
        EDataObject eDataObject = (EDataObject)theEObject;
        T result = caseEDataObject(eDataObject);
        if (result == null) result = caseDataObject(eDataObject);
        if (result == null) result = caseEJavaSerializable(eDataObject);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case SDOPackage.EPROPERTY:
      {
        EProperty eProperty = (EProperty)theEObject;
        T result = caseEProperty(eProperty);
        if (result == null) result = caseProperty(eProperty);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case SDOPackage.ETYPE:
      {
        EType eType = (EType)theEObject;
        T result = caseEType(eType);
        if (result == null) result = caseType(eType);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case SDOPackage.INTERNAL_EDATA_OBJECT:
      {
        InternalEDataObject internalEDataObject = (InternalEDataObject)theEObject;
        T result = caseInternalEDataObject(internalEDataObject);
        if (result == null) result = caseEDataObject(internalEDataObject);
        if (result == null) result = caseDataObject(internalEDataObject);
        if (result == null) result = caseEJavaSerializable(internalEDataObject);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case SDOPackage.EDATA_OBJECT_ANY_TYPE:
      {
        EDataObjectAnyType eDataObjectAnyType = (EDataObjectAnyType)theEObject;
        T result = caseEDataObjectAnyType(eDataObjectAnyType);
        if (result == null) result = caseAnyType(eDataObjectAnyType);
        if (result == null) result = caseEDataObject(eDataObjectAnyType);
        if (result == null) result = caseDataObject(eDataObjectAnyType);
        if (result == null) result = caseEJavaSerializable(eDataObjectAnyType);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      case SDOPackage.EDATA_OBJECT_SIMPLE_ANY_TYPE:
      {
        EDataObjectSimpleAnyType eDataObjectSimpleAnyType = (EDataObjectSimpleAnyType)theEObject;
        T result = caseEDataObjectSimpleAnyType(eDataObjectSimpleAnyType);
        if (result == null) result = caseSimpleAnyType(eDataObjectSimpleAnyType);
        if (result == null) result = caseEDataObjectAnyType(eDataObjectSimpleAnyType);
        if (result == null) result = caseAnyType(eDataObjectSimpleAnyType);
        if (result == null) result = caseEDataObject(eDataObjectSimpleAnyType);
        if (result == null) result = caseDataObject(eDataObjectSimpleAnyType);
        if (result == null) result = caseEJavaSerializable(eDataObjectSimpleAnyType);
        if (result == null) result = defaultCase(theEObject);
        return result;
      }
      default: return defaultCase(theEObject);
    }
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>EData Object</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>EData Object</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseEDataObject(EDataObject object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>EData Graph</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>EData Graph</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseEDataGraph(EDataGraph object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>EChange Summary</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>EChange Summary</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseEChangeSummary(EChangeSummary object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>EProperty</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>EProperty</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseEProperty(EProperty object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Data Object</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Data Object</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseDataObject(DataObject object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>ESequence</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>ESequence</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseESequence(ESequence object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Data Graph</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Data Graph</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseDataGraph(DataGraph object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Change Summary</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Change Summary</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseChangeSummary(ChangeSummary object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>EType</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>EType</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseEType(EType object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Type</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Type</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseType(Type object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Property</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Property</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseProperty(Property object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Sequence</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Sequence</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseSequence(Sequence object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>EChange Summary Setting</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>EChange Summary Setting</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseEChangeSummarySetting(EChangeSummarySetting object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Internal EData Object</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Internal EData Object</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseInternalEDataObject(InternalEDataObject object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>EData Object Any Type</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>EData Object Any Type</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseEDataObjectAnyType(EDataObjectAnyType object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>EData Object Simple Any Type</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>EData Object Simple Any Type</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseEDataObjectSimpleAnyType(EDataObjectSimpleAnyType object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>EJava Serializable</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>EJava Serializable</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseEJavaSerializable(Serializable object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Description</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Description</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseChangeDescription(ChangeDescription object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Feature Change</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Feature Change</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseFeatureChange(FeatureChange object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Any Type</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Any Type</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseAnyType(AnyType object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Simple Any Type</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Simple Any Type</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseSimpleAnyType(SimpleAnyType object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>Change Summary Setting</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>Change Summary Setting</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
   * @generated
   */
  public T caseChangeSummarySetting(ChangeSummary.Setting object)
  {
    return null;
  }

  /**
   * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
   * <!-- begin-user-doc -->
   * This implementation returns null;
   * returning a non-null result will terminate the switch, but this is the last case anyway.
   * <!-- end-user-doc -->
   * @param object the target of the switch.
   * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
   * @see #doSwitch(org.eclipse.emf.ecore.EObject)
   * @generated
   */
  public T defaultCase(EObject object)
  {
    return null;
  }

} //SDOSwitch
