/**
 * <copyright>
 *
 * Copyright (c) 2003-2006 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * $Id: ApplyChangeAction.java,v 1.3 2006/12/29 18:26:00 marcelop Exp $
 */
package org.eclipse.emf.ecore.sdo.action;


import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.actions.ActionDelegate;

import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.sdo.EChangeSummary;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;


/**
 * 
 */
public class ApplyChangeAction 
  extends ActionDelegate
  implements IActionDelegate
{
  protected EChangeSummary changeSummary;

  public ApplyChangeAction()
  {
    super();
  }

  @Override
  public void run(IAction action)
  {
    EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor(changeSummary);
    if (editingDomain != null)
    {
      editingDomain.getCommandStack().execute(
        new 
          AbstractCommand()
          {                                   
            @Override
            protected boolean prepare() { return true; }
            @Override
            public boolean canUndo() { return false; }
            public void execute() { changeSummary.apply(); }
            public void redo() { /* do nothing*/ }
          });
    }
  }

  @Override
  public void selectionChanged(IAction action, ISelection selection) 
  {
    if (selection instanceof IStructuredSelection)
    {
      Object object = ((IStructuredSelection)selection).getFirstElement();
      if (object instanceof EChangeSummary)
      {
        changeSummary = (EChangeSummary)object;
        if (!changeSummary.isLogging())
        {
          action.setEnabled(true);
          return;
        }
      }
    }
    changeSummary = null;
    action.setEnabled(false);
  }

}
