/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.TypeResolver;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.types.MessageType;
import org.eclipse.ocl.types.TupleType;
import org.eclipse.ocl.types.TypeType;
import org.eclipse.ocl.types.util.TypesSwitch;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.ocl.utilities.OCLFactory;
import org.eclipse.ocl.utilities.TypedElement;
import org.eclipse.ocl.utilities.UMLReflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTypeResolver<PK, C, O, P, PM>
implements TypeResolver<C, O, P> {
    protected static final String COLLECTIONS_PACKAGE = "collections";
    protected static final String MESSAGES_PACKAGE = "messages";
    protected static final String TUPLES_PACKAGE = "tuples";
    protected static final String TYPES_PACKAGE = "types";
    protected static final String ADDITIONS_PACKAGE = "additions";
    private final TypesSwitch<C> resolveSwitch = new ResolveSwitch();
    private final Environment<PK, C, O, P, ?, PM, ?, ?, ?, ?, ?, ?> env;
    private final OCLFactory oclFactory;
    private final UMLReflection<PK, C, O, P, ?, PM, ?, ?, ?, ?> uml;
    private Resource resource;
    private PK collectionPackage;
    private PK tuplePackage;
    private PK typePackage;
    private PK messagePackage;
    private PK additionalFeaturesPackage;

    public AbstractTypeResolver(Environment<PK, C, O, P, ?, PM, ?, ?, ?, ?, ?, ?> env) {
        this(env, null);
    }

    public AbstractTypeResolver(Environment<PK, C, O, P, ?, PM, ?, ?, ?, ?, ?, ?> env, Resource resource) {
        this.env = env;
        this.resource = resource;
        this.oclFactory = env.getOCLFactory();
        this.uml = env.getUMLReflection();
    }

    @Override
    public C resolve(C type) {
        return type == null ? type : this.resolveSwitch.doSwitch((EObject)type);
    }

    protected final Environment<PK, C, O, P, ?, PM, ?, ?, ?, ?, ?, ?> getEnvironment() {
        return this.env;
    }

    @Override
    public Resource getResource() {
        if (this.resource == null) {
            this.resource = this.createResource();
        }
        return this.resource;
    }

    protected Resource createResource() {
        return new ResourceImpl(URI.createURI((String)"ocl:///oclenv"));
    }

    public PK getCollectionPackage() {
        if (this.collectionPackage == null) {
            this.collectionPackage = this.findCollectionPackage();
            if (this.collectionPackage == null) {
                this.collectionPackage = this.createCollectionPackage();
            }
        }
        return this.collectionPackage;
    }

    protected PK createCollectionPackage() {
        return this.createPackage(COLLECTIONS_PACKAGE);
    }

    protected PK findCollectionPackage() {
        return this.findPackage(COLLECTIONS_PACKAGE);
    }

    @Override
    public CollectionType<C, O> resolveCollectionType(CollectionKind kind, C elementType) {
        CollectionType<C, O> result = this.findCollectionType(kind, elementType);
        if (result == null) {
            result = this.createCollectionType(kind, elementType);
        }
        return result;
    }

    protected CollectionType<C, O> createCollectionType(CollectionKind kind, C elementType) {
        CollectionType result = this.oclFactory.createCollectionType(kind, elementType);
        this.addClassifier(this.getCollectionPackage(), result);
        return result;
    }

    protected CollectionType<C, O> findCollectionType(CollectionKind kind, C elementType) {
        for (C next : this.uml.getClassifiers(this.getCollectionPackage())) {
            CollectionType type;
            if (!(next instanceof CollectionType) || (type = (CollectionType)next).getKind() != kind || TypeUtil.getRelationship(this.env, type.getElementType(), elementType) != 1) continue;
            return type;
        }
        return null;
    }

    public PK getTuplePackage() {
        if (this.tuplePackage == null) {
            this.tuplePackage = this.findTuplePackage();
            if (this.tuplePackage == null) {
                this.tuplePackage = this.createTuplePackage();
            }
        }
        return this.tuplePackage;
    }

    protected PK createTuplePackage() {
        return this.createPackage(TUPLES_PACKAGE);
    }

    protected PK findTuplePackage() {
        return this.findPackage(TUPLES_PACKAGE);
    }

    @Override
    public TupleType<O, P> resolveTupleType(EList<? extends TypedElement<C>> parts) {
        TupleType<O, P> result = this.findTupleType(parts);
        if (result == null) {
            result = this.createTupleType(parts);
        }
        return result;
    }

    protected TupleType<O, P> createTupleType(EList<? extends TypedElement<C>> parts) {
        TupleType result = this.oclFactory.createTupleType(parts);
        this.addClassifier(this.getTuplePackage(), result);
        return result;
    }

    protected TupleType<O, P> findTupleType(EList<? extends TypedElement<C>> parts) {
        for (C next : this.uml.getClassifiers(this.getTuplePackage())) {
            TupleType type;
            if (!(next instanceof TupleType) || (type = (TupleType)next).oclProperties().size() != parts.size()) continue;
            for (TypedElement part : parts) {
                P property = this.env.lookupProperty(type, part.getName());
                if (property == null || TypeUtil.getRelationship(this.env, this.uml.getOCLType(property), part.getType()) != 1) break;
            }
            return type;
        }
        return null;
    }

    public PK getTypePackage() {
        if (this.typePackage == null) {
            this.typePackage = this.findTypePackage();
            if (this.typePackage == null) {
                this.typePackage = this.createTypePackage();
            }
        }
        return this.typePackage;
    }

    protected PK createTypePackage() {
        return this.createPackage(TYPES_PACKAGE);
    }

    protected PK findTypePackage() {
        return this.findPackage(TYPES_PACKAGE);
    }

    @Override
    public TypeType<C, O> resolveTypeType(C type) {
        TypeType<C, O> result = this.findTypeType(type);
        if (result == null) {
            result = this.createTypeType(type);
        }
        return result;
    }

    protected TypeType<C, O> createTypeType(C type) {
        TypeType result = this.oclFactory.createTypeType(type);
        this.addClassifier(this.getTypePackage(), result);
        return result;
    }

    protected TypeType<C, O> findTypeType(C type) {
        for (C next : this.uml.getClassifiers(this.getTypePackage())) {
            TypeType typeType;
            if (!(next instanceof TypeType) || TypeUtil.getRelationship(this.env, (typeType = (TypeType)next).getReferredType(), type) != 1) continue;
            return typeType;
        }
        return null;
    }

    public PK getMessagePackage() {
        if (this.messagePackage == null) {
            this.messagePackage = this.findMessagePackage();
            if (this.messagePackage == null) {
                this.messagePackage = this.createMessagePackage();
            }
        }
        return this.messagePackage;
    }

    protected PK createMessagePackage() {
        return this.createPackage(MESSAGES_PACKAGE);
    }

    protected PK findMessagePackage() {
        return this.findPackage(MESSAGES_PACKAGE);
    }

    @Override
    public MessageType<C, O, P> resolveOperationMessageType(O operation) {
        MessageType<C, O, P> result = this.findMessageType(operation);
        if (result == null) {
            result = this.createOperationMessageType(operation);
        }
        return result;
    }

    @Override
    public MessageType<C, O, P> resolveSignalMessageType(C signal) {
        MessageType<C, O, P> result = this.findMessageType(signal);
        if (result == null) {
            result = this.createSignalMessageType(signal);
        }
        return result;
    }

    protected MessageType<C, O, P> createOperationMessageType(O operation) {
        MessageType result = this.oclFactory.createOperationMessageType(operation);
        this.addClassifier(this.getMessagePackage(), result);
        return result;
    }

    protected MessageType<C, O, P> createSignalMessageType(C signal) {
        MessageType result = this.oclFactory.createSignalMessageType(signal);
        this.addClassifier(this.getMessagePackage(), result);
        return result;
    }

    protected MessageType<C, O, P> findMessageType(Object element) {
        for (C next : this.uml.getClassifiers(this.getMessagePackage())) {
            MessageType type;
            if (!(next instanceof MessageType) || (type = (MessageType)next).getReferredOperation() != element && type.getReferredSignal() != element) continue;
            return type;
        }
        return null;
    }

    public PK getAdditionalFeaturesPackage() {
        if (this.additionalFeaturesPackage == null) {
            this.additionalFeaturesPackage = this.findAdditionalFeaturesPackage();
            if (this.additionalFeaturesPackage == null) {
                this.additionalFeaturesPackage = this.createAdditionalFeaturesPackage();
            }
        }
        return this.additionalFeaturesPackage;
    }

    protected PK createAdditionalFeaturesPackage() {
        return this.createPackage(ADDITIONS_PACKAGE);
    }

    protected PK findAdditionalFeaturesPackage() {
        return this.findPackage(ADDITIONS_PACKAGE);
    }

    @Override
    public O resolveAdditionalOperation(C owner, O operation) {
        C shadow = this.getShadowClass(owner);
        O result = this.findMatchingOperation(shadow, operation);
        if (result == null) {
            result = operation;
            this.addOperation(shadow, result);
        }
        return result;
    }

    @Override
    public List<O> getAdditionalOperations(C owner) {
        C shadow;
        if (this.hasAdditionalFeatures() && (shadow = this.findShadowClass(owner)) != null) {
            return this.uml.getOperations(shadow);
        }
        return (List)ECollections.emptyEList();
    }

    protected O findMatchingOperation(C shadow, O operation) {
        String operationName = this.uml.getName(operation);
        for (O next : this.uml.getOperations(shadow)) {
            if (next != operation && (!this.uml.getName(next).equals(operationName) || !this.matchParameters(next, operation))) continue;
            return next;
        }
        return null;
    }

    private boolean matchParameters(O a, O b) {
        List<PM> aparms = this.uml.getParameters(a);
        List<PM> bparms = this.uml.getParameters(b);
        if (aparms.size() == bparms.size()) {
            int count = aparms.size();
            int i = 0;
            while (i < count) {
                PM aparm = aparms.get(i);
                PM bparm = bparms.get(i);
                if (!this.uml.getName(aparm).equals(this.uml.getName(bparm)) || TypeUtil.getRelationship(this.env, this.uml.getOCLType(aparm), this.uml.getOCLType(bparm)) != 1) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    protected P findMatchingProperty(C shadow, P property) {
        String propertyName = this.uml.getName(property);
        for (P next : this.uml.getAttributes(shadow)) {
            if (next != property && !this.uml.getName(next).equals(propertyName)) continue;
            return next;
        }
        return null;
    }

    @Override
    public P resolveAdditionalAttribute(C owner, P property) {
        C shadow = this.getShadowClass(owner);
        P result = this.findMatchingProperty(shadow, property);
        if (result == null) {
            result = property;
            this.addProperty(shadow, result);
        }
        return result;
    }

    protected boolean hasAdditionalFeatures() {
        return this.additionalFeaturesPackage != null;
    }

    @Override
    public List<P> getAdditionalAttributes(C owner) {
        C shadow;
        if (this.hasAdditionalFeatures() && (shadow = this.findShadowClass(owner)) != null) {
            return this.uml.getAttributes(shadow);
        }
        return (List)ECollections.emptyEList();
    }

    protected abstract C createShadowClass(C var1);

    protected abstract void addProperty(C var1, P var2);

    protected abstract void addOperation(C var1, O var2);

    protected C findShadowClass(C type) {
        Object pkg;
        Object PK = pkg = this.hasAdditionalFeatures() ? (Object)this.getAdditionalFeaturesPackage() : null;
        if (pkg != null) {
            for (C next : this.uml.getClassifiers(pkg)) {
                if (this.getShadowedClassifier(next) != type) continue;
                return next;
            }
        }
        return null;
    }

    protected abstract C getShadowedClassifier(C var1);

    protected C getShadowClass(C type) {
        C result = this.findShadowClass(type);
        if (result == null) {
            result = this.createShadowClass(type);
            PK pkg = this.getAdditionalFeaturesPackage();
            if (pkg != null) {
                this.addClassifier(pkg, result);
            }
        }
        return result;
    }

    protected abstract PK createPackage(String var1);

    protected abstract PK findPackage(String var1);

    protected abstract void addClassifier(PK var1, C var2);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ResolveSwitch
    extends TypesSwitch<C> {
        private ResolveSwitch() {
        }

        @Override
        public <C1, O1> C caseCollectionType(CollectionType<C1, O1> object) {
            return AbstractTypeResolver.this.resolveCollectionType(object.getKind(), AbstractTypeResolver.this.resolve(object.getElementType()));
        }

        @Override
        public <O1, P1> C caseTupleType(TupleType<O1, P1> object) {
            return AbstractTypeResolver.this.resolveTupleType(this.createTupleParts((Collection)object.oclProperties()));
        }

        @Override
        public <C1, O1> C caseTypeType(TypeType<C1, O1> object) {
            return AbstractTypeResolver.this.resolveTypeType(AbstractTypeResolver.this.resolve(object.getReferredType()));
        }

        @Override
        public <C1, O1, P1> C caseMessageType(MessageType<C1, O1, P1> object) {
            if (object.getReferredOperation() != null) {
                return AbstractTypeResolver.this.resolveOperationMessageType(object.getReferredOperation());
            }
            if (object.getReferredSignal() != null) {
                return AbstractTypeResolver.this.resolveSignalMessageType(object.getReferredSignal());
            }
            return null;
        }

        @Override
        public C defaultCase(EObject object) {
            return object;
        }

        private EList<Variable<C, PM>> createTupleParts(Collection<P> properties) {
            BasicEList.FastCompare result = new BasicEList.FastCompare();
            OCLFactory oclFactory = AbstractTypeResolver.this.env.getOCLFactory();
            for (Object next : properties) {
                Variable v = oclFactory.createVariable();
                AbstractTypeResolver.this.uml.setName(v, AbstractTypeResolver.this.uml.getName(next));
                AbstractTypeResolver.this.uml.setType(v, AbstractTypeResolver.this.resolve(AbstractTypeResolver.this.uml.getOCLType(next)));
                result.add(v);
            }
            return result;
        }
    }
}

