/*
 * Decompiled with CFR 0.152.
 */
package net.sf.commonclipse;

import net.sf.commonclipse.CCPluginPreferences;
import net.sf.commonclipse.Generator;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

public final class EqualsGenerator
extends Generator {
    private static final String BUILDER_CLASS = "org.apache.commons.lang.builder.EqualsBuilder";
    private static Generator instance = new EqualsGenerator();

    private EqualsGenerator() {
    }

    public static Generator getInstance() {
        return instance;
    }

    protected String getMethodName() {
        return "equals";
    }

    protected String createMethod(IType type) throws JavaModelException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getJavadoc());
        String className = type.getElementName();
        buffer.append("public boolean equals(");
        if (CCPluginPreferences.getPreferences().useFinalParameters()) {
            buffer.append("final ");
        }
        buffer.append("Object object) {\n");
        if (CCPluginPreferences.getPreferences().addInstanceCheckToEquals()) {
            buffer.append("if (object == this) {\nreturn true;\n}\n");
        }
        buffer.append("if ( !(object instanceof ");
        buffer.append(className);
        buffer.append(") ) {\nreturn false;\n}\n");
        buffer.append(className);
        buffer.append(" rhs = (");
        buffer.append(className);
        buffer.append(") object;\nreturn new EqualsBuilder()\n");
        if (CCPluginPreferences.getPreferences().appendSuperToEquals()) {
            buffer.append(".appendSuper(super.equals(object))\n");
        }
        buffer.append(this.buildAppenderList(type));
        buffer.append(".isEquals();\n}\n");
        return buffer.toString();
    }

    protected String getFieldAppender(String fieldName, String accessor) {
        return ".append(this." + fieldName + ", rhs." + fieldName + ")\n";
    }

    protected IMethod getExistingMethod(IType type) {
        return type.getMethod(this.getMethodName(), new String[]{"QObject;"});
    }

    protected void addImports(IType type) throws JavaModelException {
        type.getCompilationUnit().createImport(BUILDER_CLASS, null, null);
    }

    private String getJavadoc() {
        return "/**\n * @see java.lang.Object#equals(Object)\n */\n";
    }
}

