/*
 * Decompiled with CFR 0.152.
 */
package net.sf.commonclipse;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import net.sf.commonclipse.CCMessages;
import net.sf.commonclipse.CCPluginPreferences;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public abstract class Generator {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public void generate(IType type, Shell shell) {
        IStatus status;
        IResource resource;
        ICompilationUnit cu = (ICompilationUnit)type.getAncestor(5);
        try {
            resource = cu.getCorrespondingResource();
        }
        catch (JavaModelException e) {
            MessageDialog.openError((Shell)shell, (String)CCMessages.getString("Generator.errortitle"), (String)e.getMessage());
            return;
        }
        if (resource != null && resource.getResourceAttributes().isReadOnly() && !(status = ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{(IFile)resource}, (Object)shell)).isOK()) {
            MessageDialog.openError((Shell)shell, (String)CCMessages.getString("Generator.errortitle"), (String)CCMessages.getString("Generator.readonly"));
            return;
        }
        resource = null;
        if (!this.validate(type, shell)) {
            return;
        }
        ProgressMonitorDialog progressDialog = new ProgressMonitorDialog(shell);
        progressDialog.open();
        try {
            IProgressMonitor monitor = progressDialog.getProgressMonitor();
            this.generateMethod(type, cu, shell, monitor);
        }
        catch (JavaModelException ex) {
            MessageDialog.openError((Shell)shell, (String)CCMessages.getString("Generator.errortitle"), (String)ex.getMessage());
        }
        progressDialog.close();
    }

    protected boolean validate(IType type, Shell shell) {
        IMethod method = this.getExistingMethod(type);
        if (method != null && method.exists()) {
            boolean dontAsk = CCPluginPreferences.getPreferences().dontAskOnOverwrite();
            if (dontAsk || MessageDialog.openConfirm((Shell)shell, (String)"commonclipse", (String)MessageFormat.format(CCMessages.getString("Generator.methodexists"), this.getMethodName(), type.getElementName()))) {
                try {
                    method.delete(true, null);
                    return true;
                }
                catch (JavaModelException e) {
                    MessageDialog.openError((Shell)shell, (String)CCMessages.getString("Generator.errortitle"), (String)MessageFormat.format(CCMessages.getString("Generator.unabletodelete"), this.getMethodName(), e.getMessage()));
                }
            }
            return false;
        }
        return true;
    }

    public void generateMethod(IType type, ICompilationUnit cu, Shell shell, IProgressMonitor monitor) throws JavaModelException {
        String className = type.getElementName();
        String title = MessageFormat.format(CCMessages.getString("Generator.generating"), className);
        monitor.beginTask(title, 100);
        monitor.worked(10);
        monitor.setTaskName(title + CCMessages.getString("Generator.parsing"));
        String src = this.createMethod(type);
        monitor.worked(30);
        monitor.setTaskName(title + CCMessages.getString("Generator.formatting"));
        Document document = new Document(src);
        TextEdit text = ToolFactory.createCodeFormatter(null).format(0, src, 0, src.length(), this.getIndentUsed((IJavaElement)type, cu) + 1, null);
        try {
            text.apply((IDocument)document);
        }
        catch (MalformedTreeException ex) {
            MessageDialog.openError((Shell)shell, (String)CCMessages.getString("Generator.errortitle"), (String)ex.getMessage());
        }
        catch (BadLocationException ex) {
            MessageDialog.openError((Shell)shell, (String)CCMessages.getString("Generator.errortitle"), (String)ex.getMessage());
        }
        monitor.worked(20);
        monitor.setTaskName(title + CCMessages.getString("Generator.adding"));
        type.createMethod(document.get() + LINE_SEPARATOR, null, false, null);
        monitor.worked(20);
        monitor.setTaskName(title + CCMessages.getString("Generator.imports"));
        this.addImports(type);
        monitor.worked(20);
        monitor.done();
    }

    public int getIndentUsed(IJavaElement elem, ICompilationUnit cu) throws JavaModelException {
        if (elem instanceof ISourceReference && cu != null) {
            int offset;
            int i;
            IBuffer buf = cu.getBuffer();
            for (i = offset = ((ISourceReference)elem).getSourceRange().getOffset(); i > 0 && !this.isLineDelimiterChar(buf.getChar(i - 1)); --i) {
            }
            return this.computeIndent(buf.getText(i, offset - i));
        }
        return 0;
    }

    private boolean isLineDelimiterChar(char ch) {
        return ch == '\n' || ch == '\r';
    }

    public int computeIndent(String line) {
        Preferences preferences = JavaCore.getPlugin().getPluginPreferences();
        int tabWidth = preferences.getInt("org.eclipse.jdt.core.formatter.tabulation.size");
        int result = 0;
        int blanks = 0;
        int size = line.length();
        for (int i = 0; i < size; ++i) {
            char c = line.charAt(i);
            if (c == '\t') {
                ++result;
                blanks = 0;
                continue;
            }
            if (Character.isWhitespace(c) && c != '\n' && c != '\r') {
                if (++blanks != tabWidth) continue;
                ++result;
                blanks = 0;
                continue;
            }
            return result;
        }
        return result;
    }

    protected abstract String getMethodName();

    protected abstract String createMethod(IType var1) throws JavaModelException;

    protected abstract IMethod getExistingMethod(IType var1);

    protected abstract void addImports(IType var1) throws JavaModelException;

    protected String buildAppenderList(IType type) throws JavaModelException {
        Map fields = this.buildFieldMap(type);
        StringBuffer buffer = new StringBuffer();
        Iterator fieldsIterator = fields.keySet().iterator();
        while (fieldsIterator.hasNext()) {
            String fieldName = (String)fieldsIterator.next();
            if (this.isExcluded(fieldName)) continue;
            buffer.append(this.getFieldAppender(fieldName, fieldName));
        }
        return buffer.toString();
    }

    protected Map buildFieldMap(IType type) throws JavaModelException {
        HashMap<String, IField> fieldNames = new HashMap<String, IField>();
        IField[] fields = type.getFields();
        for (int j = 0; j < fields.length; ++j) {
            IField field = fields[j];
            int flags = field.getFlags();
            if (Flags.isStatic((int)flags)) continue;
            fieldNames.put(field.getElementName(), field);
        }
        ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
        IType[] types = hierarchy.getSupertypes(type);
        for (int j = 0; j < types.length; ++j) {
            IField[] superFields = types[j].getFields();
            for (int x = 0; x < superFields.length; ++x) {
                IField field = superFields[x];
                int flags = field.getFlags();
                if (Flags.isStatic((int)flags) || Flags.isPrivate((int)flags)) continue;
                fieldNames.put(field.getElementName(), field);
            }
        }
        return fieldNames;
    }

    protected boolean isExcluded(String fieldName) {
        Pattern exclusion = CCPluginPreferences.getPreferences().getExcludedFielsPattern();
        return exclusion.matcher(fieldName).matches();
    }

    protected abstract String getFieldAppender(String var1, String var2);
}

