/*
 * Decompiled with CFR 0.152.
 */
package net.sf.commonclipse.popup.actions;

import java.text.MessageFormat;
import net.sf.commonclipse.CCMessages;
import net.sf.commonclipse.CompareToGenerator;
import net.sf.commonclipse.EqualsGenerator;
import net.sf.commonclipse.HashcodeGenerator;
import net.sf.commonclipse.ToStringGenerator;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public abstract class JavaTypeAction {
    public static final String ACTION_TOSTRING = "cb.ToString";
    public static final String ACTION_HASHCODE = "cb.HashCode";
    public static final String ACTION_EQUALS = "cb.Equals";
    public static final String ACTION_COMPARETO = "cb.CompareTo";

    protected void runAction(IAction action, IType type, Shell shell) {
        try {
            if (!type.isClass()) {
                MessageDialog.openError((Shell)new Shell(), (String)CCMessages.getString("Generator.errortitle"), (String)MessageFormat.format(CCMessages.getString("Generator.notaclass"), type.getElementName()));
                return;
            }
        }
        catch (JavaModelException e) {
            MessageDialog.openError((Shell)new Shell(), (String)CCMessages.getString("Generator.errortitle"), (String)e.getMessage());
            return;
        }
        String id = action.getId();
        if (ACTION_TOSTRING.equals(id)) {
            ToStringGenerator.getInstance().generate(type, shell);
        } else if (ACTION_HASHCODE.equals(id)) {
            HashcodeGenerator.getInstance().generate(type, shell);
        } else if (ACTION_EQUALS.equals(id)) {
            EqualsGenerator.getInstance().generate(type, shell);
        } else if (ACTION_COMPARETO.equals(id)) {
            CompareToGenerator.getInstance().generate(type, shell);
        } else {
            MessageDialog.openError((Shell)new Shell(), (String)CCMessages.getString("Generator.errortitle"), (String)MessageFormat.format(CCMessages.getString("Generator.unknownaction"), id));
        }
    }
}

