/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jadclipse;

import java.io.File;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.sf.jadclipse.JadclipseBufferManager;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class JadclipsePlugin
extends AbstractUIPlugin
implements IPropertyChangeListener {
    public static final String PLUGIN_ID = "net.sf.jadclipse";
    public static final String TEMP_DIR = "net.sf.jadclipse.tempd";
    public static final String CMD = "net.sf.jadclipse.cmd";
    public static final String ALIGN = "net.sf.jadclipse.align";
    public static final String REUSE_BUFFER = "net.sf.jadclipse.reusebuff";
    public static final String IGNORE_EXISTING = "net.sf.jadclipse.alwaysuse";
    public static final String USE_ECLIPSE_FORMATTER = "net.sf.jadclipse.use_eclipse_formatter";
    private static JadclipsePlugin plugin;
    private ResourceBundle resourceBundle;

    public JadclipsePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.resourceBundle = Platform.getResourceBundle((Bundle)this.getBundle());
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.resourceBundle = null;
        plugin = null;
    }

    public static JadclipsePlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = JadclipsePlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public static void logError(Throwable t, String message) {
        JadclipsePlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, 0, message, t));
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        String command = "jad";
        if (this.resourceBundle != null) {
            try {
                command = this.resourceBundle.getString(CMD);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        store.setDefault(CMD, command);
        store.setDefault(TEMP_DIR, String.valueOf(System.getProperty("user.home")) + File.separator + ".net.sf.jadclipse");
        store.setDefault(REUSE_BUFFER, true);
        store.setDefault(IGNORE_EXISTING, false);
        store.setDefault(USE_ECLIPSE_FORMATTER, false);
        store.setDefault("-t", 4);
        store.setDefault("-radix", 10);
        store.setDefault("-lradix", 10);
        store.setDefault("-l", 0);
        store.setDefault("-pi", 0);
        store.setDefault("-pv", 0);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals(IGNORE_EXISTING) && event.getNewValue().equals(Boolean.FALSE)) {
            JadclipseBufferManager.closeJadclipseBuffers(false);
        }
    }
}

