/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.mapping;

import java.util.ArrayList;
import java.util.Iterator;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.engine.Mapping;
import net.sf.hibernate.mapping.Column;
import net.sf.hibernate.mapping.RelationalModel;
import net.sf.hibernate.mapping.Table;

public abstract class Constraint
implements RelationalModel {
    private String name;
    private final ArrayList columns = new ArrayList();
    private Table table;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Iterator getColumnIterator() {
        return this.columns.iterator();
    }

    public void addColumn(Column column) {
        if (!this.columns.contains(column)) {
            this.columns.add(column);
        }
    }

    public void addColumns(Iterator columns) {
        while (columns.hasNext()) {
            this.addColumn((Column)columns.next());
        }
    }

    public int getColumnSpan() {
        return this.columns.size();
    }

    public Table getTable() {
        return this.table;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public String sqlDropString(Dialect dialect, String defaultSchema) {
        return "alter table " + this.getTable().getQualifiedName(dialect, defaultSchema) + " drop constraint " + this.getName();
    }

    public String sqlCreateString(Dialect dialect, Mapping p, String defaultSchema) {
        StringBuffer buf = new StringBuffer("alter table ").append(this.getTable().getQualifiedName(dialect, defaultSchema)).append(this.sqlConstraintString(dialect, this.getName(), defaultSchema));
        return buf.toString();
    }

    public abstract String sqlConstraintString(Dialect var1, String var2, String var3);
}

