/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rowset.internal;

import com.sun.rowset.internal.BaseRow;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.BitSet;
import javax.sql.RowSetMetaData;

public class InsertRow
extends BaseRow
implements Serializable,
Cloneable {
    private BitSet colsInserted;
    private int cols;

    public InsertRow(int n) {
        this.origVals = new Object[n];
        this.colsInserted = new BitSet(n);
        this.cols = n;
    }

    protected void markColInserted(int n) {
        this.colsInserted.set(n);
    }

    public boolean isCompleteRow(RowSetMetaData rowSetMetaData) throws SQLException {
        int n = 0;
        while (n < this.cols) {
            if (!this.colsInserted.get(n) && rowSetMetaData.isNullable(n + 1) == 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void initInsertRow() {
        int n = 0;
        while (n < this.cols) {
            this.colsInserted.clear(n);
            ++n;
        }
    }

    public Object getColumnObject(int n) throws SQLException {
        if (!this.colsInserted.get(n - 1)) {
            throw new SQLException("No value has been inserted");
        }
        return this.origVals[n - 1];
    }

    public void setColumnObject(int n, Object object) {
        this.origVals[n - 1] = object;
        this.markColInserted(n - 1);
    }
}

