/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rowset.internal;

import com.sun.rowset.internal.BaseRow;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.BitSet;

public class Row
extends BaseRow
implements Serializable,
Cloneable {
    private Object[] currentVals;
    private BitSet colsChanged;
    private boolean deleted;
    private boolean updated;
    private boolean inserted;
    private int numCols;

    public Row(int n) {
        this.origVals = new Object[n];
        this.currentVals = new Object[n];
        this.colsChanged = new BitSet(n);
        this.numCols = n;
    }

    public Row(int n, Object[] objectArray) {
        this.origVals = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            this.origVals[n2] = objectArray[n2];
            ++n2;
        }
        this.currentVals = new Object[n];
        this.colsChanged = new BitSet(n);
        this.numCols = n;
    }

    public void initColumnObject(int n, Object object) {
        this.origVals[n - 1] = object;
    }

    public void setColumnObject(int n, Object object) {
        this.currentVals[n - 1] = object;
        this.setColUpdated(n - 1);
    }

    public Object getColumnObject(int n) throws SQLException {
        if (this.getColUpdated(n - 1)) {
            return this.currentVals[n - 1];
        }
        return this.origVals[n - 1];
    }

    public boolean getColUpdated(int n) {
        return this.colsChanged.get(n);
    }

    public void setDeleted() {
        this.deleted = true;
    }

    public boolean getDeleted() {
        return this.deleted;
    }

    public void clearDeleted() {
        this.deleted = false;
    }

    public void setInserted() {
        this.inserted = true;
    }

    public boolean getInserted() {
        return this.inserted;
    }

    public void clearInserted() {
        this.inserted = false;
    }

    public boolean getUpdated() {
        return this.updated;
    }

    public void setUpdated() {
        int n = 0;
        while (n < this.numCols) {
            if (this.getColUpdated(n)) {
                this.updated = true;
                return;
            }
            ++n;
        }
    }

    private void setColUpdated(int n) {
        this.colsChanged.set(n);
    }

    public void clearUpdated() {
        this.updated = false;
        int n = 0;
        while (n < this.numCols) {
            this.currentVals[n] = null;
            this.colsChanged.clear(n);
            ++n;
        }
    }

    public void moveCurrentToOrig() {
        int n = 0;
        while (n < this.numCols) {
            if (this.getColUpdated(n)) {
                this.origVals[n] = this.currentVals[n];
                this.currentVals[n] = null;
                this.colsChanged.clear(n);
            }
            ++n;
        }
        this.updated = false;
    }

    public BaseRow getCurrentRow() {
        return null;
    }
}

