/*
 * Decompiled with CFR 0.152.
 */
package javax.sql.rowset.serial;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Vector;
import javax.sql.rowset.serial.SerialArray;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.serial.SerialRef;
import javax.sql.rowset.serial.SerialStruct;

public class SQLOutputImpl
implements SQLOutput {
    private Vector attribs;
    private Map map;

    public SQLOutputImpl(Vector vector, Map map) {
        this.attribs = vector;
        this.map = map;
    }

    public void writeString(String string) throws SQLException {
        this.attribs.add(string);
    }

    public void writeBoolean(boolean bl) throws SQLException {
        this.attribs.add(new Boolean(bl));
    }

    public void writeByte(byte by) throws SQLException {
        this.attribs.add(new Byte(by));
    }

    public void writeShort(short s) throws SQLException {
        this.attribs.add(new Short(s));
    }

    public void writeInt(int n) throws SQLException {
        this.attribs.add(new Integer(n));
    }

    public void writeLong(long l) throws SQLException {
        this.attribs.add(new Long(l));
    }

    public void writeFloat(float f) throws SQLException {
        this.attribs.add(new Float(f));
    }

    public void writeDouble(double d) throws SQLException {
        this.attribs.add(new Double(d));
    }

    public void writeBigDecimal(BigDecimal bigDecimal) throws SQLException {
        this.attribs.add(bigDecimal);
    }

    public void writeBytes(byte[] byArray) throws SQLException {
        this.attribs.add(byArray);
    }

    public void writeDate(Date date) throws SQLException {
        this.attribs.add(date);
    }

    public void writeTime(Time time) throws SQLException {
        this.attribs.add(time);
    }

    public void writeTimestamp(Timestamp timestamp) throws SQLException {
        this.attribs.add(timestamp);
    }

    public void writeCharacterStream(Reader reader) throws SQLException {
    }

    public void writeAsciiStream(InputStream inputStream) throws SQLException {
    }

    public void writeBinaryStream(InputStream inputStream) throws SQLException {
    }

    public void writeObject(SQLData sQLData) throws SQLException {
        if (sQLData == null) {
            this.attribs.add(sQLData);
            return;
        }
        this.attribs.add(new SerialStruct(sQLData, this.map));
    }

    public void writeRef(Ref ref) throws SQLException {
        if (ref == null) {
            this.attribs.add(ref);
            return;
        }
        this.attribs.add(new SerialRef(ref));
    }

    public void writeBlob(Blob blob) throws SQLException {
        if (blob == null) {
            this.attribs.add(blob);
            return;
        }
        this.attribs.add(new SerialBlob(blob));
    }

    public void writeClob(Clob clob) throws SQLException {
        if (clob == null) {
            this.attribs.add(clob);
            return;
        }
        this.attribs.add(new SerialClob(clob));
    }

    public void writeStruct(Struct struct) throws SQLException {
        SerialStruct serialStruct = new SerialStruct(struct, this.map);
        this.attribs.add(serialStruct);
    }

    public void writeArray(Array array) throws SQLException {
        if (array == null) {
            this.attribs.add(array);
            return;
        }
        this.attribs.add(new SerialArray(array, this.map));
    }

    public void writeURL(URL uRL) throws SQLException {
        throw new SQLException("Operation not supported");
    }
}

