/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.sourceforge.squirrel_sql.fw.datasetviewer.CellImportExportInfo;
import net.sourceforge.squirrel_sql.fw.datasetviewer.CellImportExportInfoSaver;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.XmlRefomatter;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BinaryDisplayConverter;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextArea;
import net.sourceforge.squirrel_sql.fw.gui.TextPopupMenu;
import net.sourceforge.squirrel_sql.fw.gui.action.BaseAction;

public class PopupEditableIOPanel
extends JPanel
implements ActionListener {
    private final JTextArea _ta;
    private final JScrollPane scrollPane;
    private final ColumnDisplayDefinition _colDef;
    private MouseAdapter _lis;
    private final TextPopupMenu _popupMenu;
    private JTextField fileNameField;
    private JComboBox externalCommandCombo;
    private Object originalValue;
    private JComboBox radixList = null;
    private String previousRadixListItem = null;
    private JCheckBox showAscii = null;
    private boolean previousShowAscii;
    private BinaryOptionActionListener optionActionListener = new BinaryOptionActionListener();
    private final String TEMP_FILE_FLAG = "<temp file>";
    private final String FILE_REPLACE_FLAG = "%f";

    public PopupEditableIOPanel(ColumnDisplayDefinition colDef, Object value, boolean isEditable) {
        this.originalValue = value;
        this._popupMenu = new TextPopupMenu();
        this._colDef = colDef;
        this._ta = CellComponentFactory.getJTextArea(colDef, value);
        if (isEditable) {
            this._ta.setEditable(true);
            this._ta.setBackground(Color.yellow);
        } else {
            this._ta.setEditable(false);
        }
        this._ta.setLineWrap(true);
        this._ta.setWrapStyleWord(true);
        this.setLayout(new BorderLayout());
        JPanel displayPanel = new JPanel();
        displayPanel.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane(this._ta);
        this.scrollPane.setWheelScrollingEnabled(true);
        displayPanel.add((Component)this.scrollPane, "Center");
        if (CellComponentFactory.useBinaryEditingPanel(colDef)) {
            String[] radixListData = new String[]{"Hex", "Decimal", "Octal", "Binary"};
            this.radixList = new JComboBox<String>(radixListData);
            this.radixList.addActionListener(this.optionActionListener);
            this.previousRadixListItem = "Hex";
            this.showAscii = new JCheckBox();
            this.previousShowAscii = false;
            this.showAscii.addActionListener(this.optionActionListener);
            JPanel displayControlsPanel = new JPanel();
            displayControlsPanel.add(new JLabel("Number Base:"));
            displayControlsPanel.add(this.radixList);
            displayControlsPanel.add(new JLabel("    "));
            displayControlsPanel.add(this.showAscii);
            displayControlsPanel.add(new JLabel("Show ASCII as chars"));
            displayPanel.add((Component)displayControlsPanel, "South");
        }
        this.add((Component)displayPanel, "Center");
        if (CellComponentFactory.canDoFileIO(colDef)) {
            this.add((Component)this.exportImportPanel(isEditable), "South");
        }
        this._popupMenu.add(new LineWrapAction());
        this._popupMenu.add(new WordWrapAction());
        this._popupMenu.add(new XMLReformatAction());
        this._popupMenu.setTextComponent(this._ta);
    }

    private JPanel exportImportPanel(boolean isEditable) {
        JPanel eiPanel = new JPanel();
        eiPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.gridx = 0;
        gbc.gridy = 0;
        eiPanel.add((Component)new JLabel("Use File: "), gbc);
        this.fileNameField = new JTextField("<temp file>", 19);
        ++gbc.gridx;
        eiPanel.add((Component)this.fileNameField, gbc);
        JButton browseButton = new JButton("Browse");
        browseButton.setActionCommand("browse");
        browseButton.addActionListener(this);
        ++gbc.gridx;
        eiPanel.add((Component)browseButton, gbc);
        JButton exportButton = new JButton("Export");
        exportButton.setActionCommand("export");
        exportButton.addActionListener(this);
        ++gbc.gridx;
        eiPanel.add((Component)exportButton, gbc);
        if (!isEditable) {
            return eiPanel;
        }
        JButton importButton = new JButton("Import");
        importButton.setActionCommand("import");
        importButton.addActionListener(this);
        ++gbc.gridx;
        eiPanel.add((Component)importButton, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        eiPanel.add((Component)new JLabel("With command:"), gbc);
        ++gbc.gridx;
        this.externalCommandCombo = new JComboBox<String>(CellImportExportInfoSaver.getInstance().getCmdList());
        this.externalCommandCombo.setSelectedIndex(-1);
        this.externalCommandCombo.setEditable(true);
        this.externalCommandCombo.setPrototypeDisplayValue("xxxxxxxxxxxxxxxxxxxxxxxxxx");
        eiPanel.add((Component)this.externalCommandCombo, gbc);
        JButton externalCommandButton = new JButton("Execute");
        externalCommandButton.setActionCommand("execute");
        externalCommandButton.addActionListener(this);
        ++gbc.gridx;
        eiPanel.add((Component)externalCommandButton, gbc);
        JButton applyButton = new JButton("Apply File & Cmd");
        applyButton.setActionCommand("apply");
        applyButton.addActionListener(this);
        ++gbc.gridx;
        gbc.gridwidth = 2;
        eiPanel.add((Component)applyButton, gbc);
        gbc.gridwidth = 1;
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 0;
        eiPanel.add((Component)new JLabel("(In command, the string %f is replaced by the file name when Executed.)"), gbc);
        CellImportExportInfo info = CellImportExportInfoSaver.getInstance().get(this._colDef.getFullTableColumnName());
        if (info != null) {
            this.fileNameField.setText(info.getFileName());
            this.externalCommandCombo.getEditor().setItem(info.getCommand());
        }
        return eiPanel;
    }

    public Object getObject(StringBuffer messageBuffer) {
        String text = null;
        try {
            text = this.getTextAreaCannonicalForm();
        }
        catch (Exception e) {
            messageBuffer.append("Failed to convert binary text; error was:\n" + e.getMessage());
            return null;
        }
        return CellComponentFactory.validateAndConvertInPopup(this._colDef, this.originalValue, text, messageBuffer);
    }

    public void requestFocus() {
        this._ta.requestFocus();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("browse")) {
            JFileChooser chooser = new JFileChooser();
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                try {
                    this.fileNameField.setText(chooser.getSelectedFile().getCanonicalPath());
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this, "Error getting full path name for selected file", "File Chooser Error", 0);
                }
            }
        } else if (e.getActionCommand().equals("apply")) {
            if (this.fileNameField.getText() != null && this.fileNameField.getText().equals("<temp file>") && (this.externalCommandCombo.getEditor().getItem() == null || ((String)this.externalCommandCombo.getEditor().getItem()).length() == 0)) {
                CellImportExportInfoSaver.remove(this._colDef.getFullTableColumnName());
            } else {
                CellImportExportInfoSaver.getInstance().save(this._colDef.getFullTableColumnName(), this.fileNameField.getText(), (String)this.externalCommandCombo.getEditor().getItem());
            }
        } else if (e.getActionCommand().equals("import")) {
            File file;
            if (this.fileNameField.getText() == null || this.fileNameField.getText().equals("<temp file>")) {
                JOptionPane.showMessageDialog(this, "You must select an existing file to import data from.", "No File Selected", 0);
                return;
            }
            if (this.fileNameField.getText() == null) {
                this.fileNameField.setText("");
            }
            if (!((file = new File(this.fileNameField.getText())).exists() && file.isFile() && file.canRead())) {
                JOptionPane.showMessageDialog(this, "File " + this.fileNameField.getText() + " does not exist,\n" + "or is not a readable, normal file.\n" + "Please enter a valid file name or use Browse to select a file.", "File Name Error", 0);
                return;
            }
            this.importData(file);
            CellImportExportInfoSaver.getInstance().save(this._colDef.getFullTableColumnName(), this.fileNameField.getText(), (String)this.externalCommandCombo.getEditor().getItem());
        } else {
            FileOutputStream outStream;
            File file;
            String canonicalFilePathName = this.fileNameField.getText();
            if (this.fileNameField.getText() == null || this.fileNameField.getText().equals("")) {
                JOptionPane.showMessageDialog(this, "No file name given for export.\nPlease enter a file name  or use Browse before clicking Export.", "Export Error", 0);
                return;
            }
            if (this.fileNameField.getText().equals("<temp file>")) {
                try {
                    file = File.createTempFile("squirrel", ".tmp");
                    canonicalFilePathName = file.getCanonicalPath();
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this, "Cannot create temp file..\nError was:\n" + ex.getMessage(), "Export Error", 0);
                    return;
                }
            }
            file = new File(this.fileNameField.getText());
            try {
                canonicalFilePathName = file.getCanonicalPath();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Cannot access file name " + this.fileNameField.getText() + ".\n" + "Aborting export.", "Export Error", 0);
                return;
            }
            if (file.exists()) {
                if (!file.isFile()) {
                    JOptionPane.showMessageDialog(this, "File is not a normal file.\nCannot do export to a directory or system file.", "Export Error", 0);
                    return;
                }
                if (!file.canWrite()) {
                    JOptionPane.showMessageDialog(this, "File is not writeable.\nChange file permissions or select a differnt file for export.", "Export Error", 0);
                    return;
                }
                int option = JOptionPane.showConfirmDialog(this, "File " + canonicalFilePathName + " already exists.\n\nDo you wish to overwrite this file?", "File Overwrite Warning", 0);
                if (option != 0) {
                    return;
                }
            } else {
                try {
                    if (!file.createNewFile()) {
                        JOptionPane.showMessageDialog(this, "Failed to create file " + canonicalFilePathName + ".\n" + "Change file name or select a differnt file for export.", "Export Error", 0);
                        return;
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this, "Cannot open file " + canonicalFilePathName + ".\nError was:\n" + ex.getMessage(), "Export Error", 0);
                    return;
                }
            }
            try {
                outStream = new FileOutputStream(file);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Cannot find file " + canonicalFilePathName + "\n" + "Check file name and re-try export.", "Export Error", 0);
                return;
            }
            if (!this.fileNameField.getText().equals("<temp file>") || (String)this.externalCommandCombo.getEditor().getItem() != null && ((String)this.externalCommandCombo.getEditor().getItem()).length() > 0) {
                String commandString = null;
                if (this.externalCommandCombo != null) {
                    commandString = (String)this.externalCommandCombo.getEditor().getItem();
                }
                CellImportExportInfoSaver.getInstance().save(this._colDef.getFullTableColumnName(), this.fileNameField.getText(), commandString);
            }
            if (e.getActionCommand().equals("export")) {
                if (this.exportData(file, outStream, canonicalFilePathName)) {
                    JOptionPane.showMessageDialog(this, "Data Successfully exported to file " + canonicalFilePathName + ".\n", "Export Success", 1);
                }
            } else if (e.getActionCommand().equals("execute")) {
                int option;
                int commandResult;
                int index;
                if ((String)this.externalCommandCombo.getEditor().getItem() == null || ((String)this.externalCommandCombo.getEditor().getItem()).length() == 0) {
                    JOptionPane.showMessageDialog(this, "Cannot execute a null command.\nPlease enter a command in the Command field before clicking on Execute.", "Execute Error", 0);
                    return;
                }
                String command = (String)this.externalCommandCombo.getEditor().getItem();
                while ((index = command.indexOf("%f")) >= 0) {
                    command = command.substring(0, index) + canonicalFilePathName + command.substring(index + "%f".length());
                }
                if (!this.exportData(file, outStream, canonicalFilePathName)) {
                    return;
                }
                try {
                    Process cmdProcess = Runtime.getRuntime().exec(command);
                    commandResult = cmdProcess.waitFor();
                    BufferedReader err = new BufferedReader(new InputStreamReader(cmdProcess.getErrorStream()));
                    String errMsg = err.readLine();
                    if (errMsg != null) {
                        throw new IOException("text on error stream from command starting with:\n" + errMsg);
                    }
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this, "Error while executing command.\nThe command was:\n  " + command + "\nThe error was:\n " + ex.getMessage(), "Execute Error", 0);
                    return;
                }
                if (commandResult != 0 && (option = JOptionPane.showConfirmDialog(this, "The convention for command returns is that 0 means success, but this command returned " + commandResult + ".\nDo you wish to import the file contents anyway?", "File Overwrite Warning", 0)) != 0) {
                    return;
                }
                this.importData(file);
                file.delete();
            }
        }
    }

    private void importData(File file) {
        FileInputStream inStream;
        String canonicalFilePathName = this.fileNameField.getText();
        try {
            inStream = new FileInputStream(file);
            canonicalFilePathName = file.getCanonicalPath();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "There was an error opening file " + canonicalFilePathName + ".\nThe error was:\n" + ex.getMessage(), "File Open Error", 0);
            return;
        }
        try {
            String replacementText = CellComponentFactory.importObject(this._colDef, inStream);
            if (this.radixList != null && (!this.radixList.getSelectedItem().equals("Hex") || this.showAscii.isSelected())) {
                int base = 16;
                if (this.radixList.getSelectedItem().equals("Decimal")) {
                    base = 10;
                } else if (this.radixList.getSelectedItem().equals("Octal")) {
                    base = 8;
                } else if (this.radixList.getSelectedItem().equals("Binary")) {
                    base = 2;
                }
                Byte[] bytes = BinaryDisplayConverter.convertToBytes(replacementText, 16, false);
                replacementText = BinaryDisplayConverter.convertToString(bytes, base, this.showAscii.isSelected());
            }
            ((RestorableJTextArea)this._ta).updateText(replacementText);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "There was an error while reading file " + canonicalFilePathName + ".\nThe error was:\n" + ex.getMessage(), "Import Error", 0);
            return;
        }
        try {
            inStream.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private boolean exportData(File file, FileOutputStream outStream, String canonicalFilePathName) {
        try {
            CellComponentFactory.exportObject(this._colDef, outStream, this.getTextAreaCannonicalForm());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "There was an error while writing file " + canonicalFilePathName + ".\nThe error was:\n" + ex.getMessage(), "Export Error", 0);
            return false;
        }
        return true;
    }

    public void addNotify() {
        super.addNotify();
        if (this._lis == null) {
            this._lis = new MouseAdapter(){

                public void mousePressed(MouseEvent evt) {
                    if (evt.isPopupTrigger()) {
                        PopupEditableIOPanel.this._popupMenu.show(evt);
                    }
                }

                public void mouseReleased(MouseEvent evt) {
                    if (evt.isPopupTrigger()) {
                        PopupEditableIOPanel.this._popupMenu.show(evt);
                    }
                }
            };
            this._ta.addMouseListener(this._lis);
        }
    }

    public void removeNotify() {
        super.removeNotify();
        if (this._lis != null) {
            this._ta.removeMouseListener(this._lis);
            this._lis = null;
        }
    }

    private String getTextAreaCannonicalForm() {
        if (this._ta.getText() == null || this._ta.getText().equals("<null>") || this._ta.getText().length() == 0) {
            return this._ta.getText();
        }
        if (this.radixList == null || this.radixList.getSelectedItem().equals("Hex") && !this.showAscii.isSelected()) {
            return this._ta.getText();
        }
        int base = 16;
        if (this.radixList.getSelectedItem().equals("Decimal")) {
            base = 10;
        } else if (this.radixList.getSelectedItem().equals("Octal")) {
            base = 8;
        } else if (this.radixList.getSelectedItem().equals("Binary")) {
            base = 2;
        }
        Byte[] bytes = BinaryDisplayConverter.convertToBytes(this._ta.getText(), base, this.showAscii.isSelected());
        return BinaryDisplayConverter.convertToString(bytes, 16, false);
    }

    private class XMLReformatAction
    extends BaseAction {
        XMLReformatAction() {
            super("Reformat XML");
        }

        public void actionPerformed(ActionEvent evt) {
            if (PopupEditableIOPanel.this._ta != null) {
                PopupEditableIOPanel.this._ta.setText(XmlRefomatter.reformatXml(PopupEditableIOPanel.this._ta.getText()));
            }
        }
    }

    private class WordWrapAction
    extends BaseAction {
        WordWrapAction() {
            super("Wrap on Word on/off");
        }

        public void actionPerformed(ActionEvent evt) {
            if (PopupEditableIOPanel.this._ta != null) {
                PopupEditableIOPanel.this._ta.setWrapStyleWord(!PopupEditableIOPanel.this._ta.getWrapStyleWord());
            }
        }
    }

    private class LineWrapAction
    extends BaseAction {
        LineWrapAction() {
            super("Wrap Lines on/off");
        }

        public void actionPerformed(ActionEvent evt) {
            if (PopupEditableIOPanel.this._ta != null) {
                PopupEditableIOPanel.this._ta.setLineWrap(!PopupEditableIOPanel.this._ta.getLineWrap());
            }
        }
    }

    class BinaryOptionActionListener
    implements ActionListener {
        BinaryOptionActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int base = 16;
            if (PopupEditableIOPanel.this.previousRadixListItem.equals("Decimal")) {
                base = 10;
            } else if (PopupEditableIOPanel.this.previousRadixListItem.equals("Octal")) {
                base = 8;
            } else if (PopupEditableIOPanel.this.previousRadixListItem.equals("Binary")) {
                base = 2;
            }
            Byte[] bytes = BinaryDisplayConverter.convertToBytes(PopupEditableIOPanel.this._ta.getText(), base, PopupEditableIOPanel.this.previousShowAscii);
            base = 16;
            if (PopupEditableIOPanel.this.radixList.getSelectedItem().equals("Decimal")) {
                base = 10;
            } else if (PopupEditableIOPanel.this.radixList.getSelectedItem().equals("Octal")) {
                base = 8;
            } else if (PopupEditableIOPanel.this.radixList.getSelectedItem().equals("Binary")) {
                base = 2;
            }
            ((RestorableJTextArea)PopupEditableIOPanel.this._ta).updateText(BinaryDisplayConverter.convertToString(bytes, base, PopupEditableIOPanel.this.showAscii.isSelected()));
            PopupEditableIOPanel.this.previousRadixListItem = (String)PopupEditableIOPanel.this.radixList.getSelectedItem();
            PopupEditableIOPanel.this.previousShowAscii = PopupEditableIOPanel.this.showAscii.isSelected();
        }
    }
}

