/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import net.sourceforge.squirrel_sql.fw.datasetviewer.CellDataPopup;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerEditableTablePanel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;

public class RowDataInputFrame
extends JInternalFrame
implements ActionListener {
    DataSetViewerEditableTablePanel _caller;
    RowDataJTable table;

    public RowDataInputFrame(ColumnDisplayDefinition[] colDefs, Object[] initialValues, DataSetViewerEditableTablePanel caller) {
        super("Input New Row Data", true, true, false, true);
        Container pane = this.getContentPane();
        this._caller = caller;
        pane.setLayout(new BorderLayout());
        this.table = new RowDataJTable(colDefs, initialValues);
        Dimension tableDim = this.table.getPreferredSize();
        tableDim.setSize(tableDim.getWidth(), tableDim.getHeight() + 15.0);
        this.table.setPreferredScrollableViewportSize(tableDim);
        JScrollPane scrollPane = new JScrollPane(this.table);
        JPanel rowHeaderPanel = new JPanel();
        rowHeaderPanel.setLayout(new BorderLayout());
        JTextArea r1 = new JTextArea("Data", 1, 10);
        r1.setBackground(Color.LIGHT_GRAY);
        r1.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        r1.setEditable(false);
        rowHeaderPanel.add((Component)r1, "North");
        JTextArea r2 = new JTextArea("\nColumn\nDescription\n", 4, 10);
        r2.setBackground(Color.LIGHT_GRAY);
        r2.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        r2.setEditable(false);
        rowHeaderPanel.add((Component)r2, "Center");
        scrollPane.setRowHeaderView(rowHeaderPanel);
        pane.add((Component)scrollPane, "North");
        JPanel buttonPanel = new JPanel();
        JButton insertButton = new JButton("Insert");
        buttonPanel.add(insertButton);
        insertButton.setActionCommand("insert");
        insertButton.addActionListener(this);
        JButton cancelButton = new JButton("Cancel");
        buttonPanel.add(cancelButton);
        cancelButton.setActionCommand("cancel");
        cancelButton.addActionListener(this);
        pane.add((Component)buttonPanel, "South");
        this.setDefaultCloseOperation(2);
        this.pack();
        this.show();
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("cancel")) {
            this.setVisible(false);
            this.dispose();
            return;
        }
        if (!e.getActionCommand().equals("insert")) {
            return;
        }
        if (this.table.isEditing()) {
            int col = this.table.getEditingColumn();
            this.table.getCellEditor(0, col).stopCellEditing();
        }
        Object[] rowData = new Object[this.table.getModel().getColumnCount()];
        for (int i = 0; i < this.table.getModel().getColumnCount(); ++i) {
            rowData[i] = this.table.getValueAt(0, i);
        }
        if (this._caller.insertRow(rowData) == null) {
            this.setVisible(false);
            this.dispose();
        }
    }

    class RowDataDescriptionRenderer
    implements TableCellRenderer {
        RowDataDescriptionRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JTextArea ta = new JTextArea((String)value, 4, 20);
            ta.setBackground(Color.LIGHT_GRAY);
            return ta;
        }
    }

    class RowDataModel
    extends DefaultTableModel {
        protected RowDataModel(ColumnDisplayDefinition[] colDefs, Object[] initalValues) {
            Object[] colNames = new String[colDefs.length];
            Object[][] rowData = new Object[2][colDefs.length];
            for (int i = 0; i < colDefs.length; ++i) {
                colNames[i] = colDefs[i].getLabel();
                rowData[0][i] = initalValues[i];
                rowData[1][i] = colDefs[i].getSqlTypeName() + "\n" + (colDefs[i].isNullable() ? "nullable" : "not nullable") + "\n" + "mx size=" + colDefs[i].getPrecision() + "\n" + "scale=" + colDefs[i].getScale();
            }
            this.setDataVector(rowData, colNames);
        }
    }

    class RowDataJTable
    extends JTable {
        private ColumnDisplayDefinition[] _colDefs = null;

        protected RowDataJTable(ColumnDisplayDefinition[] colDefs, Object[] initalValues) {
            super(new RowDataModel(colDefs, initalValues));
            int i;
            String data = "THE QUICK BROWN FOX JUMPED OVER THE LAZY DOG";
            int _multiplier = this.getFontMetrics(this.getFont()).stringWidth("THE QUICK BROWN FOX JUMPED OVER THE LAZY DOG") / "THE QUICK BROWN FOX JUMPED OVER THE LAZY DOG".length();
            DefaultTableColumnModel cm = new DefaultTableColumnModel();
            for (i = 0; i < colDefs.length; ++i) {
                ColumnDisplayDefinition colDef = colDefs[i];
                int colWidth = colDef.getDisplayWidth() * _multiplier;
                if (colWidth > 50 * _multiplier) {
                    colWidth = 50 * _multiplier;
                }
                TableColumn col = new TableColumn(i, colWidth, CellComponentFactory.getTableCellRenderer(colDefs[i]), null);
                col.setHeaderValue(colDef.getLabel());
                cm.addColumn(col);
            }
            this.setColumnModel(cm);
            this._colDefs = colDefs;
            for (i = 0; i < colDefs.length; ++i) {
                cm.getColumn(i).setCellEditor(CellComponentFactory.getInCellEditor(this, this._colDefs[i]));
            }
            this.setRowHeight(1, 60);
            this.setRowSelectionAllowed(false);
            this.setColumnSelectionAllowed(false);
            this.setCellSelectionEnabled(true);
            this.getTableHeader().setResizingAllowed(true);
            this.getTableHeader().setReorderingAllowed(true);
            this.setAutoCreateColumnsFromModel(false);
            this.setAutoResizeMode(0);
            MouseAdapter m = new MouseAdapter(this, RowDataInputFrame.this){
                private final /* synthetic */ RowDataInputFrame val$this$0;
                private final /* synthetic */ RowDataJTable this$1;
                {
                    this.this$1 = this$1;
                    this.val$this$0 = val$this$0;
                }

                public void mousePressed(MouseEvent evt) {
                    if (!evt.isPopupTrigger() && evt.getClickCount() == 2) {
                        Point pt = evt.getPoint();
                        int col = this.this$1.columnAtPoint(pt);
                        CellDataPopup.showDialog(this.this$1, RowDataJTable.access$000(this.this$1)[col], evt, true);
                    }
                }

                public void mouseReleased(MouseEvent evt) {
                    if (evt.isPopupTrigger()) {
                        // empty if block
                    }
                }
            };
            this.addMouseListener(m);
        }

        public boolean isCellEditable(int row, int col) {
            if (row > 0) {
                return false;
            }
            return CellComponentFactory.isEditableInCell(this._colDefs[row], this.getValueAt(row, col));
        }

        public TableCellRenderer getCellRenderer(int row, int column) {
            if (row == 0) {
                return CellComponentFactory.getTableCellRenderer(this._colDefs[column]);
            }
            return new RowDataDescriptionRenderer();
        }

        public void setValueAt(Object newValueString, int row, int col) {
            if (!(newValueString instanceof String)) {
                super.setValueAt(newValueString, row, col);
                return;
            }
            StringBuffer messageBuffer = new StringBuffer();
            ColumnDisplayDefinition colDef = this._colDefs[col];
            Object newValueObject = CellComponentFactory.validateAndConvert(colDef, this.getValueAt(row, col), (String)newValueString, messageBuffer);
            if (messageBuffer.length() > 0) {
                messageBuffer.insert(0, "The given text cannot be converted into the internal object.\nThe database has not been changed.\nThe conversion error was:\n");
                JOptionPane.showMessageDialog(this, messageBuffer, "Conversion Error", 0);
            } else {
                super.setValueAt(newValueObject, row, col);
            }
        }

        static /* synthetic */ ColumnDisplayDefinition[] access$000(RowDataJTable x0) {
            return x0._colDefs;
        }
    }
}

