/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.CellDataPopup;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.BinaryDisplayConverter;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DefaultColumnRenderer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IRestorableTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextArea;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextField;

public class DataTypeBinary
implements IDataTypeComponent {
    private ColumnDisplayDefinition _colDef;
    private boolean _isNullable;
    private int _scale;
    private JTable _table;
    private IRestorableTextComponent _textComponent;
    private DefaultColumnRenderer _renderer = DefaultColumnRenderer.getInstance();

    public DataTypeBinary(JTable table, ColumnDisplayDefinition colDef) {
        this._table = table;
        this._colDef = colDef;
        this._isNullable = colDef.isNullable();
        this._scale = colDef.getScale();
    }

    public String getClassName() {
        return "[Ljava.lang.Byte";
    }

    public boolean areEqual(Object obj1, Object obj2) {
        Byte[] b1 = (Byte[])obj1;
        Byte[] b2 = (Byte[])obj2;
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    public String renderObject(Object value) {
        Byte[] useValue;
        if (value instanceof String) {
            byte[] bytes = ((String)value).getBytes();
            useValue = new Byte[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                useValue[i] = new Byte(bytes[i]);
            }
        } else {
            useValue = (Byte[])value;
        }
        return (String)this._renderer.renderObject(BinaryDisplayConverter.convertToString(useValue, 16, false));
    }

    public boolean isEditableInCell(Object originalValue) {
        return true;
    }

    public boolean needToReRead(Object originalValue) {
        return false;
    }

    public JTextField getJTextField() {
        this._textComponent = new RestorableJTextField();
        ((RestorableJTextField)this._textComponent).addKeyListener(new KeyTextHandler());
        ((RestorableJTextField)this._textComponent).addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    MouseEvent tableEvt = SwingUtilities.convertMouseEvent((RestorableJTextField)DataTypeBinary.this._textComponent, evt, DataTypeBinary.this._table);
                    CellDataPopup.showDialog(DataTypeBinary.this._table, DataTypeBinary.this._colDef, tableEvt, true);
                }
            }
        });
        return (JTextField)((Object)this._textComponent);
    }

    public Object validateAndConvert(String value, Object originalValue, StringBuffer messageBuffer) {
        if (value == null || value.equals("<null>") || value.equals("")) {
            return null;
        }
        try {
            Byte[] obj = BinaryDisplayConverter.convertToBytes(value, 16, false);
            return obj;
        }
        catch (Exception e) {
            messageBuffer.append(e.toString() + "\n");
            return null;
        }
    }

    public boolean useBinaryEditingPanel() {
        return true;
    }

    public boolean isEditableInPopup(Object originalValue) {
        return true;
    }

    public JTextArea getJTextArea(Object value) {
        this._textComponent = new RestorableJTextArea();
        ((RestorableJTextArea)this._textComponent).setText(this.renderObject(value));
        ((RestorableJTextArea)this._textComponent).addKeyListener(new KeyTextHandler());
        return (RestorableJTextArea)this._textComponent;
    }

    public Object validateAndConvertInPopup(String value, Object originalValue, StringBuffer messageBuffer) {
        return this.validateAndConvert(value, originalValue, messageBuffer);
    }

    public Object readResultSet(ResultSet rs, int index, boolean limitDataRead) throws SQLException {
        byte[] data = rs.getBytes(index);
        if (rs.wasNull()) {
            return null;
        }
        Byte[] internal = new Byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            internal[i] = new Byte(data[i]);
        }
        return internal;
    }

    public String getWhereClauseValue(Object value) {
        if (value == null || value.toString() == null || value.toString().length() == 0) {
            return this._colDef.getLabel() + " IS NULL";
        }
        return null;
    }

    public void setPreparedStatementValue(PreparedStatement pstmt, Object value, int position) throws SQLException {
        if (value == null) {
            pstmt.setNull(position, this._colDef.getSqlType());
        } else {
            Byte[] internal = (Byte[])value;
            byte[] dbValue = new byte[internal.length];
            for (int i = 0; i < internal.length; ++i) {
                dbValue[i] = internal[i];
            }
            pstmt.setBytes(position, dbValue);
        }
    }

    public Object getDefaultValue(String dbDefaultValue) {
        if (dbDefaultValue != null) {
            StringBuffer mbuf = new StringBuffer();
            Object newObject = this.validateAndConvert(dbDefaultValue, null, mbuf);
            if (mbuf.length() == 0) {
                return newObject;
            }
        }
        if (this._isNullable) {
            return null;
        }
        return new Byte[0];
    }

    public boolean canDoFileIO() {
        return true;
    }

    public String importObject(FileInputStream inStream) throws IOException {
        int fileSize = inStream.available();
        byte[] buf = new byte[fileSize];
        int count = inStream.read(buf);
        if (count != fileSize) {
            throw new IOException("Could read only " + count + " bytes from a total file size of " + fileSize + ". Import failed.");
        }
        Byte[] bBytes = new Byte[count];
        for (int i = 0; i < count; ++i) {
            bBytes[i] = new Byte(buf[i]);
        }
        return BinaryDisplayConverter.convertToString(bBytes, 16, false);
    }

    public void exportObject(FileOutputStream outStream, String text) throws IOException {
        Byte[] bBytes = BinaryDisplayConverter.convertToBytes(text, 16, false);
        StringBuffer messageBuffer = new StringBuffer();
        this.validateAndConvertInPopup(text, null, messageBuffer);
        if (messageBuffer.length() > 0) {
            throw new IOException(new String(messageBuffer));
        }
        byte[] bytes = new byte[bBytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = bBytes[i];
        }
        outStream.write(bytes);
        outStream.flush();
        outStream.close();
    }

    private class KeyTextHandler
    extends KeyAdapter {
        private KeyTextHandler() {
        }

        public void keyTyped(KeyEvent e) {
            char c = e.getKeyChar();
            JTextComponent _theComponent = (JTextComponent)((Object)DataTypeBinary.this._textComponent);
            String text = _theComponent.getText();
            if (c == '\t' || c == '\n') {
                ((IRestorableTextComponent)((Object)_theComponent)).updateText(text.replaceAll("" + c, ""));
                _theComponent.getToolkit().beep();
                e.consume();
            }
            if (DataTypeBinary.this._isNullable) {
                if (text.equals("<null>")) {
                    if (c == '\b' || c == '\u007f') {
                        DataTypeBinary.this._textComponent.restoreText();
                        e.consume();
                    } else {
                        DataTypeBinary.this._textComponent.updateText("");
                    }
                } else if ((c == '\b' || c == '\u007f') && text.length() <= 1) {
                    DataTypeBinary.this._textComponent.updateText("<null>");
                    e.consume();
                }
            } else if (text.length() == 0 && c == '\b' || c == '\u007f') {
                DataTypeBinary.this._textComponent.restoreText();
                e.consume();
            }
        }
    }
}

