/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.CellDataPopup;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.ClobDescriptor;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DTProperties;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DefaultColumnRenderer;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IRestorableTextComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextArea;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextField;
import net.sourceforge.squirrel_sql.fw.gui.IntegerField;
import net.sourceforge.squirrel_sql.fw.gui.OkJPanel;
import net.sourceforge.squirrel_sql.fw.gui.ReadTypeCombo;
import net.sourceforge.squirrel_sql.fw.gui.RightLabel;

public class DataTypeClob
implements IDataTypeComponent {
    private ColumnDisplayDefinition _colDef;
    private boolean _isNullable;
    private JTable _table;
    private IRestorableTextComponent _textComponent;
    private DefaultColumnRenderer _renderer = DefaultColumnRenderer.getInstance();
    private static final String thisClassName = "net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.DataTypeClob";
    private static int LARGE_COLUMN_DEFAULT_READ_LENGTH = 255;
    private static boolean propertiesAlreadyLoaded = false;
    private static boolean _readClobs = false;
    private static boolean _readCompleteClobs = false;
    private static int _readClobsSize = LARGE_COLUMN_DEFAULT_READ_LENGTH;
    private static boolean _makeNewlinesVisibleInCell = true;

    public DataTypeClob(JTable table, ColumnDisplayDefinition colDef) {
        this._table = table;
        this._colDef = colDef;
        this._isNullable = colDef.isNullable();
        DataTypeClob.loadProperties();
    }

    private static void loadProperties() {
        if (!propertiesAlreadyLoaded) {
            _readClobs = false;
            String readClobsString = DTProperties.get(thisClassName, "readClobs");
            if (readClobsString != null && readClobsString.equals("true")) {
                _readClobs = true;
            }
            _readCompleteClobs = false;
            String readCompleteClobsString = DTProperties.get(thisClassName, "readCompleteClobs");
            if (readCompleteClobsString != null && readCompleteClobsString.equals("true")) {
                _readClobs = true;
            }
            _readClobsSize = LARGE_COLUMN_DEFAULT_READ_LENGTH;
            String readClobsSizeString = DTProperties.get(thisClassName, "readClobsSize");
            if (readClobsSizeString != null) {
                _readClobsSize = Integer.parseInt(readClobsSizeString);
            }
            _makeNewlinesVisibleInCell = true;
            String makeNewlinesVisibleString = DTProperties.get(thisClassName, "makeNewlinesVisibleInCell");
            if (makeNewlinesVisibleString != null && makeNewlinesVisibleString.equals("false")) {
                _makeNewlinesVisibleInCell = false;
            }
            propertiesAlreadyLoaded = true;
        }
    }

    public String getClassName() {
        return "net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.ClobDescriptor";
    }

    public boolean areEqual(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 != null) {
            return ((ClobDescriptor)obj1).equals((ClobDescriptor)obj2);
        }
        return ((ClobDescriptor)obj2).equals((ClobDescriptor)obj1);
    }

    public String renderObject(Object value) {
        String text = (String)this._renderer.renderObject(value);
        if (_makeNewlinesVisibleInCell) {
            text = text.replaceAll("\n", "/\\n");
        }
        return text;
    }

    public boolean isEditableInCell(Object originalValue) {
        ClobDescriptor cdesc = (ClobDescriptor)originalValue;
        if (this.wholeClobRead(cdesc)) {
            return cdesc == null || cdesc.getData() == null || cdesc.getData().indexOf(10) <= -1;
        }
        return false;
    }

    public boolean needToReRead(Object originalValue) {
        return false;
    }

    public JTextField getJTextField() {
        this._textComponent = new RestorableJTextField();
        ((RestorableJTextField)this._textComponent).addKeyListener(new KeyTextHandler());
        ((RestorableJTextField)this._textComponent).addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    MouseEvent tableEvt = SwingUtilities.convertMouseEvent((RestorableJTextField)DataTypeClob.this._textComponent, evt, DataTypeClob.this._table);
                    CellDataPopup.showDialog(DataTypeClob.this._table, DataTypeClob.this._colDef, tableEvt, true);
                }
            }
        });
        return (JTextField)((Object)this._textComponent);
    }

    public Object validateAndConvert(String value, Object originalValue, StringBuffer messageBuffer) {
        ClobDescriptor cdesc;
        if (value.equals("<null>")) {
            return null;
        }
        if (originalValue == null) {
            cdesc = new ClobDescriptor(null, value, true, true, 0);
        } else {
            cdesc = (ClobDescriptor)originalValue;
            cdesc = new ClobDescriptor(cdesc.getClob(), value, true, true, 0);
        }
        return cdesc;
    }

    public boolean useBinaryEditingPanel() {
        return false;
    }

    public boolean isEditableInPopup(Object originalValue) {
        return this.wholeClobRead((ClobDescriptor)originalValue);
    }

    public JTextArea getJTextArea(Object value) {
        this._textComponent = new RestorableJTextArea();
        ((RestorableJTextArea)this._textComponent).setText((String)this._renderer.renderObject(value));
        ((RestorableJTextArea)this._textComponent).addKeyListener(new KeyTextHandler());
        return (RestorableJTextArea)this._textComponent;
    }

    public Object validateAndConvertInPopup(String value, Object originalValue, StringBuffer messageBuffer) {
        return this.validateAndConvert(value, originalValue, messageBuffer);
    }

    private boolean wholeClobRead(ClobDescriptor cdesc) {
        if (cdesc == null) {
            return true;
        }
        if (cdesc.getWholeClobRead()) {
            return true;
        }
        try {
            String data = cdesc.getClob().getSubString(1L, (int)cdesc.getClob().length());
            cdesc.setClobRead(true);
            cdesc.setData(data);
            cdesc.setWholeClobRead(true);
            cdesc.setUserSetClobLimit(0);
            return true;
        }
        catch (Exception ex) {
            cdesc.setClobRead(false);
            cdesc.setWholeClobRead(false);
            cdesc.setData(null);
            return false;
        }
    }

    public Object readResultSet(ResultSet rs, int index, boolean limitDataRead) throws SQLException {
        Clob clob = rs.getClob(index);
        if (rs.wasNull()) {
            return null;
        }
        if (_readClobs) {
            int len;
            String clobData = null;
            if (clob != null && (len = (int)clob.length()) > 0) {
                int charsToRead = len;
                if (!_readCompleteClobs) {
                    charsToRead = _readClobsSize;
                }
                if (charsToRead > len) {
                    charsToRead = len;
                }
                clobData = clob.getSubString(1L, charsToRead);
            }
            boolean wholeClobRead = false;
            if (_readCompleteClobs || clobData.length() < _readClobsSize) {
                wholeClobRead = true;
            }
            return new ClobDescriptor(clob, clobData, true, wholeClobRead, _readClobsSize);
        }
        return new ClobDescriptor(clob, null, false, false, 0);
    }

    public String getWhereClauseValue(Object value) {
        if (value == null || ((ClobDescriptor)value).getData() == null) {
            return this._colDef.getLabel() + " IS NULL";
        }
        return "";
    }

    public void setPreparedStatementValue(PreparedStatement pstmt, Object value, int position) throws SQLException {
        if (value == null || ((ClobDescriptor)value).getData() == null) {
            pstmt.setNull(position, this._colDef.getSqlType());
        } else {
            ClobDescriptor cdesc = (ClobDescriptor)value;
            pstmt.setCharacterStream(position, (Reader)new StringReader(cdesc.getData()), cdesc.getData().length());
        }
    }

    public Object getDefaultValue(String dbDefaultValue) {
        if (dbDefaultValue != null) {
            StringBuffer mbuf = new StringBuffer();
            Object newObject = this.validateAndConvert(dbDefaultValue, null, mbuf);
            if (mbuf.length() == 0) {
                return newObject;
            }
        }
        if (this._isNullable) {
            return null;
        }
        return null;
    }

    public boolean canDoFileIO() {
        return true;
    }

    public String importObject(FileInputStream inStream) throws IOException {
        InputStreamReader inReader = new InputStreamReader(inStream);
        int fileSize = inStream.available();
        char[] charBuf = new char[fileSize];
        int count = inReader.read(charBuf, 0, fileSize);
        if (count != fileSize) {
            throw new IOException("Could read only " + count + " chars from a total file size of " + fileSize + ". Import failed.");
        }
        String fileText = charBuf[count - 1] == '\n' ? new String(charBuf, 0, count - 1) : new String(charBuf);
        StringBuffer messageBuffer = new StringBuffer();
        this.validateAndConvertInPopup(fileText, null, messageBuffer);
        if (messageBuffer.length() > 0) {
            throw new IOException("Text does not represent data of type " + this.getClassName() + ".  Text was:\n" + fileText);
        }
        return fileText;
    }

    public void exportObject(FileOutputStream outStream, String text) throws IOException {
        OutputStreamWriter outWriter = new OutputStreamWriter(outStream);
        StringBuffer messageBuffer = new StringBuffer();
        this.validateAndConvertInPopup(text, null, messageBuffer);
        if (messageBuffer.length() > 0) {
            throw new IOException(new String(messageBuffer));
        }
        outWriter.write(text);
        outWriter.flush();
        outWriter.close();
    }

    public static OkJPanel getControlPanel() {
        DataTypeClob.loadProperties();
        return new ClobOkJPanel();
    }

    private static class ClobOkJPanel
    extends OkJPanel {
        private JCheckBox _showClobChk = new JCheckBox("Read contents when table is first loaded;");
        private RightLabel _typeDropLabel = new RightLabel("Read");
        private ReadTypeCombo _clobTypeDrop = new ReadTypeCombo();
        private IntegerField _showClobSizeField = new IntegerField(5);
        private JCheckBox _makeNewlinesVisibleInCellChk = new JCheckBox("Show newlines as \\n within cells");

        public ClobOkJPanel() {
            this._showClobChk.setSelected(_readClobs);
            this._showClobChk.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ ClobOkJPanel this$0;
                {
                    this.this$0 = this$0;
                }

                public void stateChanged(ChangeEvent e) {
                    ClobOkJPanel.access$700(this.this$0).setEnabled(ClobOkJPanel.access$600(this.this$0).isSelected());
                    ClobOkJPanel.access$800(this.this$0).setEnabled(ClobOkJPanel.access$600(this.this$0).isSelected());
                    ClobOkJPanel.access$900(this.this$0).setEnabled(ClobOkJPanel.access$600(this.this$0).isSelected() && ClobOkJPanel.access$700(this.this$0).getSelectedIndex() == 0);
                }
            });
            this._clobTypeDrop = new ReadTypeCombo();
            this._clobTypeDrop.setSelectedIndex(_readCompleteClobs ? 1 : 0);
            this._clobTypeDrop.addActionListener(new ActionListener(this){
                private final /* synthetic */ ClobOkJPanel this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent e) {
                    ClobOkJPanel.access$900(this.this$0).setEnabled(ClobOkJPanel.access$700(this.this$0).getSelectedIndex() == 0);
                }
            });
            this._showClobSizeField = new IntegerField(5);
            this._showClobSizeField.setInt(_readClobsSize);
            this._makeNewlinesVisibleInCellChk.setSelected(_makeNewlinesVisibleInCell);
            this._clobTypeDrop.setEnabled(_readClobs);
            this._typeDropLabel.setEnabled(_readClobs);
            this._showClobSizeField.setEnabled(_readClobs && !_readCompleteClobs);
            this.setLayout(new GridBagLayout());
            this.setBorder(BorderFactory.createTitledBorder("CLOB   (SQL type 2005)"));
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.insets = new Insets(4, 4, 4, 4);
            gbc.anchor = 17;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.gridwidth = 1;
            this.add((Component)this._showClobChk, gbc);
            ++gbc.gridx;
            this.add((Component)this._typeDropLabel, gbc);
            ++gbc.gridx;
            this.add((Component)this._clobTypeDrop, gbc);
            ++gbc.gridx;
            this.add((Component)this._showClobSizeField, gbc);
            ++gbc.gridy;
            gbc.gridx = 0;
            gbc.gridwidth = 0;
            this.add((Component)this._makeNewlinesVisibleInCellChk, gbc);
        }

        public void ok() {
            _readClobs = this._showClobChk.isSelected();
            DTProperties.put(DataTypeClob.thisClassName, "readClobs", Boolean.toString(_readClobs));
            _readCompleteClobs = this._clobTypeDrop.getSelectedIndex() != 0;
            DTProperties.put(DataTypeClob.thisClassName, "readCompleteClobs", Boolean.toString(_readCompleteClobs));
            _readClobsSize = this._showClobSizeField.getInt();
            DTProperties.put(DataTypeClob.thisClassName, "readClobsSize", Integer.toString(_readClobsSize));
            _makeNewlinesVisibleInCell = this._makeNewlinesVisibleInCellChk.isSelected();
            DTProperties.put(DataTypeClob.thisClassName, "makeNewlinesVisibleInCell", Boolean.toString(_makeNewlinesVisibleInCell));
        }

        static /* synthetic */ JCheckBox access$600(ClobOkJPanel x0) {
            return x0._showClobChk;
        }

        static /* synthetic */ ReadTypeCombo access$700(ClobOkJPanel x0) {
            return x0._clobTypeDrop;
        }

        static /* synthetic */ RightLabel access$800(ClobOkJPanel x0) {
            return x0._typeDropLabel;
        }

        static /* synthetic */ IntegerField access$900(ClobOkJPanel x0) {
            return x0._showClobSizeField;
        }
    }

    private class KeyTextHandler
    extends KeyAdapter {
        private KeyTextHandler() {
        }

        public void keyTyped(KeyEvent e) {
            char c = e.getKeyChar();
            JTextComponent _theComponent = (JTextComponent)((Object)DataTypeClob.this._textComponent);
            String text = _theComponent.getText();
            if (DataTypeClob.this._isNullable) {
                if (text.equals("<null>")) {
                    if (c == '\b' || c == '\u007f') {
                        DataTypeClob.this._textComponent.restoreText();
                        e.consume();
                    } else {
                        DataTypeClob.this._textComponent.updateText("");
                    }
                } else if ((c == '\b' || c == '\u007f') && text.length() <= 1) {
                    DataTypeClob.this._textComponent.updateText("<null>");
                    e.consume();
                }
            } else if (text.length() == 0 && c == '\b' || c == '\u007f') {
                DataTypeClob.this._textComponent.restoreText();
                e.consume();
            }
        }
    }
}

